/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.PluginUtil;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.wizards.ConvertEnterpriseTypesPage;

public class ConvertToEnterpriseTypesWizard
extends AbstractWizard
implements UiConstants {
    public static boolean HEADLESS = false;
    private final PluginUtil Util = UiConstants.Util;
    private final DatatypeManager dtMgr = ModelerCore.getWorkspaceDatatypeManager();
    private final StringBuffer messages = new StringBuffer();
    protected ConvertEnterpriseTypesPage convertTypesPage;
    protected ISelection selection;
    private IWizardPage[] wizardPageArray;
    private Resource selectedResource;
    private ModelResource selectedModelResource;

    public ConvertToEnterpriseTypesWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), UiConstants.Util.getString("ConvertToEnterpriseTypesWizard.title", new Object[0]), null);
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.convertTypesPage = new ConvertEnterpriseTypesPage(this.selectedResource);
        this.addPage((IWizardPage)this.convertTypesPage);
    }

    public boolean finish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ConvertToEnterpriseTypesWizard.this.doFinish(monitor);
            }
        };
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)this.getWindowTitle(), (Object)this);
        try {
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, false, op);
            }
            catch (Throwable err) {
                this.Util.log(4, err, err.getMessage());
                if (startedTxn) {
                    ModelerCore.commitTxn();
                }
            }
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        return true;
    }

    public void doFinish(IProgressMonitor monitor) {
        if (this.convertTypesPage == null) {
            String msg = UiConstants.Util.getString("ConvertToEnterpriseTypesWizard.noInit", new Object[0]);
            this.messages.append(msg);
            return;
        }
        XSDSchema schema = null;
        for (XSDSimpleTypeDefinition next : this.convertTypesPage.getTypesToConvert()) {
            if (schema == null) {
                schema = next.getSchema();
                schema.setIncrementalUpdate(false);
            }
            EnterpriseDatatypeInfo edi = this.getEDIForType(next);
            ModelerCore.getModelEditor().setEnterpriseDatatypePropertyValue((EObject)next, (Object)edi);
        }
        if (schema != null) {
            schema.setIncrementalUpdate(true);
        }
        try {
            if (this.selectedResource != null) {
                this.selectedResource.save(new HashMap());
            } else if (this.selectedModelResource != null) {
                this.selectedModelResource.save(monitor, false);
            }
        }
        catch (Exception err) {
            String msg = UiConstants.Util.getString("ConvertToEnterpriseTypesWizard.saveErr", new Object[0]);
            this.messages.append(msg);
            this.Util.log(4, (Throwable)err, msg);
        }
        if (this.messages.length() > 0) {
            this.Util.log(4, this.messages.toString());
        }
    }

    private EnterpriseDatatypeInfo getEDIForType(XSDSimpleTypeDefinition type) {
        EnterpriseDatatypeInfo edi = new EnterpriseDatatypeInfo();
        Object superType = type;
        XSDSimpleTypeDefinition enterpriseParent = null;
        while (superType != null && enterpriseParent == null) {
            if (this.dtMgr.isEnterpriseDatatype((EObject)superType)) {
                enterpriseParent = superType;
                continue;
            }
            XSDSimpleTypeDefinition tmp = superType.getBaseTypeDefinition();
            superType = tmp != superType ? superType.getBaseTypeDefinition() : null;
        }
        if (enterpriseParent != null) {
            edi.setRuntimeTypeFixed(this.dtMgr.getRuntimeTypeFixed(enterpriseParent));
            edi.setRuntimeType(this.dtMgr.getRuntimeTypeName((EObject)enterpriseParent));
        }
        ModelEditorImpl.fillWithDefaultValues((EnterpriseDatatypeInfo)edi, (XSDSimpleTypeDefinition)type);
        return edi;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (SelectionUtilities.isSingleSelection((ISelection)selection)) {
            Object sel = SelectionUtilities.getSelectedObject((ISelection)selection);
            if (sel instanceof IFile) {
                ModelResource modelResource;
                this.selectedModelResource = modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)sel));
                try {
                    this.selectedResource = modelResource.getEmfResource();
                }
                catch (ModelWorkspaceException modelWorkspaceException) {}
            } else if (sel instanceof Resource) {
                this.selectedResource = (Resource)sel;
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.convertTypesPage) {
            return null;
        }
        int i = 0;
        while (i < this.wizardPageArray.length) {
            if (this.wizardPageArray[i] == page && i + 1 < this.wizardPageArray.length) {
                return this.wizardPageArray[i + 1];
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.convertTypesPage) {
            result = currentPage.isPageComplete();
        } else {
            boolean lastPage = currentPage == this.wizardPageArray[this.wizardPageArray.length - 1];
            result = lastPage && currentPage.isPageComplete();
        }
        return result;
    }

    public int getPageCount() {
        if (this.wizardPageArray != null) {
            return this.wizardPageArray.length + 1;
        }
        return 1;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.wizardPageArray == null || page == this.convertTypesPage) {
            return null;
        }
        if (page == this.wizardPageArray[0]) {
            return this.convertTypesPage;
        }
        int i = 1;
        while (i < this.wizardPageArray.length) {
            if (page == this.wizardPageArray[i]) {
                return this.wizardPageArray[i - 1];
            }
            ++i;
        }
        return null;
    }

    public StringBuffer getMessages() {
        return this.messages;
    }
}

