/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceFilter;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceSelections;
import org.teiid.designer.core.workspace.ModelWorkspaceView;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.wizards.ModelerProjectZipOperation;

public final class ExportModelerProjectSetWizard
extends AbstractWizard
implements FileUtils.Constants,
IExportWizard,
InternalUiConstants.Widgets,
PluginConstants.Images,
CoreStringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ExportModelerProjectSetWizard.class);
    private static final ImageDescriptor IMAGE = UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/export_project.gif");
    private static final String TITLE = ExportModelerProjectSetWizard.getString("title");
    private static final String PAGE_TITLE = ExportModelerProjectSetWizard.getString("pageTitle");
    private static final String FILE_DIALOG_TITLE = ExportModelerProjectSetWizard.getString("fileDialogTitle");
    private static final String PROJECTS_GROUP = ExportModelerProjectSetWizard.getString("projectsGroup");
    private static final String FILE_GROUP = ExportModelerProjectSetWizard.getString("fileGroup");
    private static final String FILE_LABEL = ExportModelerProjectSetWizard.getString("fileLabel");
    private static final String FILE_BUTTON = ExportModelerProjectSetWizard.getString("browse_3");
    private static final String INITIAL_MESSAGE = ExportModelerProjectSetWizard.getString("initialMessage");
    private static final String NO_SELECTIONS_MESSAGE = ExportModelerProjectSetWizard.getString("noSelectionsMessage");
    private static final String NESTED_PROJECT_MESSAGE = ExportModelerProjectSetWizard.getString("nestedProjectMessage");
    private static final String NESTED_PROJECT_ERROR = ExportModelerProjectSetWizard.getString("nestedProjectError");
    private static final String NO_FILE_MESSAGE = ExportModelerProjectSetWizard.getString("noFileMessage");
    private static final String INVALID_FILE_MESSAGE = ExportModelerProjectSetWizard.getString("invalidFileMessage");
    private static final String FILE_IMPORT_TAG = ".zip";
    private static final String OPTIONS_GROUP_LABEL = ExportModelerProjectSetWizard.getString("optionsGroup.label");
    private static final String CLEAR_CONNECTION_INFO_LABEL = ExportModelerProjectSetWizard.getString("clearConnectionInfo.label");
    private static final String STORE_ZIP_FILE_NAMES_ID = ExportModelerProjectSetWizard.getString("storeZipFileNamesId");
    private static boolean exportLicensed = false;
    private boolean projectsSelected = false;
    private ModelWorkspaceSelections selections;
    private File targetZipFileName;
    private IStructuredSelection selection;
    private WizardPage page1;
    private CheckboxTreeViewer viewer;
    private Combo zipFileCombo;
    private Button clearConnectionInfoCheckBox;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ExportModelerProjectSetWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, IMAGE);
    }

    public void createPageControls(Composite pageContainer) {
        if (exportLicensed) {
            super.createPageControls(pageContainer);
        }
        this.page1.setMessage(INITIAL_MESSAGE);
    }

    public boolean finish() {
        List selectedProjects = this.getSelectedProjects();
        if (this.targetZipFileName.exists() && !WidgetUtil.confirmOverwrite((File)this.targetZipFileName)) {
            return false;
        }
        this.saveWidgetValues();
        if (selectedProjects.size() > 0) {
            return this.executeExportOperation(new ModelerProjectZipOperation(selectedProjects, this.targetZipFileName.getAbsolutePath(), this.clearConnectionInfoCheckBox.getSelection()));
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.selections = new ModelWorkspaceSelections();
        this.page1 = new AbstractWizardPage(ExportModelerProjectSetWizard.class.getSimpleName(), PAGE_TITLE){

            public void createControl(Composite parent) {
                this.setControl((Control)ExportModelerProjectSetWizard.this.createPageControl(parent));
            }
        };
        this.addPage((IWizardPage)this.page1);
    }

    Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    Composite createPageControl(Composite parent) {
        Composite pg = new Composite(parent, 0);
        pg.setLayout((Layout)new GridLayout());
        Group group = WidgetFactory.createGroup((Composite)pg, (String)PROJECTS_GROUP, (int)1808);
        this.viewer = (CheckboxTreeViewer)WidgetFactory.createTreeViewer((Composite)group, (int)34);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportModelerProjectSetWizard.this.validatePage();
            }
        });
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        final ModelWorkspaceView view = new ModelWorkspaceView();
        view.setRestrictedToModelWorkspaceItemsOnly(true);
        view.getModelWorkspaceFilters().add(new ModelWorkspaceFilter(){

            public boolean select(Object parent, Object node) {
                if (node instanceof ModelProject && ((ModelProject)node).isOpen()) {
                    try {
                        if (!((ModelProject)node).getProject().hasNature("org.teiid.designer.core.hiddenProjectNature")) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        Util.log((Throwable)e);
                    }
                }
                return false;
            }
        });
        this.selections.setModelWorkspaceView(view);
        ITreeContentProvider treeContentProvider = new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object node) {
                return EMPTY_STRING_ARRAY;
            }

            public Object[] getElements(Object inputElement) {
                try {
                    return view.getChildren((Object)ModelerCore.getModelWorkspace());
                }
                catch (ModelWorkspaceException err) {
                    Util.log((Throwable)err);
                    return EMPTY_STRING_ARRAY;
                }
            }

            public Object getParent(Object node) {
                return null;
            }

            public boolean hasChildren(Object node) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.viewer.setContentProvider((IContentProvider)treeContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            final WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();

            public Image getImage(Object node) {
                if (node instanceof EObject) {
                    return ModelUtilities.getEMFLabelProvider().getImage(node);
                }
                return this.workbenchProvider.getImage((Object)((ModelWorkspaceItem)node).getResource());
            }

            public String getText(Object node) {
                if (node instanceof EObject) {
                    return ModelUtilities.getEMFLabelProvider().getText(node);
                }
                return this.workbenchProvider.getText((Object)((ModelWorkspaceItem)node).getResource());
            }
        });
        this.viewer.setInput((Object)this);
        Group optionsGroup = WidgetFactory.createGroup((Composite)pg, (String)OPTIONS_GROUP_LABEL, (int)768);
        this.clearConnectionInfoCheckBox = new Button((Composite)optionsGroup, 32);
        this.clearConnectionInfoCheckBox.setText(CLEAR_CONNECTION_INFO_LABEL);
        IDialogSettings settings = this.getDialogSettings();
        group = WidgetFactory.createGroup((Composite)pg, (String)FILE_GROUP, (int)768, (int)1, (int)3);
        WidgetFactory.createLabel((Composite)group, (String)FILE_LABEL);
        this.zipFileCombo = WidgetFactory.createCombo((Composite)group, (int)0, (int)768, (Object[])settings.getArray(FILE_LABEL));
        this.zipFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportModelerProjectSetWizard.this.handleSourceFileChanged();
            }
        });
        WidgetFactory.createButton((Composite)group, (String)FILE_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportModelerProjectSetWizard.this.handleBrowseButtonSelected();
            }
        });
        if (this.selection != null) {
            for (Object obj : this.selection) {
                IPath path;
                IPath iPath = path = obj instanceof IResource ? ((IResource)obj).getFullPath() : view.getPath(obj);
                if (path == null) continue;
                try {
                    Object proj = view.findObject(path);
                    if (proj == null) continue;
                    this.viewer.setChecked(proj, true);
                }
                catch (ModelWorkspaceException err) {
                    Util.log((Throwable)err);
                    WidgetUtil.showError((Throwable)err);
                }
            }
        }
        this.restoreWidgetValues();
        this.page1.setMessage(INITIAL_MESSAGE);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExportModelerProjectSetWizard.this.validatePage();
            }
        });
        return pg;
    }

    void handleBrowseButtonSelected() {
        FileDialog dlg = new FileDialog(this.getShell(), 8196);
        dlg.setText(FILE_DIALOG_TITLE);
        String someName = dlg.open();
        if (someName != null) {
            this.zipFileCombo.setText(someName);
        }
        this.validatePage();
    }

    void handleSourceFileChanged() {
        String someName = this.zipFileCombo.getText();
        if (someName != null && someName.length() > 0) {
            char lastChr = someName.charAt(someName.length() - 1);
            if (someName.indexOf(FILE_EXTENSION_SEPARATOR) < 0 && lastChr != ':' && lastChr != '\\' && lastChr != '/') {
                someName = String.valueOf(someName) + FILE_IMPORT_TAG;
            }
            this.targetZipFileName = new File(someName);
        } else {
            this.targetZipFileName = null;
        }
        this.validatePage();
    }

    void validatePage() {
        if (this.viewer.getCheckedElements().length == 0) {
            WizardUtil.setPageComplete((WizardPage)this.page1, (String)NO_SELECTIONS_MESSAGE, (int)3);
            this.projectsSelected = false;
            return;
        }
        this.projectsSelected = true;
        List projects = this.getSelectedProjects();
        try {
            int i = 0;
            while (i < projects.size()) {
                if (DotProjectUtils.getDotProjectCount((IResource)((IContainer)projects.get(i)), (boolean)true, (boolean)true) > 1) {
                    WizardUtil.setPageComplete((WizardPage)this.page1, (String)NESTED_PROJECT_MESSAGE, (int)3);
                    return;
                }
                ++i;
            }
        }
        catch (Exception ce) {
            ce.printStackTrace();
            WizardUtil.setPageComplete((WizardPage)this.page1, (String)NESTED_PROJECT_ERROR, (int)3);
            return;
        }
        if (this.targetZipFileName == null) {
            WizardUtil.setPageComplete((WizardPage)this.page1, (String)NO_FILE_MESSAGE, (int)3);
            return;
        }
        if (this.targetZipFileName.isDirectory() || !FileUtils.isFilenameValid((String)this.targetZipFileName.getName())) {
            WizardUtil.setPageComplete((WizardPage)this.page1, (String)INVALID_FILE_MESSAGE, (int)3);
            return;
        }
        if (this.targetZipFileName.exists()) {
            WizardUtil.setPageComplete((WizardPage)this.page1, (String)WidgetUtil.getFileExistsMessage((File)this.targetZipFileName), (int)2);
            return;
        }
        WizardUtil.setPageComplete((WizardPage)this.page1);
    }

    public boolean canFinish() {
        return this.projectsSelected && this.page1.isPageComplete();
    }

    private List getSelectedProjects() {
        Object[] checkedProjects = this.viewer.getCheckedElements();
        ArrayList<IResource> objs = new ArrayList<IResource>(checkedProjects.length);
        int i = 0;
        while (i < checkedProjects.length) {
            ModelProject proj = (ModelProject)checkedProjects[i];
            objs.add(proj.getResource());
            ++i;
        }
        if (objs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return objs;
    }

    protected boolean executeExportOperation(ModelerProjectZipOperation op) {
        op.setCreateLeadupStructure(true);
        op.setUseCompression(true);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            String message = e.getTargetException().getMessage();
            if (message == null || message.length() == 0) {
                message = ExportModelerProjectSetWizard.getString("exportProblemsMessage");
            }
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)ExportModelerProjectSetWizard.getString("exportProblemsTitle"), (String)message, (IStatus)op.getStatus());
            Util.log(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)ExportModelerProjectSetWizard.getString("exportProblemsTitle"), null, (IStatus)status);
            Util.log(status);
            return false;
        }
        return true;
    }

    protected void setZipFileName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.zipFileCombo.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.zipFileCombo.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.zipFileCombo.select(selectionIndex);
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        WidgetUtil.removeMissingResources((IDialogSettings)settings, (String)STORE_ZIP_FILE_NAMES_ID);
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_ZIP_FILE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.zipFileCombo.add(sourceNames[i]);
                ++i;
            }
            this.zipFileCombo.select(0);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_ZIP_FILE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.getLastTwentyComboNames(sourceNames);
            settings.put(STORE_ZIP_FILE_NAMES_ID, sourceNames);
        }
    }

    private String[] getLastTwentyComboNames(String[] currentArray) {
        int nValues = currentArray.length;
        ArrayList<String> nonDuplicates = new ArrayList<String>(nValues);
        String currentZipName = this.zipFileCombo.getText();
        if (currentZipName == null) {
            return currentArray;
        }
        int i = 0;
        while (i < nValues) {
            if (!currentArray[i].equals(currentZipName)) {
                nonDuplicates.add(currentArray[i]);
            }
            ++i;
        }
        Object[] newArray = nonDuplicates.toArray();
        int newArrayLength = newArray.length + 1;
        String[] newStrings = new String[newArrayLength];
        newStrings[0] = currentZipName;
        int i2 = 0;
        while (i2 < newArray.length) {
            if (i2 > 18) break;
            newStrings[i2 + 1] = (String)newArray[i2];
            ++i2;
        }
        return newStrings;
    }
}

