/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.metamodels.xsd.XsdBuilderOptions;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.ui.wizards.GenerateXsdWizard;

public class GenerateXsdWizardOptionslPage
extends WizardPage
implements InternalUiConstants.Widgets,
UiConstants {
    private static final String XSD_EXT = ".xsd";
    private static final String XMI_EXT = ".xmi";
    private final Collection unsavedResources = new HashSet();
    private final Collection invalidResources = new HashSet();
    private final Collection unvalidatedResources = new HashSet();
    private boolean validResources;
    private Button genSqlButton;
    private Button genInputButton;
    private Button doFlatOutputButton;
    private Button doFlatInputButton;
    Text outputNameText;
    Text inputNameText;
    Text wsNameText;
    private LinkedHashSet roots;
    String rootName;
    private String parentPath;
    private Text containerText;
    private ISelection selection;
    private IContainer folder;
    private boolean initializing = false;

    public GenerateXsdWizardOptionslPage(ISelection selection) {
        super("optionsPage");
        this.setTitle(Util.getString("GenerateXsdWizard.title", new Object[0]));
        this.setDescription(Util.getString("GenerateXsdWizard.optionsDesc", new Object[0]));
        this.selection = selection;
    }

    private void setDefaults() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GenerateXsdWizardOptionslPage.this.rootName != null) {
                    GenerateXsdWizardOptionslPage.this.outputNameText.setText(String.valueOf(GenerateXsdWizardOptionslPage.this.rootName) + Util.getString("GenerateXsdWizard.outSuffix", new Object[0]));
                    GenerateXsdWizardOptionslPage.this.inputNameText.setText(String.valueOf(GenerateXsdWizardOptionslPage.this.rootName) + Util.getString("GenerateXsdWizard.inSuffix", new Object[0]));
                    GenerateXsdWizardOptionslPage.this.wsNameText.setText(String.valueOf(GenerateXsdWizardOptionslPage.this.rootName) + Util.getString("GenerateXsdWizard.wsSuffix", new Object[0]));
                }
            }
        });
    }

    public void createControl(Composite parent) {
        DefaultScrolledComposite mainScrolledPanel = new DefaultScrolledComposite(parent);
        Composite container = mainScrolledPanel.getPanel();
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Group locationGroup = WidgetFactory.createGroup((Composite)container, (String)Util.getString("GenerateXsdWizard.locationGroup.label", new Object[0]), (int)1808, (int)1, (int)3);
        Label locationMsg = new Label((Composite)locationGroup, 0);
        GridData locationMsgGridData = new GridData();
        locationMsgGridData.horizontalSpan = 3;
        locationMsg.setLayoutData((Object)locationMsgGridData);
        locationMsg.setText(Util.getString("GenerateXsdWizard.locationMessage", new Object[0]));
        this.containerText = new Text((Composite)locationGroup, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateXsdWizardOptionslPage.this.checkStatus();
            }
        });
        this.containerText.setEditable(false);
        Button browseButton = new Button((Composite)locationGroup, 8);
        GridData buttonGridData = new GridData();
        browseButton.setLayoutData((Object)buttonGridData);
        browseButton.setText(Util.getString("GenerateXsdWizard.browse", new Object[0]));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateXsdWizardOptionslPage.this.handleBrowse();
            }
        });
        Group modelsGroup = WidgetFactory.createGroup((Composite)container, (String)Util.getString("GenerateXsdWizard.modelDefinition", new Object[0]), (int)1808, (int)1, (int)4);
        this.genInputButton = new Button((Composite)modelsGroup, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 1;
        this.genInputButton.setLayoutData((Object)buttonGridData);
        this.genInputButton.setText(Util.getString("GenerateXsdWizard.generate", new Object[0]));
        this.genInputButton.setToolTipText(Util.getString("GenerateXsdWizard.generateInputSchemaModel", new Object[0]));
        this.genInputButton.setSelection(true);
        this.genInputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateXsdWizardOptionslPage.this.handleGenInputButton();
            }
        });
        Label inputNameLabel = new Label((Composite)modelsGroup, 0);
        inputNameLabel.setText("Input Schema");
        this.inputNameText = new Text((Composite)modelsGroup, 2052);
        gd = new GridData(768);
        this.inputNameText.setLayoutData((Object)gd);
        this.inputNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateXsdWizardOptionslPage.this.checkStatus();
            }
        });
        this.doFlatInputButton = new Button((Composite)modelsGroup, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 1;
        this.doFlatInputButton.setLayoutData((Object)buttonGridData);
        this.doFlatInputButton.setText(Util.getString("GenerateXsdWizard.doFlat", new Object[0]));
        this.doFlatInputButton.setToolTipText(Util.getString("GenerateXsdWizard.doFlatInputTooltip", new Object[0]));
        this.doFlatInputButton.setSelection(true);
        this.doFlatInputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateXsdWizardOptionslPage.this.doFlatOutputButton.setSelection(GenerateXsdWizardOptionslPage.this.doFlatInputButton.getSelection());
            }
        });
        GridData spGridData = null;
        Label spacer = new Label((Composite)modelsGroup, 0);
        spGridData = new GridData();
        spGridData.horizontalSpan = 1;
        spacer.setLayoutData((Object)spGridData);
        Label modelNameLabel = new Label((Composite)modelsGroup, 0);
        modelNameLabel.setText("Output Schema");
        this.outputNameText = new Text((Composite)modelsGroup, 2052);
        GridData outputGridData = new GridData(768);
        outputGridData.minimumWidth = 200;
        this.outputNameText.setLayoutData((Object)outputGridData);
        this.outputNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateXsdWizardOptionslPage.this.checkStatus();
            }
        });
        this.doFlatOutputButton = new Button((Composite)modelsGroup, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 1;
        this.doFlatOutputButton.setLayoutData((Object)buttonGridData);
        this.doFlatOutputButton.setText(Util.getString("GenerateXsdWizard.doFlat", new Object[0]));
        this.doFlatOutputButton.setToolTipText(Util.getString("GenerateXsdWizard.doFlatOutputTooltip", new Object[0]));
        this.doFlatOutputButton.setSelection(true);
        this.doFlatOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateXsdWizardOptionslPage.this.doFlatInputButton.setSelection(GenerateXsdWizardOptionslPage.this.doFlatOutputButton.getSelection());
            }
        });
        spacer = new Label((Composite)modelsGroup, 0);
        spGridData = new GridData();
        spGridData.horizontalSpan = 1;
        spacer.setLayoutData((Object)spGridData);
        Label wsNameLabel = new Label((Composite)modelsGroup, 0);
        wsNameLabel.setText("Web Service");
        this.wsNameText = new Text((Composite)modelsGroup, 2052);
        gd = new GridData(768);
        this.wsNameText.setLayoutData((Object)gd);
        this.wsNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateXsdWizardOptionslPage.this.checkStatus();
            }
        });
        this.genSqlButton = new Button((Composite)modelsGroup, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 1;
        this.genSqlButton.setLayoutData((Object)buttonGridData);
        this.genSqlButton.setText(Util.getString("GenerateXsdWizard.genSql", new Object[0]));
        this.genSqlButton.setSelection(true);
        this.setControl((Control)container);
        this.checkStatus();
        this.outputNameText.setFocus();
        this.setDefaults();
        this.initialize();
        mainScrolledPanel.sizeScrolledPanel();
    }

    void handleBrowse() {
        this.folder = WidgetUtil.showFolderSelectionDialog((IContainer)((IContainer)this.getTargetContainer()), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (this.folder != null && this.containerText != null) {
            this.containerText.setText(this.folder.getFullPath().makeRelative().toString());
            this.setParentPath(this.folder);
        }
        this.checkStatus();
    }

    void handleGenInputButton() {
        this.inputNameText.setEnabled(this.genInputButton.getSelection());
        this.doFlatInputButton.setEnabled(this.genInputButton.getSelection());
        this.checkStatus();
    }

    private void initialize() {
        block14: {
            block13: {
                Object sel;
                block15: {
                    this.initializing = true;
                    this.roots = new LinkedHashSet();
                    if (SelectionUtilities.isEmptySelection((ISelection)this.selection)) {
                        return;
                    }
                    if (!SelectionUtilities.isSingleSelection((ISelection)this.selection)) break block13;
                    sel = SelectionUtilities.getSelectedObject((ISelection)this.selection);
                    this.processRootObject(sel, true);
                    if (sel instanceof IFile) {
                        String name = ((IFile)sel).getName();
                        this.rootName = name.endsWith(XMI_EXT) ? name.substring(0, name.indexOf(XMI_EXT)) : name;
                    } else if (sel instanceof RelationalEntity) {
                        String name;
                        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((RelationalEntity)sel));
                        this.rootName = mr != null ? ((name = mr.getItemName()).endsWith(XMI_EXT) ? name.substring(0, name.indexOf(XMI_EXT)) : name) : ((RelationalEntity)sel).getName();
                    }
                    if (this.selection == null || this.selection.isEmpty() || !(this.selection instanceof IStructuredSelection)) break block14;
                    IStructuredSelection ssel = (IStructuredSelection)this.selection;
                    if (ssel.size() > 1) {
                        return;
                    }
                    Object obj = ssel.getFirstElement();
                    if (!(obj instanceof IResource)) break block15;
                    IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                    if (this.containerText != null) {
                        this.containerText.setText(container.getFullPath().makeRelative().toString());
                    }
                    this.setParentPath(container);
                    this.folder = container;
                    break block14;
                }
                if (!(sel instanceof RelationalEntity)) break block14;
                ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((RelationalEntity)sel));
                if (mr != null) {
                    IResource theResource = null;
                    try {
                        theResource = mr.getCorrespondingResource();
                    }
                    catch (ModelWorkspaceException theException) {
                        Util.log((Throwable)theException);
                    }
                    if (theResource != null) {
                        IContainer container = theResource.getParent();
                        if (this.containerText != null && container != null) {
                            this.containerText.setText(container.getFullPath().makeRelative().toString());
                        }
                        this.setParentPath(container);
                        this.folder = container;
                    }
                } else {
                    this.rootName = ((RelationalEntity)sel).getName();
                }
                break block14;
            }
            List objs = SelectionUtilities.getSelectedObjects((ISelection)this.selection);
            Iterator selections = objs.iterator();
            while (selections.hasNext()) {
                this.processRootObject(selections.next(), true);
            }
        }
        this.initializing = false;
    }

    private void addRootsFromResource(Resource rsrc) {
        if (this.parentPath == null) {
            URI uri = rsrc.getURI().trimSegments(1);
            this.parentPath = uri.toString();
        }
        TreeIterator contents = rsrc.getAllContents();
        while (contents.hasNext()) {
            this.processRootObject(contents.next(), false);
        }
    }

    private void setParentPath(Object root) {
        ModelResource modelResource;
        if (root instanceof IContainer) {
            this.parentPath = ((IContainer)root).getLocation().toString();
        } else if (root instanceof EObject) {
            URI uri = ((EObject)root).eResource().getURI().trimSegments(1);
            this.parentPath = uri.toFileString();
        } else if (root instanceof Resource) {
            URI uri = ((Resource)root).getURI().trimSegments(1);
            this.parentPath = uri.toFileString();
        } else if (root instanceof IFile && (modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)root))) != null) {
            try {
                Resource rsrc = modelResource.getEmfResource();
                URI uri = rsrc.getURI().trimSegments(1);
                this.parentPath = uri.toFileString();
            }
            catch (ModelWorkspaceException err) {
                Util.log((Throwable)err);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processRootObject(Object root, boolean validateResource) {
        if (root instanceof BaseTable || root instanceof View) {
            if (validateResource) {
                this.validateResource(root);
            }
            this.addRoot(root);
            return;
        } else if (root instanceof Procedure) {
            ProcedureResult res;
            if (validateResource) {
                this.validateResource(root);
            }
            if ((res = ((Procedure)root).getResult()) != null) {
                this.addRoot(res);
            }
            for (ProcedureParameter param : ((Procedure)root).getParameters()) {
                DirectionKind dir = param.getDirection();
                if (!dir.equals(DirectionKind.OUT_LITERAL) && !dir.equals(DirectionKind.INOUT_LITERAL) && !dir.equals(DirectionKind.RETURN_LITERAL) || res != null) continue;
                this.addRoot(root);
            }
            return;
        } else {
            ModelResource modelResource;
            if (!(root instanceof IFile) || (modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)root))) == null) return;
            try {
                this.validateResource(modelResource);
                Resource rsrc = modelResource.getEmfResource();
                if (!this.validResources || !this.isRelationalModel(rsrc)) return;
                this.addRootsFromResource(rsrc);
                return;
            }
            catch (ModelWorkspaceException err) {
                Util.log((Throwable)err);
                return;
            }
        }
    }

    private void addRoot(Object root) {
        if (!this.roots.contains(root)) {
            this.roots.add(root);
        }
    }

    private void validateResource(Object root) {
        this.validResources = true;
        if (GenerateXsdWizard.HEADLESS) {
            return;
        }
        try {
            Resource rsrc;
            ModelResource mr = null;
            if (root instanceof ModelResource) {
                mr = (ModelResource)root;
            } else if (root instanceof EObject && (rsrc = ((EObject)root).eResource()) != null) {
                mr = ModelerCore.getModelWorkspace().findModelResource(rsrc);
            }
            if (mr == null) {
                this.validResources = false;
                return;
            }
            if (this.unsavedResources.contains(mr) || this.invalidResources.contains(mr) || this.unvalidatedResources.contains(mr)) {
                return;
            }
            if (ModelUtilities.requiresValidation(mr)) {
                this.unvalidatedResources.add(mr);
                this.validResources = false;
                return;
            }
            if (mr.hasUnsavedChanges()) {
                this.unsavedResources.add(mr);
                this.validResources = false;
                return;
            }
            IMarker[] problems = mr.getResource().findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            if (problems.length > 0) {
                int i = 0;
                while (i != problems.length) {
                    Integer severity = (Integer)problems[i].getAttribute("severity");
                    if (severity != null && severity == 2) {
                        this.invalidResources.add(mr);
                        this.validResources = false;
                        return;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            this.validResources = false;
        }
    }

    private boolean isRelationalModel(Resource rsrc) {
        if (rsrc == null || !(rsrc instanceof EmfResource)) {
            return false;
        }
        EmfResource eResource = (EmfResource)rsrc;
        ModelAnnotation annot = eResource.getModelAnnotation();
        return annot != null && "http://www.metamatrix.com/metamodels/Relational".equals(annot.getPrimaryMetamodelUri());
    }

    void checkStatus() {
        String wsName;
        if (this.initializing) {
            return;
        }
        boolean hasWarnings = false;
        if (!this.unsavedResources.isEmpty()) {
            this.setErrorMessage(Util.getString("GenerateXsdWizard.unsavedModels", new Object[0]));
            this.setPageComplete(false);
            return;
        }
        if (!this.invalidResources.isEmpty()) {
            this.setErrorMessage(Util.getString("GenerateXsdWizard.invalidModels", new Object[0]));
            this.setPageComplete(false);
            return;
        }
        if (!this.unvalidatedResources.isEmpty()) {
            this.setErrorMessage(Util.getString("GenerateXsdWizard.unvalidatedModels", new Object[0]));
            this.setPageComplete(false);
            return;
        }
        if (!this.validResources) {
            this.setErrorMessage(Util.getString("GenerateXsdWizard.errValidatingModels", new Object[0]));
            this.setPageComplete(false);
            return;
        }
        String modelName = this.outputNameText.getText();
        IStatus status = ModelNameUtil.validate(modelName, XMI_EXT, this.folder, 7);
        if (status.getSeverity() == 4) {
            this.setErrorMessage(String.valueOf(ModelNameUtil.MESSAGES.INVALID_SCHEMA_FILE_NAME) + status.getMessage());
            this.setPageComplete(false);
            return;
        }
        String fullPath = String.valueOf(this.parentPath) + File.separator + modelName + XSD_EXT;
        File file = new File(fullPath);
        if (file.exists()) {
            this.setErrorMessage(Util.getString("GenerateXsdWizard.fileAlreadyExistsMessage", (Object)(String.valueOf(modelName) + XSD_EXT)));
            this.setPageComplete(false);
            return;
        }
        if (this.genInputButton.getSelection()) {
            String inputName = this.inputNameText.getText();
            status = ModelNameUtil.validate(inputName, XSD_EXT, this.folder, 7);
            if (status.getSeverity() == 4) {
                this.setErrorMessage(String.valueOf(ModelNameUtil.MESSAGES.INVALID_SCHEMA_FILE_NAME) + status.getMessage());
                this.setPageComplete(false);
                return;
            }
            fullPath = String.valueOf(this.parentPath) + File.separator + inputName + XSD_EXT;
            file = new File(fullPath);
            if (file.exists()) {
                this.setErrorMessage(Util.getString("GenerateXsdWizard.fileAlreadyExistsMessage", (Object)(String.valueOf(inputName) + XSD_EXT)));
                this.setPageComplete(false);
                return;
            }
        }
        if ((status = ModelNameUtil.validate(wsName = this.wsNameText.getText(), XMI_EXT, this.folder, 7)).getSeverity() == 4) {
            this.setErrorMessage(String.valueOf(ModelNameUtil.MESSAGES.INVALID_VIEW_MODEL_NAME) + status.getMessage());
            this.setPageComplete(false);
            return;
        }
        fullPath = String.valueOf(this.parentPath) + File.separator + wsName + XMI_EXT;
        file = new File(fullPath);
        if (file.exists()) {
            this.setErrorMessage(Util.getString("GenerateXsdWizard.fileAlreadyExistsMessage", (Object)(String.valueOf(wsName) + XMI_EXT)));
            this.setPageComplete(false);
            return;
        }
        if (!hasWarnings) {
            this.setMessage(Util.getString("GenerateXsdWizard.done", new Object[0]), 0);
            this.setErrorMessage(null);
        }
        this.setPageComplete(true);
    }

    public XsdBuilderOptions getOptions() {
        String xsdName = this.outputNameText.getText();
        boolean genSQL = this.genSqlButton.getSelection();
        boolean genInput = this.genInputButton.getSelection();
        String inputName = genInput ? this.inputNameText.getText() : new String();
        String wsName = this.wsNameText.getText();
        boolean doFlat = this.doFlatOutputButton.getSelection() || this.doFlatInputButton.getSelection();
        XsdBuilderOptions ops = new XsdBuilderOptions(true, true, doFlat, (Collection)this.roots, xsdName, genSQL, genInput, inputName, true, wsName, this.rootName);
        ops.setParentPath(this.parentPath);
        return ops;
    }

    public void dispose() {
        super.dispose();
    }

    public IResource getTargetContainer() {
        IWorkspaceRoot root;
        IResource resource;
        IResource result = null;
        String containerName = this.getContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource;
        }
        return result;
    }

    private String getHiddenProjectPath() {
        String result = null;
        IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
        if (hiddenProj != null) {
            result = hiddenProj.getFullPath().makeRelative().toString();
        }
        return result;
    }

    public String getContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.containerText.getText().trim();
        return result;
    }
}

