/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModelerZipExporter {
    private ZipOutputStream outputStream;
    private boolean useCompression = true;
    private boolean clearSourceConnectionInfo = true;

    public ModelerZipExporter(String filename, boolean compress, boolean clearSourceConnectionInfo) throws IOException {
        this.outputStream = new ZipOutputStream(new FileOutputStream(filename));
        this.useCompression = compress;
        this.clearSourceConnectionInfo = clearSourceConnectionInfo;
    }

    public void finished() throws IOException {
        this.outputStream.close();
    }

    protected void write(String pathname, byte[] contents) throws IOException {
        ZipEntry newEntry = new ZipEntry(pathname);
        if (!this.useCompression) {
            newEntry.setMethod(0);
            newEntry.setSize(contents.length);
            CRC32 checksumCalculator = new CRC32();
            checksumCalculator.update(contents);
            newEntry.setCrc(checksumCalculator.getValue());
        }
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.write(contents);
        this.outputStream.closeEntry();
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        ByteArrayOutputStream output = null;
        InputStream contentStream = null;
        Document doc = null;
        if (this.clearSourceConnectionInfo && resource.getFileExtension().equals("xmi")) {
            contentStream = resource.getContents(false);
            doc = this.readXml(contentStream);
            ModelerZipExporter.removeAll(doc, (short)1, "tags", "connection");
            doc.normalize();
            contentStream = this.convertDocToInputStream(doc);
        }
        try {
            output = new ByteArrayOutputStream();
            if (contentStream == null) {
                contentStream = resource.getContents(false);
            }
            int chunkSize = contentStream.available();
            byte[] readBuffer = new byte[chunkSize];
            int n = contentStream.read(readBuffer);
            while (n > 0) {
                output.write(readBuffer);
                n = contentStream.read(readBuffer);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (contentStream != null) {
                contentStream.close();
            }
        }
        this.write(destinationPath, output.toByteArray());
    }

    public static void removeAll(Node node, short nodeType, String name, String filter) {
        if (node.getNodeType() == nodeType && node.getNodeName().equals(name) && node.getAttributes().getNamedItem("key").getTextContent().startsWith(filter)) {
            node.getParentNode().removeChild(node);
        } else {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                ModelerZipExporter.removeAll(list.item(i), nodeType, name, filter);
                ++i;
            }
        }
    }

    public Document readXml(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        return db.parse(is);
    }

    public InputStream convertDocToInputStream(Document doc) throws TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(outputStream);
        TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
        return is;
    }

    class NullResolver
    implements EntityResolver {
        NullResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

