/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.association.AssociationDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.wizards.INewAssociationWizard;
import org.teiid.designer.ui.wizards.INewModelObjectWizard;
import org.teiid.designer.ui.wizards.INewObjectWizard;

public abstract class NewModelObjectWizardManager
implements UiConstants.ExtensionPoints {
    private static HashMap<String, IConfigurationElement> objectWizardMap;
    private static HashMap<String, IConfigurationElement> associationWizardMap;

    public static boolean isObjectDescriptorValid(Shell parent, Command descriptor, ModelResource modelResource, ISelection currentSelection) {
        EObject target;
        boolean result = true;
        if (objectWizardMap == null) {
            objectWizardMap = NewModelObjectWizardManager.loadWizardExtensions("newModelObjectWizard", "class", "descriptorType", "name");
        }
        if ((target = (EObject)descriptor.getResult().iterator().next()) != null) {
            String key = target.eClass().getInstanceClassName();
            IConfigurationElement wizardElement = objectWizardMap.get(key);
            result = wizardElement != null;
        }
        return result;
    }

    public static boolean processObjectDescriptor(Shell parent, Command descriptor, ModelResource modelResource, ISelection currentSelection) {
        EObject target;
        boolean result = true;
        if (objectWizardMap == null) {
            objectWizardMap = NewModelObjectWizardManager.loadWizardExtensions("newModelObjectWizard", "class", "descriptorType", "name");
        }
        if ((target = (EObject)descriptor.getResult().iterator().next()) != null) {
            String key = target.eClass().getInstanceClassName();
            IConfigurationElement wizardElement = objectWizardMap.get(key);
            result = wizardElement == null ? true : NewModelObjectWizardManager.runWizard(parent, wizardElement, descriptor, modelResource, currentSelection, "name");
        }
        return result;
    }

    public static boolean isAssociationDescriptorValid(Shell parent, AssociationDescriptor descriptor, ModelResource modelResource, ISelection currentSelection) {
        String key;
        IConfigurationElement wizardElement;
        boolean result = true;
        if (associationWizardMap == null) {
            associationWizardMap = NewModelObjectWizardManager.loadWizardExtensions("newAssociationWizard", "class", "descriptorType", "name");
        }
        result = (wizardElement = associationWizardMap.get(key = descriptor.getType())) == null ? true : NewModelObjectWizardManager.runWizard(parent, wizardElement, descriptor, modelResource, currentSelection, "name");
        return result;
    }

    public static boolean isAssociationDescriptorValid(Shell parent, AssociationDescriptor descriptor, ISelection currentSelection) {
        return NewModelObjectWizardManager.isAssociationDescriptorValid(parent, descriptor, null, currentSelection);
    }

    private static boolean runWizard(Shell parent, IConfigurationElement wizardConfig, Object descriptor, ModelResource modelResource, ISelection selection, String classElement) {
        boolean result = true;
        try {
            Object extension = wizardConfig.createExecutableExtension(classElement);
            if (extension instanceof INewModelObjectWizard) {
                INewObjectWizard wiz = (INewObjectWizard)extension;
                NewModelObjectWizardManager.initializeWizard(wiz, selection, modelResource, descriptor);
                WizardDialog dialog = new WizardDialog(parent, (IWizard)wiz){

                    public void create() {
                        this.setShellStyle(this.getShellStyle() | 0x10);
                        super.create();
                    }
                };
                dialog.open();
                result = wiz.completedOperation();
            }
        }
        catch (CoreException e) {
            String message = UiConstants.Util.getString("NewModelObjectWizardManager.runWizardErrorMessage", (Object)wizardConfig.getAttribute("name"));
            UiConstants.Util.log(4, (Throwable)e, message);
            String title = UiConstants.Util.getString("NewModelObjectWizardManager.runWizardErrorTitle", new Object[0]);
            MessageDialog.openError((Shell)parent, (String)title, (String)message);
        }
        return result;
    }

    private static void initializeWizard(INewObjectWizard wizard, ISelection selection, ModelResource modelResource, Object descriptor) {
        wizard.setModel(modelResource);
        if (descriptor instanceof AssociationDescriptor) {
            ((INewAssociationWizard)wizard).setAssociationDescriptor((AssociationDescriptor)descriptor);
        } else if (descriptor instanceof Command) {
            ((INewModelObjectWizard)wizard).setCommand((Command)descriptor);
        }
        if (selection instanceof IStructuredSelection) {
            wizard.init(UiPlugin.getDefault().getCurrentWorkbenchWindow().getWorkbench(), (IStructuredSelection)selection);
        } else {
            wizard.init(UiPlugin.getDefault().getCurrentWorkbenchWindow().getWorkbench(), null);
        }
    }

    private static HashMap<String, IConfigurationElement> loadWizardExtensions(String extensionPointId, String classElement, String descriptor, String desctiptorId) {
        HashMap<String, IConfigurationElement> result = new HashMap<String, IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", extensionPointId);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                IConfigurationElement wizardClassElement = null;
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(classElement)) {
                        wizardClassElement = elements[j];
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(descriptor)) {
                        String id = elements[j].getAttribute(desctiptorId);
                        result.put(id, wizardClassElement);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("NewModelObjectWizardManager.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
        return result;
    }
}

