/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerResourceNavigator;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.wizards.FolderUtil;

public class NewModelProjectWizard
extends BasicNewProjectResourceWizard
implements IPropertiesContext,
UiConstants {
    private static String SOURCES = NewModelProjectWizard.getString("sources");
    private static String VIEWS = NewModelProjectWizard.getString("views");
    private static String SCHEMAS = NewModelProjectWizard.getString("schemas");
    private static String FUNCTIONS = NewModelProjectWizard.getString("functions");
    private static String EXTENSIONS = NewModelProjectWizard.getString("extensions");
    private static String WEB_SERVICES = NewModelProjectWizard.getString("web_services");
    public static final String THIS_CLASS = "NewModelProjectWizard";
    private Properties designerProperties;
    private ProjectTemplateOptionsPage optionsPage;
    private static final String[] MODEL_NATURES = new String[]{"org.teiid.designer.core.modelNature"};

    private static String getString(String key) {
        return UiConstants.Util.getString("NewModelProjectWizard." + key, new Object[0]);
    }

    private static String getString(String key, String parameter) {
        return UiConstants.Util.getString("NewModelProjectWizard." + key, (Object)parameter);
    }

    public void addPages() {
        super.addPages();
        IWizardPage mainPage = super.getPage("basicNewProjectPage");
        mainPage.setTitle(Util.getString("NewModelProjectWizard.title", new Object[0]));
        mainPage.setDescription(Util.getString("NewModelProjectWizard.description", new Object[0]));
        this.setWindowTitle(Util.getString("NewModelProjectWizard.title", new Object[0]));
        this.optionsPage = new ProjectTemplateOptionsPage();
        this.addPage((IWizardPage)this.optionsPage);
    }

    public boolean performFinish() {
        IWizardPage mainPage = super.getPage("basicNewProjectPage");
        if (mainPage instanceof WizardNewProjectCreationPage) {
            String projName = ((WizardNewProjectCreationPage)mainPage).getProjectName();
            ValidationResultImpl result = new ValidationResultImpl((Object)projName);
            this.checkInvalidChars((ValidationResult)result, projName, UiConstants.NamingAttributes.VALID_PROJECT_CHARS);
            if (result.hasProblems()) {
                String eMsg = String.valueOf(Util.getString("NewModelProjectWizard.namingError.msg", new Object[0])) + '\n' + result.getProblems()[0].getMessage();
                String eTitle = Util.getString("NewModelProjectWizard.namingError.title", new Object[0]);
                MessageDialog.openWarning((Shell)this.getShell(), (String)eTitle, (String)eMsg);
                return false;
            }
            this.checkReservedProjName((ValidationResult)result, projName);
            if (result.hasProblems()) {
                String eMsg = String.valueOf(Util.getString("NewModelProjectWizard.namingError.msg", new Object[0])) + '\n' + result.getProblems()[0].getMessage();
                String eTitle = Util.getString("NewModelProjectWizard.namingError.title", new Object[0]);
                MessageDialog.openWarning((Shell)this.getShell(), (String)eTitle, (String)eMsg);
                return false;
            }
        }
        super.performFinish();
        IProject project = this.getNewProject();
        if (project == null) {
            return false;
        }
        try {
            String productName;
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(MODEL_NATURES);
            if (ProductCustomizerMgr.getInstance() != null && !CoreStringUtil.isEmpty((String)(productName = ProductCustomizerMgr.getInstance().getProductName()))) {
                desc.setComment(String.valueOf(productName) + ", version " + ModelerCore.ILicense.VERSION);
            }
            project.setDescription(desc, null);
            if (this.designerProperties != null) {
                DesignerPropertiesUtil.setProjectName(this.designerProperties, project.getName());
                DesignerPropertiesUtil.setProjectStatus(this.designerProperties, "openProjectsExist");
            }
            this.createFolders(project);
            this.refreshModelExplorerResourceNavigatorTree();
            return true;
        }
        catch (CoreException err) {
            Util.log(4, (Throwable)err, err.getMessage());
            return false;
        }
    }

    private void createFolders(IProject project) {
        if (!this.optionsPage.wasVisible()) {
            return;
        }
        if (this.optionsPage.createSources) {
            if (this.designerProperties != null) {
                DesignerPropertiesUtil.setSourcesFolderName(this.designerProperties, this.optionsPage.sourcesStr);
            }
            FolderUtil.createFolder(this.getShell(), project, this.optionsPage.sourcesStr);
        }
        if (this.optionsPage.createViews) {
            if (this.designerProperties != null) {
                DesignerPropertiesUtil.setViewsFolderName(this.designerProperties, this.optionsPage.viewsStr);
            }
            FolderUtil.createFolder(this.getShell(), project, this.optionsPage.viewsStr);
        }
        if (this.optionsPage.createSchema) {
            if (this.designerProperties != null) {
                DesignerPropertiesUtil.setSchemaFolderName(this.designerProperties, this.optionsPage.schemaStr);
            }
            FolderUtil.createFolder(this.getShell(), project, this.optionsPage.schemaStr);
        }
        if (this.optionsPage.createWebServices) {
            if (this.designerProperties != null) {
                DesignerPropertiesUtil.setWebServiceFolderName(this.designerProperties, this.optionsPage.webServicesStr);
            }
            FolderUtil.createFolder(this.getShell(), project, this.optionsPage.webServicesStr);
        }
        if (this.optionsPage.createFunctions) {
            FolderUtil.createFolder(this.getShell(), project, this.optionsPage.functionsStr);
        }
        if (this.optionsPage.createExtensions) {
            FolderUtil.createFolder(this.getShell(), project, this.optionsPage.extensionsStr);
        }
    }

    private void refreshModelExplorerResourceNavigatorTree() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ModelExplorerResourceNavigator view = (ModelExplorerResourceNavigator)UiUtil.getWorkbenchPage().showView("explorer.view");
                    view.getTreeViewer().refresh(true);
                }
                catch (PartInitException err) {
                    Util.log(4, (Throwable)err, err.getMessage());
                }
            }
        });
    }

    private void checkInvalidChars(ValidationResult result, String stringToValidate, char[] validChars) {
        CoreArgCheck.isNotNull((Object)stringToValidate);
        CoreArgCheck.isNotNull((Object)result);
        StringNameValidator validator = new StringNameValidator(validChars);
        String reasonInvalid = validator.checkValidName(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem((ValidationProblem)problem);
        }
    }

    private void checkReservedProjName(ValidationResult result, String name) {
        CoreArgCheck.isNotNull((Object)name);
        CoreArgCheck.isNotNull((Object)result);
        if (ModelerCore.isReservedProjectName((String)name)) {
            String reservedProjMsg = Util.getString("NewModelProjectWizard.reservedProjNameError", (Object)name);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reservedProjMsg);
            result.addProblem((ValidationProblem)problem);
        }
    }

    @Override
    public void setProperties(Properties props) {
        this.designerProperties = props;
    }

    class ProjectTemplateOptionsPage
    extends AbstractWizardPage {
        private String NO_FOLDERS_MESSAGE;
        private String CREATE_FOLDER;
        public boolean createSources;
        public boolean createViews;
        public boolean createSchema;
        public boolean createWebServices;
        public boolean createFunctions;
        public boolean createExtensions;
        private Button sourcesCB;
        private Button viewsCB;
        private Button schemaCB;
        private Button webServicesCB;
        private Button functionsCB;
        private Button extensionsCB;
        private Text sourcesText;
        private Text viewsText;
        private Text schemaText;
        private Text webServicesText;
        private Text functionsText;
        private Text extensionsText;
        public String sourcesStr;
        public String viewsStr;
        public String schemaStr;
        public String webServicesStr;
        public String functionsStr;
        public String extensionsStr;
        private String projectName;
        private boolean wasVisible;

        public ProjectTemplateOptionsPage() {
            super(ProjectTemplateOptionsPage.class.getSimpleName(), NewModelProjectWizard.getString("optionsTitle"));
            this.NO_FOLDERS_MESSAGE = NewModelProjectWizard.getString("noFoldersMessage");
            this.CREATE_FOLDER = NewModelProjectWizard.getString("createFolderOperationLabel");
            this.createSources = true;
            this.createViews = true;
            this.createSchema = true;
            this.createWebServices = true;
            this.createFunctions = false;
            this.createExtensions = false;
            this.sourcesStr = SOURCES;
            this.viewsStr = VIEWS;
            this.schemaStr = SCHEMAS;
            this.webServicesStr = WEB_SERVICES;
            this.functionsStr = FUNCTIONS;
            this.extensionsStr = EXTENSIONS;
            this.wasVisible = false;
            this.setDescription(NewModelProjectWizard.getString("initialMessage"));
        }

        public void createControl(Composite theParent) {
            Composite mainPanel = WidgetFactory.createPanel((Composite)theParent, (int)16, (int)1808);
            mainPanel.setLayout((Layout)new GridLayout(1, false));
            this.setControl((Control)mainPanel);
            this.createOptionsPanel(mainPanel);
            this.setPageStatus();
        }

        public boolean canFlipToNextPage() {
            return false;
        }

        void setPageStatus() {
            this.setMessage(null, 0);
        }

        private void createOptionsPanel(Composite theParent) {
            GridData gd = new GridData(1808);
            theParent.setLayoutData((Object)gd);
            Group folderOptionsGroup = WidgetFactory.createGroup((Composite)theParent, (String)NewModelProjectWizard.getString("optionGroupLabel"), (int)768, (int)1, (int)2);
            this.sourcesCB = WidgetFactory.createCheckBox((Composite)folderOptionsGroup);
            this.sourcesCB.setText(this.CREATE_FOLDER);
            this.sourcesCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProjectTemplateOptionsPage.this.createSources = ProjectTemplateOptionsPage.this.sourcesCB.getSelection();
                    ProjectTemplateOptionsPage.this.sourcesText.setEnabled(ProjectTemplateOptionsPage.this.sourcesCB.getSelection());
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.sourcesCB.setSelection(this.createSources);
            this.sourcesText = this.createTextField((Composite)folderOptionsGroup, SOURCES, NewModelProjectWizard.getString("createFolderCheckBoxLabel", SOURCES));
            this.sourcesText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectTemplateOptionsPage.this.sourcesStr = ProjectTemplateOptionsPage.this.sourcesText.getText();
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.sourcesText.setEnabled(this.createSources);
            this.viewsCB = WidgetFactory.createCheckBox((Composite)folderOptionsGroup);
            this.viewsCB.setText(this.CREATE_FOLDER);
            this.viewsCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProjectTemplateOptionsPage.this.createViews = ProjectTemplateOptionsPage.this.viewsCB.getSelection();
                    ProjectTemplateOptionsPage.this.viewsText.setEnabled(ProjectTemplateOptionsPage.this.viewsCB.getSelection());
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.viewsCB.setSelection(this.createViews);
            this.viewsText = this.createTextField((Composite)folderOptionsGroup, VIEWS, NewModelProjectWizard.getString("createFolderCheckBoxLabel", VIEWS));
            this.viewsText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectTemplateOptionsPage.this.viewsStr = ProjectTemplateOptionsPage.this.viewsText.getText();
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.viewsText.setEnabled(this.createViews);
            this.schemaCB = WidgetFactory.createCheckBox((Composite)folderOptionsGroup);
            this.schemaCB.setText(this.CREATE_FOLDER);
            this.schemaCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProjectTemplateOptionsPage.this.createSchema = ProjectTemplateOptionsPage.this.schemaCB.getSelection();
                    ProjectTemplateOptionsPage.this.schemaText.setEnabled(ProjectTemplateOptionsPage.this.schemaCB.getSelection());
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.schemaCB.setSelection(this.createSchema);
            this.schemaText = this.createTextField((Composite)folderOptionsGroup, SCHEMAS, NewModelProjectWizard.getString("createFolderCheckBoxLabel", SCHEMAS));
            this.schemaText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectTemplateOptionsPage.this.schemaStr = ProjectTemplateOptionsPage.this.schemaText.getText();
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.schemaText.setEnabled(this.createSchema);
            this.webServicesCB = WidgetFactory.createCheckBox((Composite)folderOptionsGroup);
            this.webServicesCB.setText(this.CREATE_FOLDER);
            this.webServicesCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProjectTemplateOptionsPage.this.createWebServices = ProjectTemplateOptionsPage.this.webServicesCB.getSelection();
                    ProjectTemplateOptionsPage.this.webServicesText.setEnabled(ProjectTemplateOptionsPage.this.webServicesCB.getSelection());
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.webServicesCB.setSelection(this.createWebServices);
            this.webServicesText = this.createTextField((Composite)folderOptionsGroup, WEB_SERVICES, NewModelProjectWizard.getString("createFolderCheckBoxLabel", WEB_SERVICES));
            this.webServicesText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectTemplateOptionsPage.this.webServicesStr = ProjectTemplateOptionsPage.this.webServicesText.getText();
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.webServicesText.setEnabled(this.createWebServices);
            this.functionsCB = WidgetFactory.createCheckBox((Composite)folderOptionsGroup);
            this.functionsCB.setText(this.CREATE_FOLDER);
            this.functionsCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProjectTemplateOptionsPage.this.createFunctions = ProjectTemplateOptionsPage.this.functionsCB.getSelection();
                    ProjectTemplateOptionsPage.this.functionsText.setEnabled(ProjectTemplateOptionsPage.this.functionsCB.getSelection());
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.functionsCB.setSelection(this.createFunctions);
            this.functionsText = this.createTextField((Composite)folderOptionsGroup, FUNCTIONS, NewModelProjectWizard.getString("createFolderCheckBoxLabel", FUNCTIONS));
            this.functionsText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectTemplateOptionsPage.this.functionsStr = ProjectTemplateOptionsPage.this.functionsText.getText();
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.functionsText.setEnabled(this.createFunctions);
            this.extensionsCB = WidgetFactory.createCheckBox((Composite)folderOptionsGroup);
            this.extensionsCB.setText(this.CREATE_FOLDER);
            this.extensionsCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProjectTemplateOptionsPage.this.createExtensions = ProjectTemplateOptionsPage.this.extensionsCB.getSelection();
                    ProjectTemplateOptionsPage.this.extensionsText.setEnabled(ProjectTemplateOptionsPage.this.extensionsCB.getSelection());
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.extensionsCB.setSelection(this.createExtensions);
            this.extensionsText = this.createTextField((Composite)folderOptionsGroup, EXTENSIONS, NewModelProjectWizard.getString("createFolderCheckBoxLabel", EXTENSIONS));
            this.extensionsText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectTemplateOptionsPage.this.extensionsStr = ProjectTemplateOptionsPage.this.extensionsText.getText();
                    ProjectTemplateOptionsPage.this.validate();
                }
            });
            this.extensionsText.setEnabled(this.createExtensions);
        }

        private Text createTextField(Composite parent, String text, String tooltip) {
            Text newText = new Text(parent, 2048);
            newText.setLayoutData((Object)new GridData(4, 128, true, false));
            newText.setText(text);
            newText.setToolTipText(tooltip);
            return newText;
        }

        public boolean wasVisible() {
            return this.wasVisible;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.wasVisible = true;
        }

        private void validate() {
            if (!(this.createSchema || this.createFunctions || this.createExtensions || this.createViews || this.createSources || this.createWebServices)) {
                this.setPageStatus(true, this.NO_FOLDERS_MESSAGE, null);
                return;
            }
            if (this.createExtensions) {
                if (this.extensionsStr.length() == 0) {
                    this.setPageStatus(false, null, NewModelProjectWizard.getString("zeroLengthFolderNameError"));
                    return;
                }
                if (this.checkDuplicateName(this.createSources, this.extensionsStr, this.sourcesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createViews, this.extensionsStr, this.viewsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createSchema, this.extensionsStr, this.schemaStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createWebServices, this.extensionsStr, this.webServicesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createFunctions, this.extensionsStr, this.functionsStr)) {
                    return;
                }
            }
            if (this.createFunctions) {
                if (this.functionsStr.length() == 0) {
                    this.setPageStatus(false, null, NewModelProjectWizard.getString("zeroLengthFolderNameError"));
                    return;
                }
                if (this.checkDuplicateName(this.createSources, this.functionsStr, this.sourcesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createViews, this.functionsStr, this.viewsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createSchema, this.functionsStr, this.schemaStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createWebServices, this.functionsStr, this.webServicesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createExtensions, this.functionsStr, this.extensionsStr)) {
                    return;
                }
            }
            if (this.createSources) {
                if (this.sourcesStr.length() == 0) {
                    this.setPageStatus(false, null, NewModelProjectWizard.getString("zeroLengthFolderNameError"));
                    return;
                }
                if (this.checkDuplicateName(this.createViews, this.sourcesStr, this.viewsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createSchema, this.sourcesStr, this.schemaStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createWebServices, this.sourcesStr, this.webServicesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createFunctions, this.sourcesStr, this.functionsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createExtensions, this.sourcesStr, this.extensionsStr)) {
                    return;
                }
            }
            if (this.createViews) {
                if (this.viewsStr.length() == 0) {
                    this.setPageStatus(false, null, NewModelProjectWizard.getString("zeroLengthFolderNameError"));
                    return;
                }
                if (this.checkDuplicateName(this.createSources, this.viewsStr, this.sourcesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createSchema, this.viewsStr, this.schemaStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createWebServices, this.viewsStr, this.webServicesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createFunctions, this.viewsStr, this.functionsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createExtensions, this.viewsStr, this.extensionsStr)) {
                    return;
                }
            }
            if (this.createSchema) {
                if (this.extensionsStr.length() == 0) {
                    this.setPageStatus(false, null, NewModelProjectWizard.getString("zeroLengthFolderNameError"));
                    return;
                }
                if (this.checkDuplicateName(this.createSources, this.schemaStr, this.sourcesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createViews, this.schemaStr, this.viewsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createWebServices, this.schemaStr, this.webServicesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createFunctions, this.schemaStr, this.functionsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createExtensions, this.schemaStr, this.extensionsStr)) {
                    return;
                }
            }
            if (this.createWebServices) {
                if (this.webServicesStr.length() == 0) {
                    this.setPageStatus(false, null, NewModelProjectWizard.getString("zeroLengthFolderNameError"));
                    return;
                }
                if (this.checkDuplicateName(this.createSources, this.webServicesStr, this.sourcesStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createViews, this.webServicesStr, this.viewsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createSchema, this.webServicesStr, this.schemaStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createFunctions, this.webServicesStr, this.functionsStr)) {
                    return;
                }
                if (this.checkDuplicateName(this.createExtensions, this.webServicesStr, this.extensionsStr)) {
                    return;
                }
            }
            this.setPageStatus(true, NewModelProjectWizard.getString("initialMessage", this.projectName), null);
        }

        private void setPageStatus(boolean complete, String message, String errorMessage) {
            this.setErrorMessage(errorMessage);
            this.setMessage(message);
            this.setPageComplete(complete);
        }

        private boolean checkDuplicateName(boolean doCheck, String str1, String str2) {
            if (doCheck && str1.equalsIgnoreCase(str2)) {
                this.setErrorMessage(NewModelProjectWizard.getString("duplicateFolderNameError", this.functionsStr));
                this.setPageComplete(false);
                return true;
            }
            return false;
        }
    }
}

