/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.teiid.designer.core.ModelInitializer;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.EmfModelObjectExtensionAssistant;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.transaction.UnitOfWorkImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.DeleteAction;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.NoOpenProjectsWizardPage;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.viewsupport.ModelInitializerSelectionDialog;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;
import org.teiid.designer.ui.wizards.INewModelWizardContributor;
import org.teiid.designer.ui.wizards.INewModelWizardContributor2;
import org.teiid.designer.ui.wizards.NewModelWizardDescriptor;
import org.teiid.designer.ui.wizards.NewModelWizardInput;
import org.teiid.designer.ui.wizards.NewModelWizardMetamodelPage;

public class NewModelWizard
extends AbstractWizard
implements INewWizard,
UiConstants,
UiConstants.ExtensionPoints.NewModelWizardContributor,
IPropertiesContext {
    private static ArrayList contributorList;
    protected NewModelWizardMetamodelPage metamodelSelectionPage;
    protected ISelection selection;
    INewModelWizardContributor wizardPageContributor;
    private IWizardPage[] wizardPageArray;
    private boolean exceptionOccurred = false;
    private NewModelWizardInput defaultNewModelInput;
    private Properties designerProperties;
    private boolean openProjectExists = true;
    private IProject newProject;
    private HashMap contributorPageMap = new HashMap();
    private IWizardPage createHiddenProjPage = null;
    private ModelResource newModelResource = null;

    public NewModelWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), Util.getString("NewModelWizard.title", new Object[0]), null);
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.newModelResource = null;
    }

    public NewModelWizard(NewModelWizardInput newModelInput, Properties properties) {
        this();
        this.defaultNewModelInput = newModelInput;
        this.newModelResource = null;
        this.designerProperties = properties;
    }

    public void addPages() {
        Object someObj;
        if (!this.openProjectExists) {
            return;
        }
        if (ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() && ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false) == null) {
            this.createHiddenProjPage = ProductCustomizerMgr.getInstance().getProductCharacteristics().getCreateHiddenProjectWizardPage();
            if (this.createHiddenProjPage != null) {
                this.addPage(this.createHiddenProjPage);
            }
        }
        this.metamodelSelectionPage = new NewModelWizardMetamodelPage(this.selection, this.designerProperties);
        NewModelWizardInput someModelInput = this.defaultNewModelInput;
        if ((someModelInput == null || someModelInput.isEmpty()) && (someObj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getNewModelInput(this.selection)) instanceof NewModelWizardInput) {
            someModelInput = (NewModelWizardInput)someObj;
        }
        if (someModelInput != null && !someModelInput.isEmpty()) {
            this.metamodelSelectionPage.setNewModelInput(someModelInput);
        }
        this.addPage((IWizardPage)this.metamodelSelectionPage);
    }

    public boolean finish() {
        this.newModelResource = null;
        if (this.metamodelSelectionPage.getSelectedBuilder() == null) {
            this.wizardPageContributor = null;
        }
        final String containerName = this.metamodelSelectionPage.getContainerName();
        final String fileName = this.metamodelSelectionPage.getFileName();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) throws InvocationTargetException {
                try {
                    try {
                        NewModelWizard.this.doFinish(containerName, fileName, theMonitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    theMonitor.done();
                }
            }
        };
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)this.getWindowTitle(), (Object)this);
        boolean overrideRollback = false;
        if (startedTxn) {
            overrideRollback = true;
            ((UnitOfWorkImpl)ModelerCore.getCurrentUoW()).setOverrideRollback(overrideRollback);
        }
        boolean success = false;
        try {
            try {
                this.getContainer().run(false, true, (IRunnableWithProgress)op);
                success = true;
            }
            catch (InterruptedException interruptedException) {
                success = false;
                if (startedTxn) {
                    if (success) {
                        ModelerCore.commitTxn();
                    } else if (overrideRollback) {
                        if (this.newModelResource != null) {
                            DeleteAction action = new DeleteAction();
                            action.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.newModelResource));
                            action.run();
                        }
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return false;
            }
            catch (InvocationTargetException e) {
                block26: {
                    block27: {
                        success = false;
                        Throwable realException = e.getTargetException();
                        String msg = realException.getMessage();
                        if (msg == null || msg.length() == 0) {
                            msg = Util.getString("NewModelWizard.Error_1.msg", (Object)realException.getClass().getName().toString());
                        }
                        MessageDialog.openError((Shell)this.getShell(), (String)Util.getString("NewModelWizard.Error_1.title", new Object[0]), (String)msg);
                        if (!startedTxn) break block26;
                        if (!success) break block27;
                        ModelerCore.commitTxn();
                        break block26;
                    }
                    if (overrideRollback) {
                        if (this.newModelResource != null) {
                            DeleteAction action = new DeleteAction();
                            action.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.newModelResource));
                            action.run();
                        }
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return false;
            }
        }
        finally {
            if (startedTxn) {
                if (success) {
                    ModelerCore.commitTxn();
                } else if (overrideRollback) {
                    if (this.newModelResource != null) {
                        DeleteAction action = new DeleteAction();
                        action.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.newModelResource));
                        action.run();
                    }
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.newModelResource = null;
        return true;
    }

    void setExceptionOccurred(boolean flag) {
        this.exceptionOccurred = flag;
    }

    void doFinish(String containerName, String fileName, final IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(Util.getString("NewModelWizard.Creating__2", new Object[0])) + fileName, 2);
        IWorkspaceRoot root = ModelerCore.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.valueOf(Util.getString("NewModelWizard.Container___3", new Object[0])) + containerName + Util.getString("NewModelWizard.__does_not_exist._4", new Object[0]));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        this.setExceptionOccurred(false);
        final ModelResource modelResource = ModelerCore.create((IFile)file);
        if (modelResource != null) {
            this.newModelResource = modelResource;
            if (this.wizardPageContributor != null) {
                this.processThroughContributor(modelResource, file, monitor);
            } else {
                final ModelAnnotation annotation = modelResource.getModelAnnotation();
                if (annotation != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelInitializer initializer;
                            MetamodelDescriptor descriptor = NewModelWizard.this.metamodelSelectionPage.getMetamodelDescriptor();
                            String uri = descriptor.getNamespaceURI();
                            annotation.setPrimaryMetamodelUri(uri);
                            annotation.setModelType(NewModelWizard.this.getModelType());
                            List initializerNames = descriptor.getModelInitializerNames();
                            int numInitializers = initializerNames.size();
                            String initializerName = null;
                            if (numInitializers == 1) {
                                initializerName = (String)initializerNames.get(0);
                            } else if (numInitializers > 1) {
                                ModelInitializerSelectionDialog dialog = new ModelInitializerSelectionDialog(NewModelWizard.this.getShell(), descriptor);
                                dialog.setInitialSelection();
                                dialog.open();
                                initializerName = dialog.getReturnCode() == 0 && dialog.getResult() != null && dialog.getResult().length > 0 ? (String)dialog.getResult()[0] : (String)initializerNames.get(0);
                            }
                            System.gc();
                            Thread.yield();
                            if (initializerName != null && (initializer = descriptor.getModelInitializer(initializerName)) != null) {
                                try {
                                    IStatus status = initializer.execute(modelResource.getEmfResource());
                                    System.out.println(status);
                                }
                                catch (Exception e) {
                                    NewModelWizard.this.setExceptionOccurred(true);
                                    UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                                }
                            }
                            System.gc();
                            Thread.yield();
                            try {
                                ModelUtilities.saveModelResource(modelResource, monitor, true, this);
                            }
                            catch (Exception e) {
                                NewModelWizard.this.setExceptionOccurred(true);
                                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                            }
                            monitor.worked(1);
                            monitor.setTaskName(Util.getString("NewModelWizard.Opening_file_for_editing..._5", new Object[0]));
                            ModelEditorManager.openInEditMode(file, true, 0);
                            monitor.worked(1);
                        }
                    });
                }
            }
        }
        if (this.designerProperties != null && modelResource != null && ModelUtil.isModelFile((Resource)modelResource.getEmfResource())) {
            if (ModelUtil.isVirtual((Object)modelResource.getEmfResource())) {
                String viewModelName = ((IFile)modelResource.getCorrespondingResource()).getName();
                DesignerPropertiesUtil.setViewModelName(this.designerProperties, viewModelName);
            } else if (ModelUtil.isPhysical((Object)modelResource.getEmfResource())) {
                String sourceModelName = ((IFile)modelResource.getCorrespondingResource()).getName();
                DesignerPropertiesUtil.setSourceModelName(this.designerProperties, sourceModelName);
            }
        }
        monitor.worked(1);
        if (this.exceptionOccurred) {
            this.setExceptionOccurred(false);
        }
        monitor.worked(1);
    }

    private void processThroughContributor(final ModelResource modelResource, final IFile file, final IProgressMonitor monitor) throws CoreException {
        final ModelAnnotation annotation = modelResource.getModelAnnotation();
        if (annotation != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MetamodelDescriptor descriptor = NewModelWizard.this.metamodelSelectionPage.getMetamodelDescriptor();
                    String uri = descriptor.getNamespaceURI();
                    annotation.setPrimaryMetamodelUri(uri);
                    annotation.setModelType(NewModelWizard.this.getModelType());
                    try {
                        NewModelWizard.this.wizardPageContributor.doFinish(modelResource, monitor);
                    }
                    catch (Exception e) {
                        NewModelWizard.this.setExceptionOccurred(true);
                        Util.log((Throwable)e);
                    }
                    ModelAnnotation originalModelAnotation = null;
                    try {
                        modelResource.getModelAnnotation().setModelType(NewModelWizard.this.getModelType());
                        ModelerCore.getModelEditor().getAllContainers(modelResource.getEmfResource());
                        ArrayList existingImports = new ArrayList(annotation.getModelImports());
                        modelResource.getEmfResource().getContents().remove((Object)annotation);
                        originalModelAnotation = modelResource.getModelAnnotation();
                        if (!existingImports.isEmpty()) {
                            if (originalModelAnotation.getModelImports().isEmpty()) {
                                try {
                                    ModelerCore.getModelEditor().addValue((Object)originalModelAnotation, existingImports, originalModelAnotation.getModelImports());
                                }
                                catch (Exception e) {
                                    NewModelWizard.this.setExceptionOccurred(true);
                                    ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                                }
                            } else {
                                EList originalImports = originalModelAnotation.getModelImports();
                                for (ModelImport newImport : existingImports) {
                                    boolean importExists = false;
                                    for (ModelImport nextImport : originalImports) {
                                        if (!nextImport.getModelLocation().equalsIgnoreCase(newImport.getModelLocation())) continue;
                                        importExists = true;
                                        break;
                                    }
                                    if (importExists) continue;
                                    try {
                                        ModelerCore.getModelEditor().addValue((Object)originalModelAnotation, (Object)newImport, originalModelAnotation.getModelImports());
                                    }
                                    catch (Exception e) {
                                        NewModelWizard.this.setExceptionOccurred(true);
                                        ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                                    }
                                }
                            }
                        }
                    }
                    catch (ModelWorkspaceException theException) {
                        NewModelWizard.this.setExceptionOccurred(true);
                        ModelerCore.Util.log(4, (Throwable)theException, theException.getMessage());
                    }
                    if (originalModelAnotation != null) {
                        ModelResource selectedResource;
                        originalModelAnotation.setPrimaryMetamodelUri(uri);
                        originalModelAnotation.setModelType(NewModelWizard.this.getModelType());
                        if (NewModelWizard.this.wizardPageContributor.copyAllDescriptions() && (selectedResource = NewModelWizard.this.wizardPageContributor.getSelectedModelResource()) != null) {
                            try {
                                String sourceModelDesc = selectedResource.getDescription();
                                if (sourceModelDesc != null) {
                                    modelResource.getModelAnnotation().setDescription(sourceModelDesc);
                                }
                            }
                            catch (Exception ex) {
                                NewModelWizard.this.setExceptionOccurred(true);
                                ModelerCore.Util.log(4, (Throwable)ex, ex.getMessage());
                            }
                        }
                        try {
                            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
                            EmfModelObjectExtensionAssistant assistant = (EmfModelObjectExtensionAssistant)registry.getModelExtensionAssistant("core");
                            assistant.cleanupModelResourceMEDs((Object)modelResource);
                        }
                        catch (Exception ex) {
                            NewModelWizard.this.setExceptionOccurred(true);
                            ModelerCore.Util.log(4, (Throwable)ex, ex.getMessage());
                        }
                        try {
                            ModelUtilities.saveModelResource(modelResource, monitor, true, this);
                        }
                        catch (Exception e) {
                            NewModelWizard.this.setExceptionOccurred(true);
                            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                        }
                        monitor.worked(1);
                        monitor.setTaskName(Util.getString("NewModelWizard.Opening_file_for_editing..._5", new Object[0]));
                        ModelEditorManager.openInEditMode(file, true, 0);
                        monitor.worked(1);
                    }
                }
            });
        }
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.teiid.designer.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.openProjectExists = ModelerUiViewUtils.workspaceHasOpenModelProjects();
        if (!this.openProjectExists) {
            this.newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (this.newProject != null) {
                this.selection = new StructuredSelection((Object)this.newProject);
                this.openProjectExists = true;
            } else {
                this.openProjectExists = false;
                WizardPage page = NoOpenProjectsWizardPage.getStandardPage();
                this.addPage((IWizardPage)page);
                this.wizardPageArray = new IWizardPage[]{page};
                return;
            }
        }
    }

    public ModelType getModelType() {
        return this.metamodelSelectionPage.getSelectedModelType();
    }

    public String getMetamodelType() {
        String metamodelType = this.metamodelSelectionPage.getMetamodelType();
        return metamodelType;
    }

    public static List getModelBuilders(MetamodelDescriptor descriptor, boolean isVirtual) {
        ArrayList<NewModelWizardDescriptor> result = new ArrayList<NewModelWizardDescriptor>(NewModelWizard.getContributorList().size());
        for (NewModelWizardDescriptor desc : NewModelWizard.getContributorList()) {
            if (!desc.canBuild(descriptor, isVirtual)) continue;
            result.add(desc);
        }
        return result;
    }

    static List getContributorList() {
        if (contributorList == null) {
            contributorList = new ArrayList();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "newModelWizardContributor");
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                String title = extension.getLabel();
                IConfigurationElement[] elements = extension.getConfigurationElements();
                Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("class")) {
                        String classname = elements[j].getAttribute("name");
                        NewModelWizardDescriptor desc = new NewModelWizardDescriptor("newModelWizardContributor", classname, bundle, title, elements);
                        contributorList.add(desc);
                        break;
                    }
                    ++j;
                }
                ++n2;
            }
        }
        return contributorList;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer, false);
        this.updateForProperties();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.wizardPageContributor != null) {
            this.wizardPageContributor.currentPageChanged(this.getContainer().getCurrentPage());
        }
        if (page == this.createHiddenProjPage) {
            return this.metamodelSelectionPage;
        }
        if (page == this.metamodelSelectionPage) {
            this.updatePageQueue(true);
            if (this.wizardPageArray != null) {
                return this.wizardPageArray[0];
            }
            return null;
        }
        int i = 0;
        while (i < this.wizardPageArray.length) {
            if (this.wizardPageArray[i] == page && i + 1 < this.wizardPageArray.length) {
                if (this.wizardPageContributor instanceof INewModelWizardContributor2) {
                    return ((INewModelWizardContributor2)this.wizardPageContributor).getNextPage(page);
                }
                return this.wizardPageArray[i + 1];
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.metamodelSelectionPage) {
            result = currentPage.isPageComplete();
        } else if (currentPage == this.createHiddenProjPage) {
            result = false;
        } else {
            boolean lastPage;
            boolean bl = lastPage = currentPage == this.wizardPageArray[this.wizardPageArray.length - 1];
            result = !lastPage && this.wizardPageContributor != null ? this.wizardPageContributor.canFinishEarly(currentPage) : lastPage && currentPage.isPageComplete();
        }
        return result;
    }

    public int getPageCount() {
        if (this.wizardPageArray != null) {
            return this.wizardPageArray.length + 1;
        }
        return 1;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.wizardPageArray == null || page == this.metamodelSelectionPage) {
            return null;
        }
        if (page == this.wizardPageArray[0]) {
            return this.metamodelSelectionPage;
        }
        int i = 1;
        while (i < this.wizardPageArray.length) {
            if (page == this.wizardPageArray[i]) {
                if (this.wizardPageContributor instanceof INewModelWizardContributor2) {
                    return ((INewModelWizardContributor2)this.wizardPageContributor).getPreviousPage(page);
                }
                return this.wizardPageArray[i - 1];
            }
            ++i;
        }
        return null;
    }

    private void updatePageQueue(boolean inputChanged) {
        IResource container = this.metamodelSelectionPage.getTargetContainer();
        IPath targetFilePath = this.metamodelSelectionPage.getFilePath();
        boolean isVirtual = this.metamodelSelectionPage.isVirtualSelected();
        MetamodelDescriptor metamodelDescriptor = this.metamodelSelectionPage.getMetamodelDescriptor();
        NewModelWizardDescriptor descriptor = this.metamodelSelectionPage.getSelectedBuilder();
        if (descriptor == null) {
            this.wizardPageArray = null;
            this.wizardPageContributor = null;
        } else {
            boolean addWizardPages = false;
            INewModelWizardContributor contributor = (INewModelWizardContributor)this.contributorPageMap.get(descriptor.getTitle());
            if (contributor == null) {
                this.wizardPageContributor = (INewModelWizardContributor)descriptor.getExtensionClassInstance();
                this.contributorPageMap.put(descriptor.getTitle(), this.wizardPageContributor);
                this.wizardPageContributor.createWizardPages(this.selection, container, targetFilePath, metamodelDescriptor, isVirtual);
                this.wizardPageArray = this.wizardPageContributor.getWizardPages();
                addWizardPages = true;
            } else if (contributor != this.wizardPageContributor) {
                contributor.inputChanged(this.selection, container, metamodelDescriptor, isVirtual);
                this.wizardPageArray = contributor.getWizardPages();
                addWizardPages = true;
                this.wizardPageContributor = contributor;
            } else if (inputChanged) {
                this.wizardPageContributor.inputChanged(this.selection, container, metamodelDescriptor, isVirtual);
                this.wizardPageArray = this.wizardPageContributor.getWizardPages();
                addWizardPages = true;
            }
            if (addWizardPages) {
                int i = 0;
                while (i < this.wizardPageArray.length) {
                    super.addPage(this.wizardPageArray[i]);
                    ++i;
                }
            }
        }
    }

    public boolean performCancel() {
        if (this.wizardPageContributor != null) {
            this.wizardPageContributor.doCancel();
        }
        return super.performCancel();
    }

    @Override
    public void setProperties(Properties properties) {
        this.designerProperties = properties;
    }

    public void updateForProperties() {
        if (this.newProject != null && this.designerProperties != null) {
            if (this.openProjectExists) {
                DesignerPropertiesUtil.setProjectName(this.designerProperties, this.newProject.getName());
            }
        } else if (this.designerProperties != null && !this.openProjectExists) {
            DesignerPropertiesUtil.setProjectStatus(this.designerProperties, "noOpenProject");
        }
    }
}

