/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.teiid.designer.core.ExtensionDescriptorImpl;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.ui.UiConstants;

public class NewModelWizardDescriptor
extends ExtensionDescriptorImpl
implements UiConstants.ExtensionPoints.NewModelWizardContributor {
    private static final String TRUE = "true";
    private Bundle bundle;
    private String title;
    private ImageDescriptor imageDescriptor;
    private boolean supportsAnyPhysicalMetamodel = false;
    private boolean supportsAnyVirtualMetamodel = false;
    private Collection supportedPhysicalMetamodelList;
    private Collection supportedVirtualMetamodelList;

    public NewModelWizardDescriptor(Object id, String className, Bundle bundle, String title, IConfigurationElement[] elements) {
        super(id, className, bundle);
        this.title = title;
        this.bundle = bundle;
        this.loadProperties(elements);
    }

    public boolean canBuild(MetamodelDescriptor metamodel, boolean isVirtual) {
        if (metamodel == null) {
            return false;
        }
        boolean result = false;
        result = isVirtual ? (this.supportsAnyVirtualMetamodel ? true : this.supportedVirtualMetamodelList.contains(metamodel.getNamespaceURI())) : (this.supportsAnyPhysicalMetamodel ? true : this.supportedPhysicalMetamodelList.contains(metamodel.getNamespaceURI()));
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return this.title;
    }

    public Image getIcon() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor.createImage();
        }
        return null;
    }

    private void loadProperties(IConfigurationElement[] elements) {
        this.supportedPhysicalMetamodelList = new ArrayList();
        this.supportedVirtualMetamodelList = new ArrayList();
        int j = 0;
        while (j < elements.length) {
            String iconPath;
            if (elements[j].getName().equals("metamodelDescriptorType")) {
                String support;
                String metamodelName = elements[j].getAttribute("name");
                if (metamodelName.equals("all")) {
                    support = elements[j].getAttribute("isPhysical");
                    this.supportsAnyPhysicalMetamodel = TRUE.equalsIgnoreCase(support);
                    support = elements[j].getAttribute("isVirtual");
                    this.supportsAnyVirtualMetamodel = TRUE.equalsIgnoreCase(support);
                } else {
                    support = elements[j].getAttribute("isPhysical");
                    if (TRUE.equalsIgnoreCase(support)) {
                        this.supportedPhysicalMetamodelList.add(metamodelName);
                    }
                    if (TRUE.equalsIgnoreCase(support = elements[j].getAttribute("isVirtual"))) {
                        this.supportedVirtualMetamodelList.add(metamodelName);
                    }
                }
            } else if (elements[j].getName().equals("class") && (iconPath = elements[j].getAttribute("icon")) != null) {
                try {
                    URL url = iconPath.indexOf(58) < 0 ? FileLocator.find((Bundle)this.bundle, (IPath)new Path(iconPath), null) : FileLocator.resolve((URL)new URL(iconPath));
                    this.imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                }
                catch (Exception e) {
                    UiConstants.Util.log((Throwable)e);
                }
            }
            ++j;
        }
    }
}

