/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.transformation.TransformationContainer;
import org.teiid.designer.transformation.aspects.sql.SqlTransformationMappingRootSqlAspect;
import org.teiid.designer.ui.common.tree.TreeViewerUtil;
import org.teiid.designer.ui.common.widget.InheritanceCheckboxTreeViewer;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.wizards.ICheckboxTreeViewerListenerController;
import org.teiid.designer.ui.wizards.IStructuralCopyTreePopulator;
import org.teiid.designer.ui.wizards.IndexAndObject;
import org.teiid.designer.ui.wizards.StructuralCopyTreeContentProvider;
import org.teiid.designer.ui.wizards.StructuralCopyTreeViewerFilter;

public class StructuralCopyModelFeaturePopulator
implements IStructuralCopyTreePopulator {
    private static String VIRTUAL_ROOT = "ROOT";
    protected IFile sourceFile;
    protected ICheckboxTreeViewerListenerController listenerController;
    protected ModelResource targetModelResource;

    public StructuralCopyModelFeaturePopulator(IFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    public StructuralCopyModelFeaturePopulator(IFile sourceFile, ICheckboxTreeViewerListenerController listenerController) {
        this.sourceFile = sourceFile;
        this.listenerController = listenerController;
    }

    @Override
    public void populateModelFeaturesTree(TreeViewer viewer, ModelResource theModel, boolean targetIsVirtual) {
        ViewerFilter[] filters = viewer.getFilters();
        StructuralCopyTreeViewerFilter filter = this.findStructuralCopyFilter(filters);
        if (targetIsVirtual) {
            if (filter == null) {
                viewer.addFilter((ViewerFilter)new StructuralCopyTreeViewerFilter());
            }
        } else if (filter != null) {
            viewer.removeFilter((ViewerFilter)filter);
        }
        StructuralCopyTreeContentProvider contentProvider = StructuralCopyTreeContentProvider.getInstance();
        viewer.setContentProvider((IContentProvider)contentProvider);
        ModelExplorerLabelProvider labelProvider = new ModelExplorerLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setInput(null);
        viewer.setUseHashlookup(true);
        viewer.setInput((Object)theModel);
    }

    private StructuralCopyTreeViewerFilter findStructuralCopyFilter(ViewerFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            ViewerFilter filter = filters[i];
            if (filter instanceof StructuralCopyTreeViewerFilter) {
                return (StructuralCopyTreeViewerFilter)filter;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void copyModel(ModelResource sourceModelResource, ModelResource targetModelResource, InheritanceCheckboxTreeViewer viewer, Map extraProperties, boolean copyAllDescriptions, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyModel(ModelResource sourceModelResource, ModelResource targetModelResource, Map extraProperties, boolean copyAllDescriptions, IProgressMonitor monitor) throws ModelerCoreException {
        EList allSourceRootContents = sourceModelResource.getEmfResource().getContents();
        boolean sourceIsVirtual = sourceModelResource.getModelAnnotation().getModelType().equals(ModelType.VIRTUAL_LITERAL);
        boolean targetIsVirtual = targetModelResource.getModelAnnotation().getModelType().equals(ModelType.VIRTUAL_LITERAL);
        ModelType targetModelType = targetModelResource.getModelAnnotation().getModelType();
        ArrayList<EObject> filteredChildren = new ArrayList<EObject>(allSourceRootContents.size());
        for (EObject nextChild : allSourceRootContents) {
            if (nextChild instanceof AnnotationContainer) {
                if (!copyAllDescriptions) continue;
                filteredChildren.add(nextChild);
                continue;
            }
            if (nextChild instanceof TransformationContainer) {
                if (!targetIsVirtual || !sourceIsVirtual) continue;
                filteredChildren.add(nextChild);
                continue;
            }
            if (ModelObjectUtilities.isJdbcSource(nextChild)) {
                if (targetIsVirtual) continue;
                filteredChildren.add(nextChild);
                continue;
            }
            filteredChildren.add(nextChild);
        }
        Collection sourceFirstLevelChildrenCopies = null;
        sourceFirstLevelChildrenCopies = ModelerCore.getModelEditor().copyAll(filteredChildren);
        EList targetChildren = targetModelResource.getEmfResource().getContents();
        int numKids = targetChildren.size();
        int i = 0;
        while (i < numKids) {
            Object kid = targetChildren.get(i);
            if (kid instanceof ModelAnnotation) {
                targetChildren.remove(kid);
                break;
            }
            ++i;
        }
        SqlTransformationMappingRootSqlAspect.replaceTransformationLiteral((Collection)sourceFirstLevelChildrenCopies, (String)sourceModelResource.getItemName(), (String)targetModelResource.getItemName());
        targetModelResource.getEmfResource().getContents().addAll(sourceFirstLevelChildrenCopies);
        ModelAnnotation modelAnnotation = targetModelResource.getModelAnnotation();
        modelAnnotation.setModelType(targetModelType);
        EList imports = modelAnnotation.getModelImports();
        if (imports != null) {
            ResourceFinder resourceFinder;
            try {
                resourceFinder = ModelerCore.getModelContainer().getResourceFinder();
            }
            catch (CoreException ex) {
                throw new ModelerCoreException(ex);
            }
            List<Object> mImports = Arrays.asList(imports.toArray());
            for (Object mImport : mImports) {
                Resource resource;
                ModelImport modelImport = (ModelImport)mImport;
                URI uri = URI.createURI((String)modelImport.getModelLocation());
                if (resourceFinder.isBuiltInResource(uri) || (resource = resourceFinder.findByWorkspaceUri(uri, targetModelResource.getEmfResource())) != null) continue;
                imports.remove(mImport);
            }
        }
        if (targetIsVirtual) {
            List eObjects = targetModelResource.getEObjects();
            Iterator iter = eObjects.iterator();
            while (iter.hasNext()) {
                NewModelObjectHelperManager.helpCreate(iter.next(), (Map)extraProperties);
            }
        }
    }

    protected DefaultMutableTreeNode[] getChildrenOfNode(DefaultMutableTreeNode node) {
        int numChildren = node.getChildCount();
        DefaultMutableTreeNode[] children = new DefaultMutableTreeNode[numChildren];
        int i = 0;
        while (i < numChildren) {
            children[i] = (DefaultMutableTreeNode)node.getChildAt(i);
            ++i;
        }
        return children;
    }

    protected Object getParent(Object curNode, Collection sourceFirstLevelChildrenCopies) {
        String parent;
        if (curNode == VIRTUAL_ROOT) {
            parent = null;
        } else if (sourceFirstLevelChildrenCopies.contains(curNode)) {
            parent = VIRTUAL_ROOT;
        } else {
            EObject obj = (EObject)curNode;
            parent = obj.eContainer();
        }
        return parent;
    }

    protected Collection getChildren(Object curNode, Collection sourceFirstLevelChildrenCopies) {
        Collection children;
        if (curNode == VIRTUAL_ROOT) {
            children = sourceFirstLevelChildrenCopies;
        } else {
            EObject obj = (EObject)curNode;
            children = obj.eContents();
        }
        return children;
    }

    protected void deleteChildAtIndex(Object parent, int index, Collection sourceFirstLevelChildrenCopies) throws ModelerCoreException {
        Collection children;
        if (parent == VIRTUAL_ROOT) {
            children = sourceFirstLevelChildrenCopies;
        } else {
            EObject obj = (EObject)parent;
            children = obj.eContents();
        }
        Iterator it = children.iterator();
        int i = 0;
        while (i < index) {
            it.next();
            ++i;
        }
        Object childToRemove = it.next();
        if (parent == VIRTUAL_ROOT) {
            sourceFirstLevelChildrenCopies.remove(childToRemove);
        }
        ModelerCore.getModelEditor().delete((EObject)childToRemove);
    }

    protected Object getChildAtIndex(Object parent, int index, Collection sourceFirstLevelChildrenCopies) {
        Collection children;
        if (parent == VIRTUAL_ROOT) {
            children = sourceFirstLevelChildrenCopies;
        } else {
            EObject obj = (EObject)parent;
            children = obj.eContents();
        }
        Iterator it = children.iterator();
        int i = 0;
        while (i < index) {
            it.next();
            ++i;
        }
        Object child = it.next();
        return child;
    }

    protected DefaultMutableTreeNode getParedTreeRoot(InheritanceCheckboxTreeViewer viewer, ModelResource modelResource) {
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode curNode = root = new DefaultMutableTreeNode(new IndexAndObject(0, modelResource));
        boolean done = false;
        while (!done) {
            IndexAndObject io = (IndexAndObject)curNode.getUserObject();
            Object obj = io.getObject();
            Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(obj);
            int childIndex = this.firstRequiredChildIndex(viewer, 0, children);
            if (childIndex >= 0) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new IndexAndObject(childIndex, children[childIndex]));
                curNode.add(newNode);
                curNode = newNode;
                continue;
            }
            boolean nextNodeFound = false;
            while (!nextNodeFound && !done) {
                io = (IndexAndObject)curNode.getUserObject();
                Object prevNodeContentObject = io.getObject();
                if ((curNode = (DefaultMutableTreeNode)curNode.getParent()) == null) {
                    done = true;
                    continue;
                }
                io = (IndexAndObject)curNode.getUserObject();
                Object curNodeContentObject = io.getObject();
                children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(curNodeContentObject);
                int prevNodeIndex = this.indexOf(prevNodeContentObject, children);
                childIndex = this.firstRequiredChildIndex(viewer, prevNodeIndex + 1, children);
                if (childIndex < 0) continue;
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new IndexAndObject(childIndex, children[childIndex]));
                curNode.add(newNode);
                curNode = newNode;
                nextNodeFound = true;
            }
        }
        return root;
    }

    protected int firstRequiredChildIndex(InheritanceCheckboxTreeViewer viewer, int startingIndex, Object[] children) {
        int firstRequiredIndex = -1;
        int curIndex = startingIndex;
        while (curIndex < children.length && firstRequiredIndex < 0) {
            Object curChild = children[curIndex];
            if (viewer.getChecked(curChild) || TreeViewerUtil.anyDescendantChecked((CheckboxTreeViewer)viewer, (Object)curChild)) {
                firstRequiredIndex = curIndex;
                continue;
            }
            ++curIndex;
        }
        return firstRequiredIndex;
    }

    protected int indexOf(Object obj, Object[] array) {
        int index = 0;
        while (obj != array[index]) {
            ++index;
        }
        return index;
    }

    protected void insertInitialFirstLevelChildren(DefaultMutableTreeNode root, List firstLevelChildren, int numToInsert) {
        int i = 0;
        while (i < numToInsert) {
            IndexAndObject io = new IndexAndObject(i, firstLevelChildren.get(i));
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(io);
            root.insert(child, i);
            ++i;
        }
    }

    protected void adjustIndexOfFirstLevelChildren(DefaultMutableTreeNode root, int increment) {
        DefaultMutableTreeNode[] children = this.getChildrenOfNode(root);
        int i = 0;
        while (i < children.length) {
            IndexAndObject io = (IndexAndObject)children[i].getUserObject();
            io.setIndex(io.getIndex() + increment);
            ++i;
        }
    }

    protected Object getObjectForTreeNodeUserObject(Object treeNodeUserObject) {
        IndexAndObject io = (IndexAndObject)treeNodeUserObject;
        return io.getObject();
    }
}

