/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards.wsdl;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.ui.wizards.wsdl.WsdlFileExtensions;
import org.teiid.designer.ui.wizards.wsdl.WsdlFilter;
import org.teiid.designer.ui.wizards.wsdl.WsdlUrlDialog;
import org.teiid.designer.ui.wizards.wsdl.WsdlValidator;
import org.teiid.designer.webservice.WebServicePlugin;

public class WsdlFileSelectionComposite
extends Composite
implements UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(WsdlFileSelectionComposite.class);
    WsdlFilter wsdlFilter = new WsdlFilter();
    private ISelectionStatusValidator wsdlValidator = new WsdlValidator();
    private Button btnWorkspaceAdd;
    private Button btnFileSystemAdd;
    private Button btnURLAdd;
    private IFileSelectionCallback fileSystemCallback;
    private IFileSelectionCallback workspaceCallback;
    private IURLSelectionCallback urlCallback;

    public WsdlFileSelectionComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)this);
        if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            this.btnWorkspaceAdd = WidgetFactory.createButton((Composite)this, (String)Util.getString(String.valueOf(PREFIX) + "button.addFile.workspace", new Object[0]), (int)768);
            this.btnWorkspaceAdd.setToolTipText(Util.getString(String.valueOf(PREFIX) + "button.addFile.workspace.tip", new Object[0]));
            GridDataFactory.swtDefaults().applyTo((Control)this.btnWorkspaceAdd);
            this.btnWorkspaceAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent theEvent) {
                    WsdlFileSelectionComposite.this.handleAddWorkspaceWsdlFile();
                }
            });
        }
        this.btnFileSystemAdd = WidgetFactory.createButton((Composite)this, (String)Util.getString(String.valueOf(PREFIX) + "button.addFile.filesystem", new Object[0]), (int)768);
        this.btnFileSystemAdd.setToolTipText(Util.getString(String.valueOf(PREFIX) + "button.addFile.filesystem.tip", new Object[0]));
        GridDataFactory.swtDefaults().applyTo((Control)this.btnFileSystemAdd);
        this.btnFileSystemAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                WsdlFileSelectionComposite.this.handleAddFileSystemWsdlFile();
            }
        });
        this.btnURLAdd = WidgetFactory.createButton((Composite)this, (String)Util.getString(String.valueOf(PREFIX) + "button.addFile.URL", new Object[0]), (int)768);
        this.btnURLAdd.setToolTipText(Util.getString(String.valueOf(PREFIX) + "button.addFile.URL.tip", new Object[0]));
        GridDataFactory.swtDefaults().applyTo((Control)this.btnURLAdd);
        this.btnURLAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                WsdlFileSelectionComposite.this.handleAddURLWsdlFile();
            }
        });
    }

    public boolean isVisible(FileSelectionButtons buttonType) {
        switch (buttonType) {
            case WORKSPACE: {
                return this.btnWorkspaceAdd != null && this.btnWorkspaceAdd.isVisible();
            }
            case FILESYSTEM: {
                return this.btnFileSystemAdd.isVisible();
            }
            case URL: {
                return this.btnURLAdd.isVisible();
            }
        }
        return false;
    }

    public void setFocus(FileSelectionButtons buttonType) {
        switch (buttonType) {
            case WORKSPACE: {
                if (this.btnWorkspaceAdd == null) break;
                this.btnWorkspaceAdd.setFocus();
                break;
            }
            case FILESYSTEM: {
                this.btnFileSystemAdd.setFocus();
                break;
            }
            case URL: {
                this.btnURLAdd.setFocus();
            }
        }
    }

    public void setCallbacks(IFileSelectionCallback fileSystemCallback, IFileSelectionCallback workspaceCallback, IURLSelectionCallback urlSelectionCallback) {
        this.fileSystemCallback = fileSystemCallback;
        this.workspaceCallback = workspaceCallback;
        this.urlCallback = urlSelectionCallback;
    }

    private void handleAddFileSystemWsdlFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setText(Util.getString(String.valueOf(PREFIX) + "dialog.addWsdl.title", new Object[0]));
        dialog.setFilterExtensions(WsdlFileExtensions.FILE_DIALOG_WSDL_EXTENSIONS);
        if (dialog.open() == null) {
            return;
        }
        String directory = dialog.getFilterPath();
        String[] filenames = dialog.getFileNames();
        if (filenames == null || filenames.length == 0) {
            return;
        }
        boolean validFiles = true;
        int i = 0;
        while (i < filenames.length) {
            String path = new StringBuffer().append(directory).append(File.separatorChar).append(filenames[i]).toString();
            final File wsdlFile = new File(path);
            if (WebServicePlugin.isWsdlFile((File)wsdlFile)) {
                UiBusyIndicator.showWhile((Display)this.fileSystemCallback.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WsdlFileSelectionComposite.this.fileSystemCallback.execute(wsdlFile);
                    }
                });
            } else {
                validFiles = false;
            }
            ++i;
        }
        if (!validFiles && MessageDialog.openQuestion((Shell)this.getShell(), (String)Util.getString(String.valueOf(PREFIX) + "dialog.wrongFileType.title", new Object[0]), (String)Util.getString(String.valueOf(PREFIX) + "dialog.wrongFileType.msg", new Object[0]))) {
            this.handleAddFileSystemWsdlFile();
        }
    }

    private void handleAddWorkspaceWsdlFile() {
        Object[] wsdlFiles = WidgetUtil.showWorkspaceObjectSelectionDialog((String)Util.getString(String.valueOf(PREFIX) + "dialog.addWsdl.title", new Object[0]), (String)Util.getString(String.valueOf(PREFIX) + "dialog.addWsdl.msg", new Object[0]), (boolean)true, null, (ViewerFilter)new ModelingResourceFilter(this.wsdlFilter), (ISelectionStatusValidator)this.wsdlValidator, (ILabelProvider)new ModelExplorerLabelProvider());
        if (wsdlFiles == null || wsdlFiles.length == 0) {
            return;
        }
        int i = 0;
        while (i < wsdlFiles.length) {
            IFile ifFile = (IFile)wsdlFiles[i];
            final File fNew = ifFile.getLocation().toFile();
            if (fNew != null) {
                UiBusyIndicator.showWhile((Display)this.workspaceCallback.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WsdlFileSelectionComposite.this.workspaceCallback.execute(fNew);
                    }
                });
            }
            ++i;
        }
    }

    private void handleAddURLWsdlFile() {
        final WsdlUrlDialog dialog = new WsdlUrlDialog(this.getShell());
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        UiBusyIndicator.showWhile((Display)this.urlCallback.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                WsdlFileSelectionComposite.this.urlCallback.execute(dialog.getUrlObject(), dialog.getSecurityOption(), dialog.getUserName(), dialog.getPassword());
            }
        });
    }

    public static enum FileSelectionButtons {
        WORKSPACE,
        FILESYSTEM,
        URL;

    }

    public static interface IFileSelectionCallback {
        public void execute(File var1);

        public Display getDisplay();
    }

    public static interface IURLSelectionCallback {
        public void execute(URL var1, ICredentialsCommon.SecurityType var2, String var3, String var4);

        public Display getDisplay();
    }
}

