/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.camel.mail;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MailConsumerAccountType implements Enumerator
{
    IMAP(0, "imap", "imap"),
    POP3(1, "pop3", "pop3");

    public static final int IMAP_VALUE = 0;
    public static final int POP3_VALUE = 1;
    private static final MailConsumerAccountType[] VALUES_ARRAY;
    public static final List<MailConsumerAccountType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MailConsumerAccountType[]{IMAP, POP3};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MailConsumerAccountType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MailConsumerAccountType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MailConsumerAccountType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MailConsumerAccountType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MailConsumerAccountType get(int value) {
        switch (value) {
            case 0: {
                return IMAP;
            }
            case 1: {
                return POP3;
            }
        }
        return null;
    }

    private MailConsumerAccountType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

