/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JsonLibrary implements Enumerator
{
    XSTREAM(0, "XStream", "XStream"),
    JACKSON(1, "Jackson", "Jackson");

    public static final int XSTREAM_VALUE = 0;
    public static final int JACKSON_VALUE = 1;
    private static final JsonLibrary[] VALUES_ARRAY;
    public static final List<JsonLibrary> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JsonLibrary[]{XSTREAM, JACKSON};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JsonLibrary get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JsonLibrary result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JsonLibrary getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JsonLibrary result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JsonLibrary get(int value) {
        switch (value) {
            case 0: {
                return XSTREAM;
            }
            case 1: {
                return JACKSON;
            }
        }
        return null;
    }

    private JsonLibrary(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

