/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.db.generic.ui.wizard.NewJDBCFilteredCPWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.Messages;
import org.teiid.designer.advisor.ui.actions.AdvisorActionInfo;
import org.teiid.designer.advisor.ui.actions.DefineProjectAction;
import org.teiid.designer.advisor.ui.actions.DefineSourceAction;
import org.teiid.designer.advisor.ui.actions.DefineVdbAction;
import org.teiid.designer.advisor.ui.actions.DefineViewProcedureAction;
import org.teiid.designer.advisor.ui.actions.DefineViewTableAction;
import org.teiid.designer.advisor.ui.actions.GenerateRESTWarAction;
import org.teiid.designer.advisor.ui.actions.LaunchInstructionsAction;
import org.teiid.designer.advisor.ui.actions.NewModelAction;
import org.teiid.designer.advisor.ui.actions.PropertiesProfileChangedListener;
import org.teiid.designer.advisor.ui.actions.TeiidDesignerActionHandler;
import org.teiid.designer.datatools.ui.actions.SetConnectionProfileAction;
import org.teiid.designer.datatools.ui.dialogs.NewTeiidFilteredCPWizard;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.actions.DeployVdbAction;
import org.teiid.designer.runtime.ui.actions.EditVdbAction;
import org.teiid.designer.runtime.ui.connection.CreateDataSourceAction;
import org.teiid.designer.runtime.ui.preview.PreviewDataAction;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.runtime.ui.vdb.ExecuteVdbAction;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class AdvisorActionFactory
implements AdvisorUiConstants {
    static boolean actionsLoaded = false;
    static final String EXT_PT = "cheatSheetContent";
    static final String ID_ATTR = "id";
    static final String NAME_ATTR = "name";
    static final String CHEATSHEET_ELEMENT = "cheatsheet";
    static final String CHEAT_SHEET_PLUGIN_ID = "org.eclipse.ui.cheatsheets";
    static Map<String, AdvisorActionInfo> actionInfos;
    static IConfigurationElement[] cheatsheets;
    static Collection<IAction> cheatSheetActions;
    static IAction ACTION_IMPORT_DDL;
    static IAction ACTION_IMPORT_TEIID_CONNECTION_DDL;
    static IAction ACTION_IMPORT_FLAT_FILE;
    static IAction ACTION_IMPORT_JDBC;
    static IAction ACTION_IMPORT_SALESFORCE;
    static IAction ACTION_IMPORT_WSDL_TO_SOURCE;
    static IAction ACTION_IMPORT_WSDL_TO_WS;
    static IAction ACTION_IMPORT_XML_FILE;
    static IAction ACTION_IMPORT_XML_FILE_REMOTE;
    static IAction ACTION_CREATE_CONNECTION_FLAT_FILE;
    static IAction ACTION_CREATE_CONNECTION_JDBC;
    static IAction ACTION_CREATE_CONNECTION_LDAP;
    static IAction ACTION_CREATE_CONNECTION_MODESHAPE;
    static IAction ACTION_CREATE_CONNECTION_SALESFORCE;
    static IAction ACTION_CREATE_CONNECTION_WEB_SERVICE;
    static IAction ACTION_CREATE_CONNECTION_WEB_SERVICE_ODA;
    static IAction ACTION_CREATE_CONNECTION_XML_FILE_LOCAL;
    static IAction ACTION_CREATE_CONNECTION_XML_FILE_URL;
    static IAction ACTION_NEW_MODEL_RELATIONAL_SOURCE;
    static IAction ACTION_NEW_MODEL_RELATIONAL_VIEW;
    static IAction ACTION_NEW_MODEL_WS;
    static IAction ACTION_NEW_MODEL_XML_DOC;
    static IAction ACTION_CREATE_VDB;
    static IAction ACTION_DEFINE_VDB;
    static IAction ACTION_EXECUTE_VDB;
    static IAction ACTION_EDIT_VDB;
    static IAction ACTION_DEPLOY_VDB;
    static IAction ACTION_PREVIEW_DATA;
    static IAction ACTION_OPEN_DATA_SOURCE_EXPLORER_VIEW;
    static IAction ACTION_GENERATE_WS_MODELS_FROM_WSDL;
    static IAction ACTION_NEW_TEIID_SERVER;
    static IAction ACTION_EDIT_TEIID_SERVER;
    static IAction ACTION_CREATE_DATA_SOURCE;
    static IAction ACTION_SET_DEFAULT_TEIID_SERVER;
    static IAction ACTION_REFRESH_TEIID_SERVER;
    static IAction ACTION_NEW_TEIID_MODEL_PROJECT;
    static IAction ACTION_DEFINE_TEIID_MODEL_PROJECT;
    static IAction ACTION_DEFINE_VIEW_TABLE;
    static IAction ACTION_DEFINE_VIEW_PROCEDURE;
    static IAction ACTION_DEFINE_REST_PROCEDURE;

    static void loadHandlers() {
        actionInfos = new HashMap<String, AdvisorActionInfo>();
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importDdlCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_DDL, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_DDL, "Create relational source model from a local DDL file");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importFlatFileCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_FLAT_FILE, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_FLAT_FILE, "Create view table to query a flat file source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importJdbcCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_JDBC, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_JDBC, "Create relational source model from your JDBC source metadata");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importSalesforceCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_SALESFORCE, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_SALESFORCE, "Create relational source model defined by your Salesforce metadata");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importWsdlToSourceCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_WSDL_TO_SOURCE, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_WSDL_TO_SOURCE, "Create view tables to query your Web Services defined by WSDL source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importWsdlToWSCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_WSDL_TO_WS, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_WSDL_TO_WS, "Create web service operations defined by your WSDL source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importXmlFileCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_XML_FILE, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_XML_FILE, "Create view table to query your local or remote URL XML file source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importXmlFileUrlCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_XML_FILE_URL, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_XML_FILE_URL, "Create view table to query your remote URL XML file source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.importTeiidConnectionDdlCommand", AdvisorUiConstants.COMMAND_LABELS.IMPORT_TEIID_CONNECTION_DDL, AdvisorUiConstants.COMMAND_LABELS_SHORT.IMPORT_TEIID_CONNECTION_DDL, "Create relational source model from Teiid data source connection DDL");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.flatfile", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_FLAT_FILE, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_FLAT_FILE, "Create connection profile for local flat file source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.jdbc", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_JDBC, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_JDBC, "Create connection profile for JDBC source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.ldap", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_LDAP, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_LDAP, "Create an LDAP connection profile");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.modeshape", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_MODESHAPE, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_MODESHAPE, "Create a Modeshape connection profile");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.salesforce", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_SALESFORCE, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_SALESFORCE, "Create connection profile for your Salesforce source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.ws", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_WEB_SERVICE, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_WEB_SERVICE, "Create a NON-SOAP Web Services connection profile");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.odaws", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_WEB_SERVICE_ODA, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_WEB_SERVICE_ODA, "Create an ODA Web Services connection profile");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.xmlfilelocal", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_XML_FILE_LOCAL, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_XML_FILE_LOCAL, "Create connection profile for your local XML file source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.connection.new.xmlfileurl", AdvisorUiConstants.COMMAND_LABELS.CREATE_CONNECTION_XML_FILE_URL, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_CONNECTION_XML_FILE_URL, "Create connection profile for your remote URL XML file source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.newModelRelationalSourceCommand", AdvisorUiConstants.COMMAND_LABELS.NEW_MODEL_RELATIONAL_SOURCE, AdvisorUiConstants.COMMAND_LABELS_SHORT.NEW_MODEL_RELATIONAL_SOURCE, "Create new relational model. Options include empty model or copy from existing source model");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.newModelRelationalViewCommand", AdvisorUiConstants.COMMAND_LABELS.NEW_MODEL_RELATIONAL_VIEW, AdvisorUiConstants.COMMAND_LABELS_SHORT.NEW_MODEL_RELATIONAL_VIEW, "Create new relational view model. Options include empty model, copy from existing or by transforming from existing relational model");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.newModelWSCommand", AdvisorUiConstants.COMMAND_LABELS.NEW_MODEL_WS, AdvisorUiConstants.COMMAND_LABELS_SHORT.NEW_MODEL_WS, "Create new web services view model");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.newModelXmlDocCommand", AdvisorUiConstants.COMMAND_LABELS.NEW_MODEL_XML_DOC, AdvisorUiConstants.COMMAND_LABELS_SHORT.NEW_MODEL_XML_DOC, "Create new XML document view model");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.vdb.create", AdvisorUiConstants.COMMAND_LABELS.CREATE_VDB, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_VDB, "Create a new VDB");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.vdb.define", AdvisorUiConstants.COMMAND_LABELS.DEFINE_VDB, AdvisorUiConstants.COMMAND_LABELS_SHORT.DEFINE_VDB, "Define VDB by selecting existing or creating new VDB");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.defineSource", AdvisorUiConstants.COMMAND_LABELS.DEFINE_SOURCE, AdvisorUiConstants.COMMAND_LABELS_SHORT.DEFINE_SOURCE, "Define Source Model by importing from your data source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.vdb.execute", AdvisorUiConstants.COMMAND_LABELS.EXECUTE_VDB, AdvisorUiConstants.COMMAND_LABELS.EXECUTE_VDB, "Test a VDB by deploying to Teiid Instance, connecting to it via JDBC and executing queries against it via Datatools' SQL Scrapbook");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.vdb.edit", AdvisorUiConstants.COMMAND_LABELS.EDIT_VDB, AdvisorUiConstants.COMMAND_LABELS_SHORT.EDIT_VDB, "Select and open a VDB for editing");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.vdb.deploy", AdvisorUiConstants.COMMAND_LABELS.DEPLOY_VDB, AdvisorUiConstants.COMMAND_LABELS_SHORT.DEPLOY_VDB, "Deploy a VDB to your Teiid Instance");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.previewData", AdvisorUiConstants.COMMAND_LABELS.PREVIEW_DATA, AdvisorUiConstants.COMMAND_LABELS.PREVIEW_DATA, "Perform a test query on a table or procedure");
        AdvisorActionFactory.addActionHandler("org.eclipse.datatools.openexplorerview", AdvisorUiConstants.COMMAND_LABELS.OPEN_DATA_SOURCE_EXPLORER_VIEW, AdvisorUiConstants.COMMAND_LABELS.OPEN_DATA_SOURCE_EXPLORER_VIEW, "Open Datatools' Data Source Explorer view");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.generatewsmodelsfromwsdl", AdvisorUiConstants.COMMAND_LABELS.GENERATE_WS_MODELS_FROM_WSDL, AdvisorUiConstants.COMMAND_LABELS.GENERATE_WS_MODELS_FROM_WSDL, "Generate source and view models to access data from your web service. ");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.runtime.newTeiidServer", AdvisorUiConstants.COMMAND_LABELS.NEW_TEIID_SERVER, AdvisorUiConstants.COMMAND_LABELS_SHORT.NEW_TEIID_SERVER, "Configure new JBoss Server");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.runtime.editTeiidServer", AdvisorUiConstants.COMMAND_LABELS.EDIT_TEIID_SERVER, AdvisorUiConstants.COMMAND_LABELS_SHORT.EDIT_TEIID_SERVER, "Edit the properties of an existing Teiid Instance");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.runtime.createDataSource", AdvisorUiConstants.COMMAND_LABELS.CREATE_DATA_SOURCE, AdvisorUiConstants.COMMAND_LABELS_SHORT.CREATE_DATA_SOURCE, "Create a data source (i.e. -ds.xml) on your Teiid Instance from source models or source connections in your workspace");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.runtime.setDefaultTeiidServer", AdvisorUiConstants.COMMAND_LABELS.SET_DEFAULT_TEIID_SERVER, AdvisorUiConstants.COMMAND_LABELS_SHORT.SET_DEFAULT_TEIID_SERVER, "Select a teiid instance as the default instance, used to select the correct runtime client and for previewing models");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.runtime.refreshDefaultTeiidServer", AdvisorUiConstants.COMMAND_LABELS.REFRESH_TEIID_SERVER, AdvisorUiConstants.COMMAND_LABELS_SHORT.REFRESH_TEIID_SERVER, "Refresh the connection to the selected teiid instance");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.newProjectCommand", AdvisorUiConstants.COMMAND_LABELS.NEW_TEIID_MODEL_PROJECT, AdvisorUiConstants.COMMAND_LABELS_SHORT.NEW_TEIID_MODEL_PROJECT, "Create new Teiid Model Project");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.defineProjectCommand", AdvisorUiConstants.COMMAND_LABELS.DEFINE_TEIID_MODEL_PROJECT, AdvisorUiConstants.COMMAND_LABELS_SHORT.DEFINE_TEIID_MODEL_PROJECT, "Define Teiid Model Project by selecting existing or creating new project");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.defineViewTable", AdvisorUiConstants.COMMAND_LABELS.DEFINE_VIEW_TABLE, AdvisorUiConstants.COMMAND_LABELS_SHORT.DEFINE_VIEW_TABLE, "Define relational view table by creating or selecting existing table");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.defineViewProcedure", AdvisorUiConstants.COMMAND_LABELS.DEFINE_VIEW_PROCEDURE, AdvisorUiConstants.COMMAND_LABELS_SHORT.DEFINE_VIEW_PROCEDURE, "Define relational view procedure by creating or selecting existing procedure");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.newObjectRestProcedure", AdvisorUiConstants.COMMAND_LABELS.NEW_OBJECT_REST_PROCEDURE, AdvisorUiConstants.COMMAND_LABELS_SHORT.NEW_OBJECT_REST_PROCEDURE, "Create new relational view REST procedure");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.war.rest.generate", AdvisorUiConstants.COMMAND_LABELS.GENERATE_REST_WAR, AdvisorUiConstants.COMMAND_LABELS_SHORT.GENERATE_REST_WAR, "Generate a REST WAR file");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.war.soap.generate", AdvisorUiConstants.COMMAND_LABELS.GENERATE_SOAP_WAR, AdvisorUiConstants.COMMAND_LABELS_SHORT.GENERATE_SOAP_WAR, "Generate a JBossWS-CXF WAR file");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.war.deploy", AdvisorUiConstants.COMMAND_LABELS.DEPLOY_WAR, AdvisorUiConstants.COMMAND_LABELS_SHORT.DEPLOY_WAR, "To deploy WAR file :\n\t1) Insure target JBossAS is configured and running\n\t2) Select your WAR file in the Model Explorer view\n\t3) Right-click select 'Mark as Deployable'");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.datatools.ui.actions.SetConnectionProfileAction", AdvisorUiConstants.COMMAND_LABELS.SET_CONNECTION_PROFILE, AdvisorUiConstants.COMMAND_LABELS_SHORT.SET_CONNECTION_PROFILE, "Set connection profile on a relational source model");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.ui.cheatsheet_advisor_01", "Model From JDBC Source", "Model From JDBC Source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.ui.cheatsheet_advisor_06", "Create a Multi-source VDB", "Create a Multi-source VDB");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.ui.cheatsheet_advisor_04", "Model XML Local File Source", "Model XML Local File Source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.ui.cheatsheet_advisor_05", "Model XML Remote Source", "Model XML Remote Source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.ui.cheatsheet_advisor_02", "Model Flat File Source", "Model Flat File Source");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.ui.cheatsheet_advisor_07", "Create and test a VDB", "Create and test a VDB");
        AdvisorActionFactory.addActionHandler("org.teiid.designer.ui.cheatsheet_advisor_03", "Consume a SOAP Web Service", "Consume a SOAP Web Service");
    }

    public static AbstractHandler getActionHandler(String id) {
        AdvisorActionInfo info;
        if (actionInfos == null) {
            AdvisorActionFactory.loadHandlers();
        }
        if ((info = AdvisorActionFactory.getActionInfo(id)) != null) {
            return info.getActionHandler();
        }
        return null;
    }

    public static AdvisorActionInfo getActionInfo(String id) {
        if (actionInfos == null) {
            AdvisorActionFactory.loadHandlers();
        }
        return actionInfos.get(id);
    }

    private static void addActionHandler(String id, String displayName, String shortDisplayName) {
        actionInfos.put(id, AdvisorActionFactory.createInfo(id, displayName, shortDisplayName));
    }

    private static void addActionHandler(String id, String displayName, String shortDisplayName, String description) {
        AdvisorActionInfo info = AdvisorActionFactory.createInfo(id, displayName, shortDisplayName);
        if (description != null) {
            info.setDescription(description);
        }
        actionInfos.put(id, info);
    }

    public static AdvisorActionInfo createInfo(String commandId, String displayName, String shortDisplayName) {
        TeiidDesignerActionHandler handler = new TeiidDesignerActionHandler(commandId, displayName);
        AdvisorActionInfo info = new AdvisorActionInfo(commandId, displayName, shortDisplayName, handler);
        String imageId = AdvisorActionFactory.getImageId(commandId);
        info.setImageId(imageId);
        return info;
    }

    public static void executeAction(TeiidDesignerActionHandler actionHandler, boolean synchronous) {
        AdvisorActionFactory.executeAction(actionHandler.getId(), synchronous);
    }

    public static void executeAction(String id, boolean synchronous) {
        AdvisorActionFactory.executeAction(id, null, synchronous);
    }

    public static void executeAction(String id, Properties properties, boolean synchronous) {
        if (id.equalsIgnoreCase("org.teiid.designer.importDdlCommand")) {
            AdvisorActionFactory.launchWizard("org.teiid.designer.ddl.importer.ui.ddlImportWizard", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importFlatFileCommand")) {
            AdvisorActionFactory.launchWizard("teiidMetadataImportWizard", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importJdbcCommand")) {
            AdvisorActionFactory.launchWizard("jdbcImportWizard", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importSalesforceCommand")) {
            AdvisorActionFactory.launchWizard("SalesforceToRelationalImportWizard", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importXmlFileCommand")) {
            properties.put("xmlImportType", "local");
            AdvisorActionFactory.launchWizard("teiidXmlImportWizard", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importXmlFileUrlCommand")) {
            properties.put("xmlImportType", "remote");
            AdvisorActionFactory.launchWizard("teiidXmlImportWizard", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importWsdlToSourceCommand")) {
            AdvisorActionFactory.launchWizard("org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportWsdlSoapWizardID", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importWsdlToWSCommand")) {
            AdvisorActionFactory.launchWizard("wsdlFileSystemImportWizard", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importTeiidConnectionDdlCommand")) {
            AdvisorActionFactory.launchWizard("teiidImportWizard", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newModelRelationalSourceCommand")) {
            AdvisorActionFactory.createNewModel(ModelType.PHYSICAL_LITERAL, "Relational", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newModelRelationalViewCommand")) {
            AdvisorActionFactory.createNewModel(ModelType.VIRTUAL_LITERAL, "Relational", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newModelWSCommand")) {
            AdvisorActionFactory.createNewModel(ModelType.VIRTUAL_LITERAL, "Web Service", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newModelXmlDocCommand")) {
            AdvisorActionFactory.createNewModel(ModelType.VIRTUAL_LITERAL, "XML", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.defineViewTable")) {
            DefineViewTableAction action = new DefineViewTableAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.defineViewProcedure")) {
            DefineViewProcedureAction action = new DefineViewProcedureAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.jdbc")) {
            AdvisorActionFactory.createConnection("org.eclipse.datatools.connectivity.db.category", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.flatfile")) {
            AdvisorActionFactory.createConnection("org.eclipse.datatools.connectivity.oda.flatfile", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.ldap")) {
            AdvisorActionFactory.createConnection("org.teiid.designer.datatools.profiles.ldap.LDAPConnectionProfile", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.modeshape")) {
            AdvisorActionFactory.createConnection("org.teiid.designer.datatools.profiles.modeshape.ModeShapeConnectionProfile", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.salesforce")) {
            AdvisorActionFactory.createConnection("org.teiid.designer.datatools.salesforce.connectionProfile", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.ws")) {
            AdvisorActionFactory.createConnection("org.teiid.designer.datatools.profiles.ws.WSConnectionProfile", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.odaws")) {
            AdvisorActionFactory.createConnection("org.teiid.designer.datatools.profiles.ws.WSSoapConnectionProfile", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.xmlfilelocal")) {
            AdvisorActionFactory.createConnection("org.teiid.designer.datatools.profiles.xml.localfile", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.xmlfileurl")) {
            AdvisorActionFactory.createConnection("org.teiid.designer.datatools.profiles.xml.fileurl", properties);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.generatewsmodelsfromwsdl")) {
            AdvisorActionFactory.launchWizard("org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportWsdlSoapWizardID", properties, synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.create")) {
            ModelerUiViewUtils.launchWizard((String)"newVdbWizard", (IStructuredSelection)new StructuredSelection(), (Properties)properties, (boolean)synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.define")) {
            DefineVdbAction action = new DefineVdbAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.edit")) {
            EditVdbAction action = new EditVdbAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.execute")) {
            ExecuteVdbAction action = new ExecuteVdbAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.deploy")) {
            DeployVdbAction action = new DeployVdbAction(properties);
            action.queryUserAndRun();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newProjectCommand")) {
            ModelerUiViewUtils.launchWizard((String)"newModelProject", (IStructuredSelection)new StructuredSelection(), (Properties)properties, (boolean)synchronous);
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.defineProjectCommand")) {
            DefineProjectAction action = new DefineProjectAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.eclipse.datatools.openexplorerview")) {
            try {
                UiUtil.getWorkbenchPage().showView("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
            }
            catch (PartInitException err) {
                AdvisorUiConstants.UTIL.log((Throwable)err);
                WidgetUtil.showError((String)err.getLocalizedMessage());
            }
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.previewData")) {
            PreviewDataAction action = new PreviewDataAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.newTeiidServer")) {
            RuntimeAssistant.runNewServerAction((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.editTeiidServer")) {
            RuntimeAssistant.runEditServerAction((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.createDataSource")) {
            if (RuntimeAssistant.ensureServerConnection((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CreateDataSource_NoServerMessage, (boolean)false)) {
                try {
                    ITeiidServer teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                    CreateDataSourceAction action = new CreateDataSourceAction();
                    action.setTeiidServer(teiidServer);
                    action.setSelection((ISelection)new StructuredSelection());
                    action.setEnabled(true);
                    action.run();
                }
                catch (Exception ex) {
                    AdvisorUiConstants.UTIL.log((Throwable)ex);
                }
            }
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.setDefaultTeiidServer")) {
            RuntimeAssistant.runSetDefaultServerAction();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.refreshDefaultTeiidServer")) {
            RuntimeAssistant.runRefreshServerAction();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.defineSource")) {
            DefineSourceAction action = new DefineSourceAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.war.rest.generate")) {
            GenerateRESTWarAction action = new GenerateRESTWarAction(properties);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.war.deploy")) {
            LaunchInstructionsAction action = new LaunchInstructionsAction(AdvisorUiConstants.INSTRUCTIONS.DEPLOY_WAR_FILE);
            action.run();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.datatools.ui.actions.SetConnectionProfileAction")) {
            SetConnectionProfileAction action = new SetConnectionProfileAction();
            action.setProperties(properties);
            action.setConnectionProfile();
            return;
        }
        if (id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_03") || id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_07") || id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_02") || id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_01") || id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_04") || id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_05") || id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_06")) {
            AdvisorActionFactory.executeCheatSheet(id);
            return;
        }
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unimplemented Action", (String)("Action for ID [" + id + "] is not yet implemented"));
    }

    public static ImageDescriptor getImageDesciptor(String commandId) {
        String id = AdvisorActionFactory.getImageId(commandId);
        if (id != null) {
            return AdvisorUiPlugin.getDefault().getImageDescriptor(AdvisorActionFactory.getImageId(commandId));
        }
        return null;
    }

    public static String getImageId(String id) {
        if (id.equalsIgnoreCase("org.teiid.designer.importDdlCommand")) {
            return "icons/full/ctool16/import.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importFlatFileCommand")) {
            return "icons/full/ctool16/import.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importJdbcCommand")) {
            return "icons/full/ctool16/import-jdbc.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importSalesforceCommand")) {
            return "icons/full/ctool16/import.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importXmlFileCommand")) {
            return "icons/full/ctool16/import.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importXmlFileUrlCommand")) {
            return "icons/full/ctool16/import.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importWsdlToSourceCommand")) {
            return "icons/full/ctool16/import-wsdl.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importWsdlToWSCommand")) {
            return "icons/full/ctool16/import-wsdl.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.importTeiidConnectionDdlCommand")) {
            return "icons/full/ctool16/import-teiid-connection.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newModelRelationalSourceCommand")) {
            return "icons/full/ctool16/new-model-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newModelRelationalViewCommand")) {
            return "icons/full/ctool16/new-model-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newModelWSCommand")) {
            return "icons/full/ctool16/new-model-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newModelXmlDocCommand")) {
            return "icons/full/ctool16/new-model-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.jdbc")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.flatfile")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.ldap")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.modeshape")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.salesforce")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.ws")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.odaws")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.xmlfilelocal")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.connection.new.xmlfileurl")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.generatewsmodelsfromwsdl")) {
            return "icons/full/ctool16/new-web-services-model.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.create")) {
            return "icons/full/ctool16/new-vdb-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.define")) {
            return "icons/full/ctool16/new-vdb-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.execute")) {
            return "icons/full/ctool16/execute-vdb.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.previewData")) {
            return "icons/full/ctool16/preview-data.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.createDataSource")) {
            return "icons/full/ctool16/create-data-source.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.edit")) {
            return "icons/full/ctool16/edit-vdb.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.vdb.deploy")) {
            return "icons/full/ctool16/deploy-vdb.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newProjectCommand")) {
            return "icons/full/ctool16/new-project-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.defineProjectCommand")) {
            return "icons/full/ctool16/new-project-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.eclipse.datatools.openexplorerview")) {
            return "icons/full/ctool16/data-source-explorer-view.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.newTeiidServer")) {
            return "icons/full/ctool16/new-teiid-server.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.editTeiidServer")) {
            return "icons/full/ctool16/edit-teiid-server.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.setDefaultTeiidServer")) {
            return "icons/full/ctool16/default_server.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.runtime.refreshDefaultTeiidServer")) {
            return "icons/full/ctool16/refresh-server.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.defineViewTable")) {
            return "icons/full/cview16/new-view-table.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.defineViewProcedure")) {
            return "icons/full/cview16/new-view-procedure.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.newObjectRestProcedure")) {
            return "icons/full/cview16/new-view-procedure.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.war.rest.generate")) {
            return "icons/full/cview16/generate-war.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.war.soap.generate")) {
            return "icons/full/cview16/generate-war.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.war.deploy")) {
            return "icons/full/cview16/deploy-war.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.defineSource")) {
            return "icons/full/ctool16/import-create-models.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_03")) {
            return "icons/full/ctool16/new-web-services-definition-file.png";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_07")) {
            return "icons/full/ctool16/execute-vdb.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_02")) {
            return "icons/full/ctool16/import-jdbc.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_01")) {
            return "icons/full/ctool16/import-jdbc.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_04")) {
            return "icons/full/ctool16/import-wsdl.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_05")) {
            return "icons/full/ctool16/import-wsdl.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.ui.cheatsheet_advisor_06")) {
            return "icons/full/ctool16/new-vdb-wiz.gif";
        }
        if (id.equalsIgnoreCase("org.teiid.designer.datatools.ui.actions.SetConnectionProfileAction")) {
            return "icons/full/ctool16/new-connection-profile.gif";
        }
        return null;
    }

    public static Image getImage(AdvisorActionInfo actionInfo) {
        return AdvisorActionFactory.getImage(AdvisorActionFactory.getImageId(actionInfo.getId()));
    }

    public static Image getImage(String imageId) {
        return AdvisorUiPlugin.getDefault().getImage(imageId);
    }

    private static void createNewModel(ModelType type, String modelClass, Properties properties) {
        NewModelAction nma = new NewModelAction(type, modelClass, null, properties);
        nma.run();
    }

    private static void launchWizard(String id, Properties properties, boolean synchronous) {
        ModelerUiViewUtils.launchWizard((String)id, (IStructuredSelection)new StructuredSelection(), (Properties)properties, (boolean)synchronous);
    }

    private static void createConnection(String id, Properties properties) {
        PropertiesProfileChangedListener listener = new PropertiesProfileChangedListener(properties);
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        if (id.equalsIgnoreCase("org.eclipse.datatools.connectivity.db.category")) {
            NewJDBCFilteredCPWizard wiz = new NewJDBCFilteredCPWizard();
            ModelerUiViewUtils.launchWizard((IWorkbenchWizard)wiz, (IStructuredSelection)new StructuredSelection(), (Properties)properties, (boolean)true, (boolean)false);
        } else {
            NewTeiidFilteredCPWizard wiz = new NewTeiidFilteredCPWizard(id);
            ModelerUiViewUtils.launchWizard((IWorkbenchWizard)wiz, (IStructuredSelection)new StructuredSelection(), (Properties)properties, (boolean)true, (boolean)false);
        }
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
    }

    public static void addActionsLibraryToMenu(IMenuManager manager) {
        if (!actionsLoaded) {
            AdvisorActionFactory.initActions();
        }
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.MODEL_PROJECT_MANAGEMENT, ASPECT_MODEL_PROJECT_MANAGEMENT);
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.DEFINE_MODELS, ASPECT_DEFINE_MODELS);
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.MANAGE_CONNECTIONS, ASPECT_MANAGE_CONNECTIONS);
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.MODEL_DATA_SOURCES, ASPECT_MODEL_DATA_SOURCES);
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.CONSUME_REST_WS, ASPECT_CONSUME_REST_WS);
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.DEFINE_MODEL_OBJECTS, ASPECT_DEFINE_MODEL_OBJECTS);
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.MANAGE_VDBS, ASPECT_MANAGE_VDBS);
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.TEIID_SERVER, ASPECT_TEIID_SERVER);
        AdvisorActionFactory.addMenuForAspect(manager, AdvisorUiConstants.MODELING_ASPECT_LABELS.TEST, ASPECT_TEST);
        if (!cheatSheetActions.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            MenuManager subManager = new MenuManager("Cheat Sheets");
            for (IAction action : cheatSheetActions) {
                subManager.add(action);
            }
            manager.add((IContributionItem)subManager);
        }
    }

    private static void addMenuForAspect(IMenuManager manager, String aspectId, String[] aspectCommandsIds) {
        if (aspectCommandsIds.length == 0) {
            return;
        }
        MenuManager subManager = new MenuManager(aspectId);
        String[] stringArray = aspectCommandsIds;
        int n = aspectCommandsIds.length;
        int n2 = 0;
        while (n2 < n) {
            String commandId = stringArray[n2];
            IAction action = AdvisorActionFactory.getAction(commandId);
            if (action != null) {
                subManager.add(action);
            }
            ++n2;
        }
        manager.add((IContributionItem)subManager);
    }

    public static void executeCheatSheet(String id) {
        for (IAction action : cheatSheetActions) {
            if (!action.getId().equalsIgnoreCase(id)) continue;
            action.run();
        }
    }

    private static IAction getAction(String commandId) {
        if (commandId.equalsIgnoreCase("org.teiid.designer.importDdlCommand")) {
            return ACTION_IMPORT_DDL;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.importTeiidConnectionDdlCommand")) {
            return ACTION_IMPORT_TEIID_CONNECTION_DDL;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.importFlatFileCommand")) {
            return ACTION_IMPORT_FLAT_FILE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.importJdbcCommand")) {
            return ACTION_IMPORT_JDBC;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.importSalesforceCommand")) {
            return ACTION_IMPORT_SALESFORCE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.importXmlFileCommand")) {
            return ACTION_IMPORT_WSDL_TO_SOURCE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.importWsdlToSourceCommand")) {
            return ACTION_IMPORT_WSDL_TO_WS;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.importWsdlToWSCommand")) {
            return ACTION_IMPORT_XML_FILE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.newModelRelationalSourceCommand")) {
            return ACTION_NEW_MODEL_RELATIONAL_SOURCE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.newModelRelationalViewCommand")) {
            return ACTION_NEW_MODEL_RELATIONAL_VIEW;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.newModelWSCommand")) {
            return ACTION_NEW_MODEL_WS;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.newModelXmlDocCommand")) {
            return ACTION_NEW_MODEL_XML_DOC;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.jdbc")) {
            return ACTION_CREATE_CONNECTION_JDBC;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.flatfile")) {
            return ACTION_CREATE_CONNECTION_FLAT_FILE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.ldap")) {
            return ACTION_CREATE_CONNECTION_LDAP;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.modeshape")) {
            return ACTION_CREATE_CONNECTION_MODESHAPE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.salesforce")) {
            return ACTION_CREATE_CONNECTION_SALESFORCE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.ws")) {
            return ACTION_CREATE_CONNECTION_WEB_SERVICE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.odaws")) {
            return ACTION_CREATE_CONNECTION_WEB_SERVICE_ODA;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.xmlfilelocal")) {
            return ACTION_CREATE_CONNECTION_XML_FILE_LOCAL;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.connection.new.xmlfileurl")) {
            return ACTION_CREATE_CONNECTION_XML_FILE_URL;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.generatewsmodelsfromwsdl")) {
            return ACTION_GENERATE_WS_MODELS_FROM_WSDL;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.vdb.create")) {
            return ACTION_CREATE_VDB;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.vdb.define")) {
            return ACTION_CREATE_VDB;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.vdb.execute")) {
            return ACTION_EXECUTE_VDB;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.previewData")) {
            return ACTION_PREVIEW_DATA;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.runtime.createDataSource")) {
            return ACTION_CREATE_DATA_SOURCE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.vdb.edit")) {
            return ACTION_EDIT_VDB;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.vdb.deploy")) {
            return ACTION_DEPLOY_VDB;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.newProjectCommand")) {
            return ACTION_NEW_TEIID_MODEL_PROJECT;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.defineProjectCommand")) {
            return ACTION_DEFINE_TEIID_MODEL_PROJECT;
        }
        if (commandId.equalsIgnoreCase("org.eclipse.datatools.openexplorerview")) {
            return ACTION_OPEN_DATA_SOURCE_EXPLORER_VIEW;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.runtime.newTeiidServer")) {
            return ACTION_NEW_TEIID_SERVER;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.runtime.editTeiidServer")) {
            return ACTION_EDIT_TEIID_SERVER;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.runtime.setDefaultTeiidServer")) {
            return ACTION_SET_DEFAULT_TEIID_SERVER;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.runtime.refreshDefaultTeiidServer")) {
            return ACTION_REFRESH_TEIID_SERVER;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.defineViewTable")) {
            return ACTION_DEFINE_VIEW_TABLE;
        }
        if (commandId.equalsIgnoreCase("org.teiid.designer.defineViewProcedure")) {
            return ACTION_DEFINE_VIEW_PROCEDURE;
        }
        return null;
    }

    private static void initActions() {
        actionsLoaded = true;
        AdvisorActionFactory.loadCheatSheetExtensions();
        cheatSheetActions = new ArrayList<IAction>();
        IConfigurationElement[] iConfigurationElementArray = cheatsheets;
        int n = cheatsheets.length;
        int n2 = 0;
        while (n2 < n) {
            String sheetName;
            IAction action;
            IConfigurationElement cheatSheet = iConfigurationElementArray[n2];
            String id = cheatSheet.getAttribute(ID_ATTR);
            if (id.indexOf("teiid") > -1 && (action = AdvisorActionFactory.createCheatSheetAction(id, sheetName = cheatSheet.getAttribute(NAME_ATTR))) != null) {
                cheatSheetActions.add(action);
            }
            ++n2;
        }
        ACTION_IMPORT_DDL = AdvisorActionFactory.createAction("org.teiid.designer.importDdlCommand");
        ACTION_IMPORT_TEIID_CONNECTION_DDL = AdvisorActionFactory.createAction("org.teiid.designer.importTeiidConnectionDdlCommand");
        ACTION_IMPORT_FLAT_FILE = AdvisorActionFactory.createAction("org.teiid.designer.importFlatFileCommand");
        ACTION_IMPORT_JDBC = AdvisorActionFactory.createAction("org.teiid.designer.importJdbcCommand");
        ACTION_IMPORT_SALESFORCE = AdvisorActionFactory.createAction("org.teiid.designer.importSalesforceCommand");
        ACTION_IMPORT_WSDL_TO_SOURCE = AdvisorActionFactory.createAction("org.teiid.designer.importWsdlToSourceCommand");
        ACTION_IMPORT_WSDL_TO_WS = AdvisorActionFactory.createAction("org.teiid.designer.importWsdlToWSCommand");
        ACTION_IMPORT_XML_FILE = AdvisorActionFactory.createAction("org.teiid.designer.importXmlFileCommand");
        ACTION_IMPORT_XML_FILE_REMOTE = AdvisorActionFactory.createAction("org.teiid.designer.importXmlFileUrlCommand");
        ACTION_CREATE_CONNECTION_FLAT_FILE = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.flatfile");
        ACTION_CREATE_CONNECTION_JDBC = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.jdbc");
        ACTION_CREATE_CONNECTION_LDAP = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.ldap");
        ACTION_CREATE_CONNECTION_MODESHAPE = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.modeshape");
        ACTION_CREATE_CONNECTION_SALESFORCE = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.salesforce");
        ACTION_CREATE_CONNECTION_WEB_SERVICE = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.ws");
        ACTION_CREATE_CONNECTION_WEB_SERVICE_ODA = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.odaws");
        ACTION_CREATE_CONNECTION_XML_FILE_LOCAL = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.xmlfilelocal");
        ACTION_CREATE_CONNECTION_XML_FILE_URL = AdvisorActionFactory.createAction("org.teiid.designer.connection.new.xmlfileurl");
        ACTION_NEW_MODEL_RELATIONAL_SOURCE = AdvisorActionFactory.createAction("org.teiid.designer.newModelRelationalSourceCommand");
        ACTION_NEW_MODEL_RELATIONAL_VIEW = AdvisorActionFactory.createAction("org.teiid.designer.newModelRelationalViewCommand");
        ACTION_NEW_MODEL_WS = AdvisorActionFactory.createAction("org.teiid.designer.newModelWSCommand");
        ACTION_NEW_MODEL_XML_DOC = AdvisorActionFactory.createAction("org.teiid.designer.newModelXmlDocCommand");
        ACTION_CREATE_VDB = AdvisorActionFactory.createAction("org.teiid.designer.vdb.create");
        ACTION_EXECUTE_VDB = AdvisorActionFactory.createAction("org.teiid.designer.vdb.execute");
        ACTION_EDIT_VDB = AdvisorActionFactory.createAction("org.teiid.designer.vdb.edit");
        ACTION_DEPLOY_VDB = AdvisorActionFactory.createAction("org.teiid.designer.vdb.deploy");
        ACTION_PREVIEW_DATA = AdvisorActionFactory.createAction("org.teiid.designer.previewData");
        ACTION_OPEN_DATA_SOURCE_EXPLORER_VIEW = AdvisorActionFactory.createAction("org.eclipse.datatools.openexplorerview");
        ACTION_GENERATE_WS_MODELS_FROM_WSDL = AdvisorActionFactory.createAction("org.teiid.designer.generatewsmodelsfromwsdl");
        ACTION_NEW_TEIID_SERVER = AdvisorActionFactory.createAction("org.teiid.designer.runtime.newTeiidServer");
        ACTION_EDIT_TEIID_SERVER = AdvisorActionFactory.createAction("org.teiid.designer.runtime.editTeiidServer");
        ACTION_CREATE_DATA_SOURCE = AdvisorActionFactory.createAction("org.teiid.designer.runtime.createDataSource");
        ACTION_SET_DEFAULT_TEIID_SERVER = AdvisorActionFactory.createAction("org.teiid.designer.runtime.setDefaultTeiidServer");
        ACTION_REFRESH_TEIID_SERVER = AdvisorActionFactory.createAction("org.teiid.designer.runtime.refreshDefaultTeiidServer");
        ACTION_NEW_TEIID_MODEL_PROJECT = AdvisorActionFactory.createAction("org.teiid.designer.newProjectCommand");
        ACTION_DEFINE_TEIID_MODEL_PROJECT = AdvisorActionFactory.createAction("org.teiid.designer.defineProjectCommand");
        ACTION_DEFINE_VIEW_TABLE = AdvisorActionFactory.createAction("org.teiid.designer.defineViewTable");
        ACTION_DEFINE_VIEW_PROCEDURE = AdvisorActionFactory.createAction("org.teiid.designer.defineViewProcedure");
        ACTION_DEFINE_REST_PROCEDURE = AdvisorActionFactory.createAction("org.teiid.designer.newObjectRestProcedure");
    }

    private static IAction createAction(String commandId) {
        final AdvisorActionInfo info = AdvisorActionFactory.getActionInfo(commandId);
        if (info != null) {
            Action action = new Action(info.getDisplayName()){

                public void run() {
                    AdvisorActionFactory.executeAction(info.getId(), true);
                }
            };
            ImageDescriptor desc = AdvisorActionFactory.getImageDesciptor(info.getId());
            if (desc != null) {
                action.setImageDescriptor(desc);
            }
            return action;
        }
        return null;
    }

    private static IAction createCheatSheetAction(final String sheetId, String name) {
        if (sheetId != null) {
            Action action = new Action(name){

                public void run() {
                    OpenCheatSheetAction action = new OpenCheatSheetAction(sheetId);
                    action.run();
                }
            };
            action.setId(sheetId);
            return action;
        }
        return null;
    }

    private static void loadCheatSheetExtensions() {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CHEAT_SHEET_PLUGIN_ID, EXT_PT);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length != 0) {
            ArrayList<IConfigurationElement> temp = new ArrayList<IConfigurationElement>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(CHEATSHEET_ELEMENT)) {
                        temp.add(elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
            if (!temp.isEmpty()) {
                cheatsheets = new IConfigurationElement[temp.size()];
                temp.toArray(cheatsheets);
            } else {
                cheatsheets = new IConfigurationElement[0];
            }
        }
        if (cheatsheets == null) {
            cheatsheets = new IConfigurationElement[0];
        }
    }
}

