/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.core;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.Messages;
import org.teiid.designer.advisor.ui.core.InfoPopAction;
import org.teiid.designer.advisor.ui.core.StyledLineWrapper;

public class AdvisorFixDialog {
    private Color backgroundColour = null;
    private Color foregroundColour = null;
    protected Shell parentShell;
    protected Shell shell;
    protected String infopopText;
    protected FormToolkit toolkit;
    private static final String FIVE_SPACES = "     ";

    public AdvisorFixDialog(InfoPopAction[] actions, int x, int y, FormToolkit toolkit) {
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        this.toolkit = toolkit;
        this.backgroundColour = display.getSystemColor(22);
        this.foregroundColour = display.getSystemColor(28);
        this.parentShell = display.getActiveShell();
        this.shell = new Shell(this.parentShell, 0);
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                AdvisorFixDialog.this.close();
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = true;
                }
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                Rectangle clientArea = AdvisorFixDialog.this.shell.getClientArea();
                AdvisorFixDialog.this.shell.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, true);
                AdvisorFixDialog.this.shell.update();
            }
        });
        this.createContents((Composite)this.shell, actions);
        this.shell.pack();
        int width = this.shell.getBounds().width;
        int height = this.shell.getBounds().height;
        Rectangle screen = display.getClientArea();
        x = (x += 10) >= screen.x ? x : screen.x;
        y = y >= screen.y ? y : screen.y;
        x = x + width <= screen.width ? x : screen.width - width;
        y = y + height <= screen.height ? y : screen.height - height;
        this.shell.setLocation(x, y);
        this.initAccessible((Control)this.shell);
    }

    public synchronized void close() {
        try {
            if (this.shell != null) {
                this.shell.close();
                if (!this.shell.isDisposed()) {
                    this.shell.dispose();
                }
                this.shell = null;
            }
        }
        catch (Throwable throwable) {}
    }

    protected Control createContents(Composite contents, InfoPopAction[] actions) {
        Control c;
        this.initAccessible((Control)contents);
        contents.setBackground(this.backgroundColour);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        if (actions.length == 0) {
            this.createInfoArea(contents, actions.length);
        }
        if (actions.length > 0 && (c = this.createLinksArea(contents, actions)) != null) {
            contents.setTabList(new Control[]{c});
        }
        return contents;
    }

    private Control createInfoArea(Composite parent, int nActions) {
        String styledText = nActions == 0 ? Messages.AdvisorFixDialog_Message_NoActions : Messages.AdvisorFixDialog_Message_AvailableActions;
        Description text = new Description(parent, 10);
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = true;
                }
            }
        });
        text.getCaret().setVisible(false);
        text.setBackground(this.backgroundColour);
        text.setForeground(this.foregroundColour);
        text.setFont(parent.getFont());
        int linkWidth = this.getLinksWidth(text);
        StyledLineWrapper content = new StyledLineWrapper(styledText, (Drawable)text, linkWidth + 70);
        text.setContent(content);
        text.setStyleRanges(content.getStyles());
        this.infopopText = text.getText();
        this.initAccessible((Control)text);
        return text;
    }

    private int getLinksWidth(Description text) {
        int linkWidth = 200;
        return linkWidth;
    }

    private Control createLinksArea(Composite parent, InfoPopAction[] actions) {
        Label label;
        Composite composite = new Composite(parent, 0);
        this.initAccessible((Control)composite);
        boolean hasFixes = false;
        boolean hasDos = false;
        boolean hasOthers = false;
        int i = 0;
        while (i < actions.length) {
            if (!hasFixes && actions[i].getType() == 0) {
                hasFixes = true;
            }
            if (!hasDos && actions[i].getType() == 1) {
                hasDos = true;
            }
            if (!hasOthers && actions[i].getType() == 2) {
                hasOthers = true;
            }
            ++i;
        }
        composite.setBackground(this.backgroundColour);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 2;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(1844);
        composite.setLayoutData((Object)data);
        if (hasFixes) {
            this.addActions(composite, actions, 0);
        }
        if (hasDos) {
            if (hasFixes) {
                label = new Label(composite, 258);
                label.setBackground(this.backgroundColour);
                label.setForeground(this.foregroundColour);
                data = new GridData(802);
                data.horizontalSpan = 3;
                label.setLayoutData((Object)data);
            }
            this.addActions(composite, actions, 1);
        }
        if (hasOthers) {
            if (hasDos || hasFixes) {
                label = new Label(composite, 258);
                label.setBackground(this.backgroundColour);
                label.setForeground(this.foregroundColour);
                data = new GridData(802);
                data.horizontalSpan = 3;
                label.setLayoutData((Object)data);
            }
            this.addActions(composite, actions, 2);
        }
        return composite;
    }

    private void addActions(Composite parent, InfoPopAction[] actions, int actionType) {
        int i = 0;
        while (i < actions.length) {
            if (actions[i].getType() == actionType) {
                if (actions[i].getDescription() != null) {
                    Label desc = new Label(parent, 4);
                    desc.setBackground(this.backgroundColour);
                    desc.setForeground(this.foregroundColour);
                    desc.setText(actions[i].getDescription());
                    GridData gData = new GridData(802);
                    gData.horizontalSpan = 3;
                    desc.setLayoutData((Object)gData);
                }
                Label spacerLabel = new Label(parent, 0);
                spacerLabel.setText(FIVE_SPACES);
                Label imageLabel = new Label(parent, 0);
                imageLabel.setBackground(this.backgroundColour);
                imageLabel.setForeground(this.foregroundColour);
                if (actions[i].getImage() != null) {
                    imageLabel.setImage(actions[i].getImage());
                }
                Hyperlink actionLink = this.toolkit.createHyperlink(parent, actions[i].getAction().getText(), 64);
                this.toolkit.adapt((Control)actionLink, true, true);
                actionLink.setBackground(this.backgroundColour);
                final IAction nextAction = actions[i].getAction();
                actionLink.setToolTipText(actions[i].getDescription());
                actionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        nextAction.run();
                        AdvisorFixDialog.this.close();
                    }
                });
            }
            ++i;
        }
    }

    public synchronized void open() {
        try {
            this.shell.open();
        }
        catch (Throwable e) {
            AdvisorUiConstants.UTIL.log(4, e, "An error occurred when opening context-sensitive help pop-up.");
        }
    }

    public boolean isShowing() {
        return this.shell != null && !this.shell.isDisposed() && this.shell.isVisible();
    }

    private void initAccessible(final Control control) {
        Accessible accessible = control.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = AdvisorFixDialog.this.infopopText;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = control.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = control.toControl(new Point(e.x, e.y));
                e.childID = control.getBounds().contains(pt) ? -3 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = control.getBounds();
                Point pt = control.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 1;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    public class Description
    extends StyledText {
        public Description(Composite parent, int style) {
            super(parent, style);
        }

        public boolean setFocus() {
            return false;
        }

        public boolean isFocusControl() {
            return false;
        }
    }
}

