/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.core;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;

public class StyledLineWrapper
implements StyledTextContent {
    public static final String BOLD_CLOSE_TAG = "</@#$b>";
    public static final String BOLD_TAG = "<@#$b>";
    private Drawable drawable;
    private ArrayList lines = new ArrayList();
    private ArrayList lineStyleRanges = new ArrayList();
    private int charCount = -1;
    private static BreakIterator lineBreaker = BreakIterator.getLineInstance();
    public static final int DEFAULT_WIDTH = 350;
    public int maxWidth;

    public StyledLineWrapper(String text, Drawable drawable, int minWidth) {
        this.drawable = drawable;
        this.maxWidth = Math.max(350, minWidth);
        if (text == null || text.length() == 0) {
            text = " ";
        }
        this.setText(text);
    }

    public void addTextChangeListener(TextChangeListener l) {
    }

    public int getCharCount() {
        if (this.charCount != -1) {
            return this.charCount;
        }
        this.charCount = 0;
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            this.charCount += ((String)i.next()).length();
        }
        return this.charCount;
    }

    public String getLine(int i) {
        if (i >= this.lines.size() || i < 0) {
            SWT.error((int)5);
        }
        return (String)this.lines.get(i);
    }

    public int getLineAtOffset(int offset) {
        if (offset >= this.getCharCount()) {
            return this.getLineCount() - 1;
        }
        int count = 0;
        int line = -1;
        while (count <= offset) {
            count += this.getLine(++line).length();
        }
        return line;
    }

    public int getLineCount() {
        if (this.lines.size() == 0) {
            return 1;
        }
        return this.lines.size();
    }

    public String getLineDelimiter() {
        return null;
    }

    public int getOffsetAtLine(int line) {
        if (this.lines.size() == 0) {
            return 0;
        }
        int offset = 0;
        int i = 0;
        while (i < line) {
            offset += this.getLine(i).length();
            ++i;
        }
        return offset;
    }

    public String getTextRange(int start, int end) {
        int l2;
        int l1 = this.getLineAtOffset(start);
        if (l1 == (l2 = this.getLineAtOffset(end))) {
            return this.getLine(l1).substring(start - this.getOffsetAtLine(l1), end - start);
        }
        StringBuffer range = new StringBuffer(this.getLine(l1).substring(start - this.getOffsetAtLine(l1)));
        int i = l1 + 1;
        while (i < l2) {
            range.append(this.getLine(i));
            ++i;
        }
        range.append(this.getLine(l2).substring(0, end - this.getOffsetAtLine(l2)));
        return range.toString();
    }

    public void removeTextChangeListener(TextChangeListener arg0) {
    }

    public void replaceTextRange(int arg0, int arg1, String arg2) {
    }

    public void setText(String text) {
        if (text == null) {
            text = " ";
        }
        this.processLineBreaks(text);
        this.processStyles(text);
    }

    public StyleRange[] getStyles() {
        StyleRange[] array = new StyleRange[this.lineStyleRanges.size()];
        this.lineStyleRanges.toArray(array);
        return array;
    }

    private void processLineBreaks(String text) {
        int start;
        this.lines = new ArrayList();
        char[] textChars = StyledLineWrapper.getUnstyledText(text).toCharArray();
        int i = start = 0;
        while (i < textChars.length) {
            char ch = textChars[i];
            if (ch == '\r') {
                this.lines.add(new String(textChars, start, i - start));
                start = i + 1;
                if (start >= textChars.length) break;
                ch = textChars[start];
                if (ch == '\n') {
                    ++i;
                    if (++start >= textChars.length) {
                        break;
                    }
                }
            } else if (ch == '\n') {
                this.lines.add(new String(textChars, start, i - start));
                start = i + 1;
                if (start >= textChars.length) {
                    break;
                }
            } else if (i == textChars.length - 1) {
                this.lines.add(new String(textChars, start, i - start + 1));
            }
            ++i;
        }
        GC gc = new GC(this.drawable);
        int i2 = 0;
        while (i2 < this.lines.size()) {
            String line = (String)this.lines.get(i2);
            while (line.length() > 0) {
                int linebreak = this.getLineBreak(line, gc);
                if (linebreak == 0 || linebreak == line.length()) break;
                String newline = line.substring(0, linebreak);
                this.lines.remove(i2);
                this.lines.add(i2, newline);
                line = line.substring(linebreak);
                this.lines.add(++i2, line);
            }
            ++i2;
        }
        gc.dispose();
    }

    private static String getUnstyledText(String styledText) {
        return styledText.replaceAll("</?@#\\$b>", "");
    }

    private int getLineBreak(String line, GC gc) {
        lineBreaker.setText(line);
        int lastGoodIndex = 0;
        int currentIndex = lineBreaker.first();
        int width = gc.textExtent((String)line.substring((int)0, (int)currentIndex)).x;
        while (width < this.maxWidth && currentIndex != -1) {
            lastGoodIndex = currentIndex;
            currentIndex = lineBreaker.next();
            if (currentIndex == -1) break;
            width = gc.textExtent((String)line.substring((int)0, (int)currentIndex)).x;
        }
        return lastGoodIndex;
    }

    private void processStyles(String text) {
        int end;
        this.lineStyleRanges = new ArrayList();
        text = text.replaceAll("\n|\r", "");
        int offset = 0;
        do {
            StyleRange style = new StyleRange();
            style.fontStyle = 1;
            int start = text.indexOf(BOLD_TAG, offset);
            if (start == -1) break;
            String prefix = StyledLineWrapper.getUnstyledText(text.substring(0, start));
            style.start = prefix.length();
            offset = start + 1;
            end = text.indexOf(BOLD_CLOSE_TAG, offset);
            if (end == -1) break;
            prefix = StyledLineWrapper.getUnstyledText(text.substring(0, end));
            style.length = prefix.length() - style.start;
            this.lineStyleRanges.add(style);
        } while ((offset = end + 1) < text.length());
    }
}

