/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.core.status;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.core.status.DefaultStatusProvider;
import org.teiid.designer.advisor.ui.core.status.IStatusContentProvider;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class AdvisorStatusExtensionManager {
    private static Collection statusProviders;
    private static boolean providersLoaded;
    private static IStatusContentProvider defaultStatusProvider;
    private static IStatusContentProvider currentStatusProvider;
    private static Object currentFocusedObject;

    static {
        providersLoaded = false;
        currentStatusProvider = defaultStatusProvider = new DefaultStatusProvider();
    }

    public static Object getCurrentFocusedObject() {
        return currentFocusedObject;
    }

    public static Collection getProviders() {
        if (!providersLoaded) {
            AdvisorStatusExtensionManager.loadExtensions();
        }
        return statusProviders;
    }

    private static void loadExtensions() {
        HashMap<String, Object> statusProvidersMap = new HashMap<String, Object>();
        providersLoaded = true;
        String id = "advisorStatusProvider";
        String className = "name";
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.advisor.ui", id);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object helper = elements[j].createExecutableExtension(className);
                    statusProvidersMap.put(elements[j].getAttribute(className), helper);
                    ++j;
                }
            }
            catch (Exception e) {
                String message = "Problem Loading Designer Advisor Extension Point Data";
                AdvisorUiConstants.UTIL.log(4, (Throwable)e, message);
            }
            ++i;
        }
        statusProviders = statusProvidersMap.values();
    }

    public static IStatusContentProvider getProvider(Object target) {
        if (!providersLoaded) {
            AdvisorStatusExtensionManager.loadExtensions();
        }
        if (target != null) {
            String id = null;
            if (target instanceof IProject) {
                id = AdvisorStatusExtensionManager.getPrimaryProjectScopeNature((IProject)target);
            } else if (target instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)target))) {
                id = "Model";
            }
            Iterator iter = statusProviders.iterator();
            IStatusContentProvider nextProvider = null;
            while (iter.hasNext()) {
                nextProvider = (IStatusContentProvider)iter.next();
                if (!nextProvider.getId().equalsIgnoreCase(id)) continue;
                currentFocusedObject = target;
                currentStatusProvider = nextProvider;
                return nextProvider;
            }
        }
        currentStatusProvider = defaultStatusProvider;
        return defaultStatusProvider;
    }

    public static IStatusContentProvider getCurrentProvider() {
        return currentStatusProvider;
    }

    private static String getPrimaryProjectScopeNature(IProject proj) {
        block8: {
            block7: {
                block6: {
                    if (!proj.hasNature("org.teiid.designer.advisor.ui.vdbNature")) break block6;
                    return "org.teiid.designer.advisor.ui.vdbNature";
                }
                if (!proj.hasNature("org.teiid.designer.advisor.ui.webServicesModelingNature")) break block7;
                return "org.teiid.designer.advisor.ui.webServicesModelingNature";
            }
            if (!proj.hasNature("org.teiid.designer.advisor.ui.xmlModelingNature")) break block8;
            return "org.teiid.designer.advisor.ui.xmlModelingNature";
        }
        try {
            if (proj.hasNature("org.teiid.designer.advisor.ui.relationalModelingNature")) {
                return "org.teiid.designer.advisor.ui.relationalModelingNature";
            }
        }
        catch (CoreException e) {
            AdvisorUiConstants.UTIL.log((Throwable)e);
        }
        return "NoNature";
    }
}

