/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.core.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.core.status.AdvisorStatus;
import org.teiid.designer.advisor.ui.core.status.AdvisorStatusUpdateJob;
import org.teiid.designer.advisor.ui.core.status.IAdvisorStatusListener;
import org.teiid.designer.advisor.ui.core.status.IStatusManager;
import org.teiid.designer.advisor.ui.views.status.StatusListener;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.viewsupport.JobUtils;
import org.teiid.designer.ui.event.ModelResourceEvent;

public class AdvisorStatusManager
implements IChangeListener,
IStatusManager {
    private Object currentObject;
    private static final String ID = "DefaultStatusManager";
    private static final String ADVISOR_JOB_NAME = "Workspace Advisor Validation";
    private static final String AUTOBUILD_JOB_NAME = "Building workspace";
    public static final Object FAMILY_ADVISOR_STATUS = new Object();
    private static Collection statusListeners;
    private EventObjectListener modelResourceListener;
    private IResourceChangeListener resourceListener;
    private AdvisorStatus currentStatus;
    private AdvisorStatusUpdateJob statusRefreshJob;
    private AutoBuildJobListener autoBuildJobListener;
    boolean isListeningForBuildComplete = false;

    public AdvisorStatusManager() {
        this.setup();
        statusListeners = new ArrayList();
        this.autoBuildJobListener = new AutoBuildJobListener();
        this.statusRefreshJob = this.getNewStatusUpdateJob();
        this.registerAsListener();
        this.updateStatus(false);
    }

    public void addListener(IAdvisorStatusListener listener) {
        if (statusListeners == null) {
            statusListeners = new ArrayList();
        }
        statusListeners.add(listener);
        this.updateStatus(false);
    }

    public void dispose() {
        ModelerCore.getWorkspace().removeResourceChangeListener(this.resourceListener);
        try {
            UiPlugin.getDefault().getEventBroker().removeListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            AdvisorUiConstants.UTIL.log(4, (Throwable)e, e.getMessage());
        }
    }

    protected void generateNewStatus() {
        System.out.println("AdvisorStatusManager.generateNewStatus() (NO OP METHOD)");
    }

    public AdvisorStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public void setCurrentStatus(AdvisorStatus status) {
        this.currentStatus = status;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public String getId() {
        return ID;
    }

    protected Object getJobFamily() {
        return FAMILY_ADVISOR_STATUS;
    }

    protected String getJobName() {
        return ADVISOR_JOB_NAME;
    }

    public AdvisorStatus getStatusSnapshot() {
        return null;
    }

    public AdvisorStatusUpdateJob getNewStatusUpdateJob() {
        return new AdvisorStatusUpdateJob(this.getJobName(), this);
    }

    protected void setup() {
    }

    protected void notifyStatusChanged(AdvisorStatus status) {
        this.currentStatus = status;
        if (this.shouldNotify()) {
            Iterator iter = statusListeners.iterator();
            while (iter.hasNext()) {
                ((IAdvisorStatusListener)iter.next()).notifyStatusChanged(status);
            }
        }
    }

    private void registerAsListener() {
        this.modelResourceListener = new EventObjectListener(){

            public void processEvent(EventObject obj) {
                ModelResourceEvent event = (ModelResourceEvent)obj;
                if (event.getType() == 7 || event.getType() == 4 || event.getType() == 6 || event.getType() == 8) {
                    AdvisorStatusManager.this.updateStatus(false);
                }
            }
        };
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            AdvisorUiConstants.UTIL.log(4, (Throwable)e, e.getMessage());
        }
        this.resourceListener = new MarkerDeltaListener();
        ModelerCore.getWorkspace().addResourceChangeListener(this.resourceListener);
    }

    public void removeListener(StatusListener listener) {
        if (statusListeners == null) {
            statusListeners = new ArrayList();
        }
        statusListeners.remove(listener);
        if (!statusListeners.isEmpty()) {
            this.updateStatus(false);
        }
    }

    public boolean setCurrentObject(Object focusedObject) {
        if (this.currentObject != focusedObject) {
            this.currentObject = focusedObject;
            return true;
        }
        return false;
    }

    private boolean shouldAddJob() {
        boolean result = false;
        Job[] wsJobs = Job.getJobManager().find(this.getJobFamily());
        int nJobs = wsJobs.length;
        if (JobUtils.jobIsRunning((Object)this.getJobFamily())) {
            if (nJobs == 1) {
                result = true;
            }
        } else if (nJobs == 0) {
            result = true;
        }
        return result;
    }

    private boolean shouldNotify() {
        boolean result = true;
        return result;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateStatus(false);
    }

    public void updateStatus(boolean forceUpdate) {
        if (!this.shouldNotify()) {
            return;
        }
        if (JobUtils.validationJobsExist()) {
            if (!this.isListeningForBuildComplete) {
                if (ModelerCore.getWorkspace().isAutoBuilding()) {
                    Job.getJobManager().addJobChangeListener((IJobChangeListener)this.autoBuildJobListener);
                    this.isListeningForBuildComplete = true;
                } else {
                    this.isListeningForBuildComplete = false;
                }
            }
            return;
        }
        boolean forceJob = false;
        if (forceJob || this.shouldAddJob() || forceUpdate) {
            if (Display.getDefault() == null) {
                this.generateNewStatus();
                if (this.getCurrentStatus() != null) {
                    this.notifyStatusChanged(this.getCurrentStatus());
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AdvisorStatusManager.this.statusRefreshJob.schedule(400L);
                    }
                });
            }
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void startup() {
    }

    protected class AutoBuildJobListener
    extends JobChangeAdapter {
        protected AutoBuildJobListener() {
        }

        public void done(IJobChangeEvent theEvent) {
            if (!JobUtils.validationJobsExist() && theEvent.getJob().getName().equals(AdvisorStatusManager.AUTOBUILD_JOB_NAME)) {
                AdvisorStatusManager.this.updateStatus(false);
                AdvisorStatusManager.this.isListeningForBuildComplete = false;
            }
        }
    }

    protected final class MarkerDeltaListener
    implements IResourceChangeListener {
        protected MarkerDeltaListener() {
        }

        private void examineDelta(IMarkerDelta[] deltas, List changes) {
            int idx = 0;
            while (idx < deltas.length) {
                IMarkerDelta delta = deltas[idx];
                int kind = delta.getKind();
                if (kind == 4) {
                    changes.add(deltas[idx].getMarker());
                }
                ++idx;
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            boolean refreshNeeded = false;
            IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
            ArrayList changes = new ArrayList(markerDeltas.length);
            this.examineDelta(markerDeltas, changes);
            if (markerDeltas.length != changes.size()) {
                refreshNeeded = true;
            }
            if (refreshNeeded) {
                AdvisorStatusManager.this.updateStatus(false);
            }
        }
    }
}

