/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.dialogs;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.Messages;
import org.teiid.designer.advisor.ui.actions.AdvisorActionFactory;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.viewsupport.DesignerProperties;
import org.teiid.designer.vdb.ui.VdbUiConstants;

public class DefineSourceDialog
extends TitleAreaDialog
implements IChangeListener,
AdvisorUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DefineSourceDialog.class);
    private Button importFlatFileButton;
    private Button importXmlFileButton;
    private Button importXmlFileUrlButton;
    private Button importJdbcButton;
    private Button importSalesforceButton;
    private Button importWsdlButton;
    private Button launchImporterButton;
    DesignerProperties designerProperties;

    static String getString(String key) {
        return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + key, new Object[0]);
    }

    public DefineSourceDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DefineSourceDialog(Shell parentShell, Properties properties) {
        this(parentShell);
        this.designerProperties = (DesignerProperties)properties;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Create Data Source Model");
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected void okPressed() {
        this.launchSelectedImporter(false);
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.DefineDataSourceModels);
        this.setMessage(Messages.DefineDataSourceModelsMessage);
        this.launchImporterButton = new Button(panel, 0);
        this.launchImporterButton.setText(Messages.ClickToLaunchSelectedImporter);
        this.launchImporterButton.setToolTipText("Create relational source model from your JDBC source metadata");
        this.launchImporterButton.setLayoutData((Object)new GridData());
        this.launchImporterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DefineSourceDialog.this.launchSelectedImporter(true);
            }
        });
        Group theGroup = WidgetFactory.createGroup((Composite)panel, (String)Messages.ImportSourceOptions, (int)0, (int)1, (int)1);
        theGroup.setLayoutData((Object)new GridData(768));
        this.importJdbcButton = WidgetFactory.createRadioButton((Composite)theGroup, (String)AdvisorUiConstants.COMMAND_LABELS.IMPORT_JDBC, (int)0, (int)1, (boolean)true);
        this.importJdbcButton.setToolTipText("Create relational source model from your JDBC source metadata");
        this.importFlatFileButton = WidgetFactory.createRadioButton((Composite)theGroup, (String)AdvisorUiConstants.COMMAND_LABELS.IMPORT_FLAT_FILE, (int)0, (int)1, (boolean)false);
        this.importFlatFileButton.setToolTipText("Create view table to query a flat file source");
        this.importXmlFileButton = WidgetFactory.createRadioButton((Composite)theGroup, (String)AdvisorUiConstants.COMMAND_LABELS.IMPORT_XML_FILE, (int)0, (int)1, (boolean)false);
        this.importXmlFileButton.setToolTipText("Create view table to query your local or remote URL XML file source");
        this.importXmlFileUrlButton = WidgetFactory.createRadioButton((Composite)theGroup, (String)AdvisorUiConstants.COMMAND_LABELS.IMPORT_XML_FILE_URL, (int)0, (int)1, (boolean)false);
        this.importXmlFileUrlButton.setToolTipText("Create view table to query your remote URL XML file source");
        this.importWsdlButton = WidgetFactory.createRadioButton((Composite)theGroup, (String)AdvisorUiConstants.COMMAND_LABELS.IMPORT_WSDL_TO_SOURCE, (int)4, (int)1, (boolean)false);
        this.importWsdlButton.setToolTipText("Create view tables to query your Web Services defined by WSDL source");
        this.importSalesforceButton = WidgetFactory.createRadioButton((Composite)theGroup, (String)AdvisorUiConstants.COMMAND_LABELS.IMPORT_SALESFORCE, (int)0, (int)1, (boolean)false);
        this.importSalesforceButton.setToolTipText("Create relational source model defined by your Salesforce metadata");
        return panel;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.designerProperties != null) {
            this.updateState();
        }
        return control;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void updateState() {
        IStatus status = Status.OK_STATUS;
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(Messages.ClickOkToFinish);
        }
    }

    private void launchSelectedImporter(boolean sync) {
        if (this.importJdbcButton.getSelection()) {
            AdvisorActionFactory.executeAction("org.teiid.designer.importJdbcCommand", (Properties)this.designerProperties, sync);
        } else if (this.importFlatFileButton.getSelection()) {
            AdvisorActionFactory.executeAction("org.teiid.designer.importFlatFileCommand", (Properties)this.designerProperties, sync);
        } else if (this.importXmlFileButton.getSelection()) {
            AdvisorActionFactory.executeAction("org.teiid.designer.importXmlFileCommand", (Properties)this.designerProperties, sync);
        } else if (this.importXmlFileUrlButton.getSelection()) {
            AdvisorActionFactory.executeAction("org.teiid.designer.importXmlFileUrlCommand", (Properties)this.designerProperties, sync);
        } else if (this.importWsdlButton.getSelection()) {
            AdvisorActionFactory.executeAction("org.teiid.designer.importWsdlToSourceCommand", (Properties)this.designerProperties, sync);
        } else if (this.importSalesforceButton.getSelection()) {
            AdvisorActionFactory.executeAction("org.teiid.designer.importSalesforceCommand", (Properties)this.designerProperties, sync);
        }
    }
}

