/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.scope;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.advisor.ui.scope.RelationalModelingNature;
import org.teiid.designer.advisor.ui.scope.WebServicesModelingNature;
import org.teiid.designer.advisor.ui.scope.XmlModelingNature;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;

public class SelectModelingScopeDialog
extends Dialog {
    IProject selectedProject;
    private Button radioGeneralModeling;
    private Button radioRelationalModeling;
    private Button radioXMLModeling;
    private Button radioWebServiceModeling;
    private Button vdbProjectCheckBox;

    public SelectModelingScopeDialog(Shell parent, IProject project) {
        super(parent, "Select Modeling Scope");
        this.selectedProject = project;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainPanel = (Composite)super.createDialogArea(parent);
        this.init(mainPanel);
        return mainPanel;
    }

    private void init(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        parent.setLayoutData((Object)gridData);
        WidgetFactory.createLabel((Composite)parent, (int)32, (int)1, (String)("Select modeling scope for the project: " + this.selectedProject.getName() + "     "));
        Group grpScaling = WidgetFactory.createGroup((Composite)parent, (String)"Modeling Scope", (int)768);
        this.radioGeneralModeling = WidgetFactory.createRadioButton((Composite)grpScaling, (String)"General");
        this.radioRelationalModeling = WidgetFactory.createRadioButton((Composite)grpScaling, (String)"Relational");
        this.radioXMLModeling = WidgetFactory.createRadioButton((Composite)grpScaling, (String)"XML + Relational");
        this.radioWebServiceModeling = WidgetFactory.createRadioButton((Composite)grpScaling, (String)"Web Services + XML + Relational");
        this.vdbProjectCheckBox = WidgetFactory.createCheckBox((Composite)parent, (String)"VDB Project");
        try {
            this.setIntialScope();
        }
        catch (CoreException e) {
            UiConstants.Util.log((Throwable)e);
        }
    }

    private void setIntialScope() throws CoreException {
        if (this.selectedProject.hasNature("org.teiid.designer.advisor.ui.webServicesModelingNature")) {
            this.radioWebServiceModeling.setSelection(true);
        } else if (this.selectedProject.hasNature("org.teiid.designer.advisor.ui.xmlModelingNature")) {
            this.radioXMLModeling.setSelection(true);
        } else if (this.selectedProject.hasNature("org.teiid.designer.advisor.ui.relationalModelingNature")) {
            this.radioRelationalModeling.setSelection(true);
        } else {
            this.radioGeneralModeling.setSelection(true);
        }
        this.vdbProjectCheckBox.setSelection(this.selectedProject.hasNature("org.teiid.designer.advisor.ui.vdbNature"));
    }

    public void create() {
        super.create();
        this.setOkEnabled(true);
    }

    protected void okPressed() {
        String[] natures = ModelerCore.NATURES;
        if (this.radioRelationalModeling.getSelection()) {
            natures = RelationalModelingNature.NATURES;
        } else if (this.radioXMLModeling.getSelection()) {
            natures = XmlModelingNature.NATURES;
        } else if (this.radioWebServiceModeling.getSelection()) {
            natures = WebServicesModelingNature.NATURES;
        }
        if (this.vdbProjectCheckBox.getSelection()) {
            natures = this.addVdbNature(natures);
        }
        try {
            IProjectDescription desc = this.selectedProject.getDescription();
            desc.setNatureIds(natures);
            this.selectedProject.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            UiConstants.Util.log((Throwable)e);
        }
        super.okPressed();
    }

    private String[] addVdbNature(String[] natures) {
        String[] newStrings = new String[natures.length + 1];
        newStrings[0] = "org.teiid.designer.advisor.ui.vdbNature";
        int i = 1;
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            newStrings[i++] = nature;
            ++n2;
        }
        return newStrings;
    }

    public void setOkEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }
}

