/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.suppliers.relational;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.core.status.AdvisorStatusManager;
import org.teiid.designer.advisor.ui.core.status.IStatusContentProvider;
import org.teiid.designer.advisor.ui.core.status.IStatusRowProvider;
import org.teiid.designer.advisor.ui.suppliers.ModelValidationStatusRowProvider;
import org.teiid.designer.advisor.ui.suppliers.relational.RelationalModelingStatusManager;
import org.teiid.designer.advisor.ui.suppliers.relational.SourceModelStatusRowProvider;
import org.teiid.designer.advisor.ui.suppliers.relational.ViewModelStatusRowProvider;
import org.teiid.designer.advisor.ui.views.status.StatusValidationConstants;

public class RelationalModelingStatusProvider
implements IStatusContentProvider {
    private AdvisorStatusManager statusManager = new RelationalModelingStatusManager();
    private IStatusRowProvider[] providers;

    @Override
    public IStatus getDefaultStatus() {
        return StatusValidationConstants.STATUS_MSGS.ADVISOR_NO_PROJECT_SELECTED;
    }

    @Override
    public String getDescription() {
        return "Relational Source and View Modeling Description";
    }

    @Override
    public String getId() {
        return this.statusManager.getId();
    }

    @Override
    public Image getImage(int id) {
        return AdvisorUiPlugin.getImageHelper().NEW_MODEL_IMAGE;
    }

    @Override
    public String getLinkTooltip(int id) {
        return "Relational Modeling Tooltip";
    }

    @Override
    public IStatusRowProvider[] getRowsProviders() {
        if (this.providers == null) {
            this.initRowProviders();
        }
        return this.providers;
    }

    @Override
    public IStatus getStatus(int id) {
        return this.statusManager.getCurrentStatus().get(id);
    }

    @Override
    public Image getStatusImage(int id) {
        return AdvisorUiPlugin.getImageHelper().CHECKED_BOX_IMAGE;
    }

    @Override
    public String getText(int id) {
        return "Relational Modeling Text";
    }

    @Override
    public String getTitle() {
        if (this.statusManager == null || this.statusManager.getCurrentObject() == null) {
            return "Relational Modeling Title";
        }
        return ((IProject)this.statusManager.getCurrentObject()).getName();
    }

    private void initRowProviders() {
        this.providers = new IStatusRowProvider[3];
        this.providers[0] = new ModelValidationStatusRowProvider();
        this.providers[1] = new SourceModelStatusRowProvider();
        this.providers[2] = new ViewModelStatusRowProvider();
    }

    @Override
    public void updateStatus(boolean forceUpdate) {
        this.statusManager.updateStatus(forceUpdate);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void startup() {
    }
}

