/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;

public class HyperLinkLabelRow {
    private Label label;
    private ImageHyperlink link;
    private Color dimFGColor;
    private Color defFGColor;

    public HyperLinkLabelRow(int id, FormToolkit toolkit, Composite body, String mainLabel, IHyperlinkListener listener) {
        this.link = toolkit.createImageHyperlink(body, 64);
        this.link.setImage(AdvisorUiPlugin.getImageHelper().UNCHECKED_BOX_IMAGE);
        this.link.addHyperlinkListener(listener);
        this.link.setData((Object)id);
        GridData gd = new GridData(4);
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 2;
        this.link.setLayoutData((Object)gd);
        this.label = toolkit.createLabel(body, mainLabel, 0);
        gd = new GridData(4);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 2;
        this.label.setLayoutData((Object)gd);
        this.dimFGColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER");
        this.defFGColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_FG");
    }

    public void setImage(Image image) {
        if (!this.link.getImage().isDisposed()) {
            this.link.setImage(image);
        }
    }

    public void setText(String label) {
        if (!this.label.isDisposed()) {
            this.label.setText(label);
        }
    }

    public void setLabelTooltip(String text) {
        if (!this.label.isDisposed()) {
            this.label.setToolTipText(text);
        }
    }

    public void setLinkTooltip(String text) {
        if (!this.link.isDisposed()) {
            this.link.setToolTipText(text);
        }
    }

    public void update(Image linkImage, String labelTT, String linkTT) {
        if (labelTT != null) {
            this.setLabelTooltip(labelTT);
        }
        if (linkImage != null) {
            this.link.setImage(linkImage);
        }
        if (linkTT != null) {
            this.setLinkTooltip(linkTT);
        }
    }

    public void dim() {
        this.label.setForeground(this.dimFGColor);
    }

    public void brighten() {
        this.label.setForeground(this.defFGColor);
    }

    public void redraw() {
        this.link.redraw();
    }
}

