/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.views.guides;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.Messages;
import org.teiid.designer.advisor.ui.util.DSPPluginImageHelper;

public class CheatSheetSection {
    private FormToolkit toolkit;
    private Section section;
    private IConfigurationElement[] cheatsheets;
    private static final String EXT_PT = "cheatSheetContent";
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String CHEATSHEET_ELEMENT = "cheatsheet";
    private static final String CHEAT_SHEET_PLUGIN_ID = "org.eclipse.ui.cheatsheets";
    private final DSPPluginImageHelper imageHelper = AdvisorUiPlugin.getImageHelper();

    public CheatSheetSection(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        int nColumns = 2;
        GridLayout gl2 = new GridLayout(nColumns, false);
        parent.setLayout((Layout)gl2);
        parent.setLayoutData((Object)new GridData(1808));
        this.section = this.toolkit.createSection(parent, 450);
        this.loadCheatSheetExtensions();
        this.initSection();
    }

    private void initSection() {
        this.section.setText(Messages.CheatSheetSection_title);
        this.section.setDescription(Messages.CheatSheetSection_description);
        this.section.getDescriptionControl().setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridData gd = new GridData(1840);
        gd.horizontalSpan = 2;
        this.section.setLayoutData((Object)gd);
        Composite sectionBody = this.toolkit.createComposite((Composite)this.section);
        TableWrapLayout tsbLayout = new TableWrapLayout();
        tsbLayout.numColumns = 2;
        tsbLayout.verticalSpacing = 3;
        tsbLayout.horizontalSpacing = 6;
        sectionBody.setLayout((Layout)tsbLayout);
        TableWrapData twd = new TableWrapData(256, 128);
        twd.valign = 4;
        sectionBody.setLayoutData((Object)twd);
        Image image = this.imageHelper.HELP_IMAGE;
        IConfigurationElement[] cheatSheetExtensions = this.cheatsheets;
        Label lblImage = null;
        Hyperlink link = null;
        int i = 0;
        while (i < cheatSheetExtensions.length) {
            String id = cheatSheetExtensions[i].getAttribute(ID_ATTR);
            if (id.indexOf("teiid") > -1) {
                lblImage = this.toolkit.createLabel(sectionBody, null);
                lblImage.setImage(image);
                link = this.toolkit.createHyperlink(sectionBody, cheatSheetExtensions[i].getAttribute(NAME_ATTR), 64);
                this.toolkit.adapt((Control)link, true, true);
                CheatSheetLinkAction action = new CheatSheetLinkAction(id);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((IAction)action){
                    private final /* synthetic */ IAction val$action;
                    {
                        this.val$action = iAction;
                    }

                    public void linkActivated(HyperlinkEvent theEvent) {
                        this.val$action.run();
                    }
                });
            }
            ++i;
        }
        sectionBody.pack(true);
        this.section.setClient((Control)sectionBody);
        this.section.setExpanded(false);
    }

    public Section getSection() {
        return this.section;
    }

    private void loadCheatSheetExtensions() {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CHEAT_SHEET_PLUGIN_ID, EXT_PT);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length != 0) {
            ArrayList<IConfigurationElement> temp = new ArrayList<IConfigurationElement>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(CHEATSHEET_ELEMENT)) {
                        temp.add(elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
            if (!temp.isEmpty()) {
                this.cheatsheets = new IConfigurationElement[temp.size()];
                temp.toArray(this.cheatsheets);
            } else {
                this.cheatsheets = new IConfigurationElement[0];
            }
        }
        if (this.cheatsheets == null) {
            this.cheatsheets = new IConfigurationElement[0];
        }
    }

    private class CheatSheetLinkAction
    extends Action {
        String linkId;

        public CheatSheetLinkAction(String theCheatSheetId) {
            this.linkId = theCheatSheetId;
        }

        public void run() {
            OpenCheatSheetAction action = new OpenCheatSheetAction(this.linkId);
            action.run();
        }
    }
}

