/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.views.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.views.status.ModelProjectStatus;
import org.teiid.designer.advisor.ui.views.status.StatusListener;
import org.teiid.designer.advisor.ui.views.status.StatusValidationHelper;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.viewsupport.JobUtils;
import org.teiid.designer.ui.event.ModelResourceEvent;

public class AdvisorStatusManager
implements IChangeListener {
    private static StatusValidationHelper helper;
    public static final Object FAMILY_MODEL_PROJECT_STATUS;
    private static final String JOB_NAME = "Data Services Project Advisor Validation";
    private static final String AUTOBUILD_JOB_NAME = "Building workspace";
    private Collection statusListeners;
    private EventObjectListener modelResourceListener;
    private IResourceChangeListener resourceListener;
    private ModelProjectStatus currentStatus;
    StatusUpdateJob statusRefreshJob;
    private AutoBuildJobListener autoBuildJobListener;
    boolean isListeningForBuildComplete = false;
    private IProject currentProject;
    private static boolean enabled;

    static {
        FAMILY_MODEL_PROJECT_STATUS = new Object();
    }

    public AdvisorStatusManager() {
        this.init();
        enabled = true;
    }

    private void init() {
        helper = new StatusValidationHelper();
        this.statusListeners = new ArrayList();
        this.autoBuildJobListener = new AutoBuildJobListener();
        this.statusRefreshJob = new StatusUpdateJob(JOB_NAME);
        this.registerAsListener();
        this.updateStatus(false);
    }

    public void updateStatus(boolean forceUpdate) {
        if (!this.shouldNotify()) {
            return;
        }
        if (JobUtils.validationJobsExist()) {
            if (!this.isListeningForBuildComplete) {
                if (ModelerCore.getWorkspace().isAutoBuilding()) {
                    Platform.getJobManager().addJobChangeListener((IJobChangeListener)this.autoBuildJobListener);
                    this.isListeningForBuildComplete = true;
                } else {
                    this.isListeningForBuildComplete = false;
                }
            }
            return;
        }
        boolean workspaceChanged = false;
        boolean forceJob = false;
        if (forceJob || this.shouldAddJob() || forceUpdate) {
            if (Display.getDefault() == null) {
                ModelProjectStatus status = this.generateNewStatus();
                if (status != null) {
                    status.setWorkspaceChanged(workspaceChanged);
                    this.notifyStatusChanged(status);
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AdvisorStatusManager.this.statusRefreshJob.schedule(400L);
                    }
                });
            }
        }
    }

    private void registerAsListener() {
        this.modelResourceListener = new EventObjectListener(){

            public void processEvent(EventObject obj) {
                ModelResourceEvent event = (ModelResourceEvent)obj;
                event.getResource();
                if (event.getType() == 7 || event.getType() == 4 || event.getType() == 6 || event.getType() == 8) {
                    AdvisorStatusManager.this.updateStatus(false);
                }
            }
        };
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            AdvisorUiConstants.UTIL.log(4, (Throwable)e, e.getMessage());
        }
        this.resourceListener = new MarkerDeltaListener();
        ModelerCore.getWorkspace().addResourceChangeListener(this.resourceListener);
    }

    public void addListener(StatusListener listener) {
        if (this.statusListeners == null) {
            this.statusListeners = new ArrayList();
        }
        this.statusListeners.add(listener);
        this.updateStatus(false);
    }

    public void removeListener(StatusListener listener) {
        if (this.statusListeners == null) {
            this.statusListeners = new ArrayList();
        }
        this.statusListeners.remove(listener);
        if (!this.statusListeners.isEmpty()) {
            this.updateStatus(false);
        }
    }

    void notifyStatusChanged(ModelProjectStatus status) {
        this.currentStatus = status;
        if (this.shouldNotify()) {
            Iterator iter = this.statusListeners.iterator();
            while (iter.hasNext()) {
                ((StatusListener)iter.next()).notifyStatusChanged(status);
            }
        }
    }

    private boolean shouldNotify() {
        boolean result = AdvisorStatusManager.statusEnabled();
        return result;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateStatus(false);
    }

    public void dispose() {
        ModelerCore.getWorkspace().removeResourceChangeListener(this.resourceListener);
        try {
            UiPlugin.getDefault().getEventBroker().removeListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            AdvisorUiConstants.UTIL.log(4, (Throwable)e, e.getMessage());
        }
    }

    public ModelProjectStatus getCurrentStatus() {
        return this.currentStatus;
    }

    ModelProjectStatus generateNewStatus() {
        ModelProjectStatus status = null;
        helper.setCurrentProject(this.getCurrentProject());
        status = helper.getCurrentStatus();
        return status;
    }

    public ModelProjectStatus getStatusSnapshot() {
        ModelProjectStatus status = null;
        status = helper.getCurrentStatus();
        return status;
    }

    private boolean shouldAddJob() {
        boolean result = false;
        Job[] wsJobs = Platform.getJobManager().find(FAMILY_MODEL_PROJECT_STATUS);
        int nJobs = wsJobs.length;
        if (JobUtils.jobIsRunning((Object)FAMILY_MODEL_PROJECT_STATUS)) {
            if (nJobs == 1) {
                result = true;
            }
        } else if (nJobs == 0) {
            result = true;
        }
        return result;
    }

    public IProject getCurrentProject() {
        if (this.currentProject != null && !this.currentProject.exists()) {
            this.currentProject = null;
        }
        return this.currentProject;
    }

    public boolean setCurrentProject(IProject nextCurrentProject) {
        boolean projectChanged = false;
        IProject currentProject = this.getCurrentProject();
        if (currentProject == null && nextCurrentProject != null || currentProject != null && nextCurrentProject == null) {
            projectChanged = true;
        } else if (currentProject == null && nextCurrentProject == null) {
            projectChanged = false;
        } else if (!currentProject.getName().equalsIgnoreCase(nextCurrentProject.getName())) {
            projectChanged = true;
        }
        this.currentProject = nextCurrentProject;
        return projectChanged;
    }

    public static void enable(boolean value) {
        enabled = value;
    }

    public static boolean statusEnabled() {
        return enabled;
    }

    private class AutoBuildJobListener
    extends JobChangeAdapter {
        private AutoBuildJobListener() {
        }

        public void done(IJobChangeEvent theEvent) {
            if (!JobUtils.validationJobsExist() && theEvent.getJob().getName().equals(AdvisorStatusManager.AUTOBUILD_JOB_NAME)) {
                AdvisorStatusManager.this.updateStatus(false);
                AdvisorStatusManager.this.isListeningForBuildComplete = false;
            }
        }
    }

    private final class MarkerDeltaListener
    implements IResourceChangeListener {
        private MarkerDeltaListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            boolean refreshNeeded = false;
            IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
            ArrayList changes = new ArrayList(markerDeltas.length);
            this.examineDelta(markerDeltas, changes);
            if (markerDeltas.length != changes.size()) {
                refreshNeeded = true;
            }
            if (refreshNeeded) {
                AdvisorStatusManager.this.updateStatus(false);
            }
        }

        private void examineDelta(IMarkerDelta[] deltas, List changes) {
            int idx = 0;
            while (idx < deltas.length) {
                IMarkerDelta delta = deltas[idx];
                int kind = delta.getKind();
                if (kind == 4) {
                    changes.add(deltas[idx].getMarker());
                }
                ++idx;
            }
        }
    }

    private final class StatusUpdateJob
    extends Job {
        private boolean contextChanged;

        StatusUpdateJob(String name) {
            super(name);
            this.setUser(false);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ModelProjectStatus status = AdvisorStatusManager.this.generateNewStatus();
            if (status != null) {
                AdvisorStatusManager.this.notifyStatusChanged(status);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_MODEL_PROJECT_STATUS;
        }

        public void setContextChanged(boolean theContextChanged) {
            this.contextChanged = theContextChanged;
        }
    }
}

