/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.views.status;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.actions.AdvisorActionFactory;
import org.teiid.designer.advisor.ui.core.AdvisorHyperLinkListener;
import org.teiid.designer.advisor.ui.core.InfoPopAction;
import org.teiid.designer.advisor.ui.core.status.AdvisorStatus;
import org.teiid.designer.advisor.ui.views.status.ModelProjectStatus;
import org.teiid.designer.advisor.ui.views.status.ProjectStatusSection;
import org.teiid.designer.advisor.ui.views.status.StatusActionHandler;
import org.teiid.designer.advisor.ui.views.status.StatusListener;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.forms.FormUtil;

public class ProjectStatusPanel
extends ManagedForm
implements StatusListener {
    FormToolkit toolkit;
    private ScrolledForm parentForm;
    private ProjectStatusSection statusSection;
    private AdvisorHyperLinkListener linkListener;
    private StatusActionHandler actionHandler = new StatusActionHandler();

    public ProjectStatusPanel(Composite parent) {
        super(parent);
        AdvisorUiPlugin.getStatusManager().addListener(this);
        this.parentForm = this.getForm();
        this.initGUI();
        IProject[] iProjectArray = ModelerCore.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (ModelerCore.hasModelNature((IProject)proj)) {
                this.setCurrentProject(proj);
                break;
            }
            ++n2;
        }
    }

    private void initGUI() {
        this.parentForm.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(1808);
        this.parentForm.setLayoutData((Object)gd);
        this.toolkit = this.getToolkit();
        Color bkgdColor = this.toolkit.getColors().getBackground();
        this.parentForm.setBackground(bkgdColor);
        this.parentForm.setLayout((Layout)new GridLayout());
        this.parentForm.setLayoutData((Object)new GridData(4, 4, true, true));
        FormUtil.tweakColors((FormToolkit)this.toolkit, (Display)this.parentForm.getDisplay());
        this.parentForm.setBackground(bkgdColor);
        Form form = this.parentForm.getForm();
        this.contributeToMenu(form.getMenuManager());
        this.linkListener = new AdvisorHyperLinkListener((Composite)this.getForm(), this.toolkit, this.actionHandler);
        Composite body = this.parentForm.getBody();
        GridLayout gl = new GridLayout(2, false);
        body.setLayout((Layout)gl);
        gd = new GridData(768);
        body.setLayoutData((Object)gd);
        this.statusSection = new ProjectStatusSection(this.toolkit, body, this.linkListener);
    }

    public void dispose() {
        super.dispose();
        AdvisorUiPlugin.getStatusManager().removeListener(this);
    }

    public FormToolkit getToolkit() {
        if (this.toolkit == null) {
            Display display = this.parentForm.getDisplay();
            this.toolkit = AdvisorUiPlugin.getDefault() != null ? AdvisorUiPlugin.getDefault().getFormToolkit(display) : new FormToolkit(display);
        }
        return this.toolkit;
    }

    public InfoPopAction[] getInfoPopActions(int groupType) {
        return this.actionHandler.getActions(groupType);
    }

    @Override
    public void notifyStatusChanged(final ModelProjectStatus theStatus) {
        if (this.statusSection.getSection().isDisposed()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProjectStatusPanel.this.updateStatus((Status)theStatus);
            }
        });
    }

    public void updateStatus(Status theStatus) {
        CoreArgCheck.isInstanceOf(ModelProjectStatus.class, (Object)theStatus);
        this.statusSection.updateStatus(theStatus);
        this.actionHandler.setStatus((ModelProjectStatus)theStatus);
    }

    public void setCurrentProject(IProject nextCurrentProject) {
        if (AdvisorUiPlugin.getStatusManager().setCurrentProject(nextCurrentProject)) {
            this.forceUpdateStatus();
        }
    }

    private void forceUpdateStatus() {
        AdvisorUiPlugin.getStatusManager().updateStatus(true);
    }

    public void updateStatus(AdvisorStatus status) {
    }

    private void contributeToMenu(IMenuManager menuMgr) {
        AdvisorActionFactory.addActionsLibraryToMenu(menuMgr);
        menuMgr.update(true);
    }
}

