/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.views.status;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.Messages;
import org.teiid.designer.advisor.ui.core.AdvisorHyperLinkListener;
import org.teiid.designer.advisor.ui.util.DSPPluginImageHelper;
import org.teiid.designer.advisor.ui.util.HyperLinkLabelRow;
import org.teiid.designer.advisor.ui.views.status.AdvisorStatusManager;
import org.teiid.designer.advisor.ui.views.status.ModelProjectStatus;
import org.teiid.designer.advisor.ui.views.status.ModelProjectViewFilter;
import org.teiid.designer.advisor.ui.views.status.StatusValidationConstants;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class ProjectStatusSection
implements AdvisorUiConstants.Groups {
    private FormToolkit toolkit;
    private Section section;
    private Composite sectionBody;
    private Button enableStatusButton;
    private Button changeProjectButton;
    private Label projectLabel;
    private Label projectNameLabel;
    private final DSPPluginImageHelper imageHelper = AdvisorUiPlugin.getImageHelper();
    private final AdvisorHyperLinkListener linkListener;
    private HyperLinkLabelRow sourcesRow;
    private HyperLinkLabelRow viewsRow;
    private HyperLinkLabelRow connectorsRow;
    private HyperLinkLabelRow validationRow;
    private HyperLinkLabelRow schemasRow;
    private HyperLinkLabelRow vdbsRow;
    private HyperLinkLabelRow testRow;
    private static final int MAX_NAME_CHARS = 20;
    private static final int SEPARATOR_HEIGHT = 3;
    private static final String CRETURN = "\n";
    private static final String TEN_SPACES = "          ";
    private static final String TWENTY_FIVE_SPACES = "                         ";
    private static final String ELIPSIS = "...";

    public ProjectStatusSection(FormToolkit toolkit, Composite parent, AdvisorHyperLinkListener linkListener) {
        this.toolkit = toolkit;
        this.linkListener = linkListener;
        this.createSection(parent);
    }

    private void createSection(Composite parent) {
        int nColumns = 2;
        this.section = this.toolkit.createSection(parent, 288);
        this.section.setExpanded(false);
        this.section.setText(Messages.Status);
        this.section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.section.setLayoutData((Object)gd);
        this.sectionBody = this.toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout(2, false);
        layout.numColumns = nColumns;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 3;
        this.sectionBody.setLayout((Layout)layout);
        GridData bodyGD = new GridData(1808);
        bodyGD.verticalAlignment = 2;
        this.sectionBody.setLayoutData((Object)bodyGD);
        this.addSectionToolbar();
        this.projectLabel = new Label(this.sectionBody, 0);
        this.projectLabel.setText(Messages.StatusSectionProjectPrefix);
        this.projectLabel.setForeground(Display.getCurrent().getSystemColor(10));
        this.projectNameLabel = new Label(this.sectionBody, 0);
        this.projectNameLabel.setText(String.valueOf(Messages.NoProjectMessage) + "                                     ");
        this.projectNameLabel.setForeground(Display.getCurrent().getSystemColor(10));
        this.createSeparator(this.sectionBody, nColumns, 3);
        this.connectorsRow = new HyperLinkLabelRow(2, this.toolkit, this.sectionBody, String.valueOf(Messages.ConnectionFactoriesLabel) + TWENTY_FIVE_SPACES, (IHyperlinkListener)this.linkListener);
        this.sourcesRow = new HyperLinkLabelRow(1, this.toolkit, this.sectionBody, Messages.SourcesLabel, (IHyperlinkListener)this.linkListener);
        this.schemasRow = new HyperLinkLabelRow(5, this.toolkit, this.sectionBody, Messages.XmlSchemaLabel, (IHyperlinkListener)this.linkListener);
        this.viewsRow = new HyperLinkLabelRow(3, this.toolkit, this.sectionBody, Messages.ViewsLabel, (IHyperlinkListener)this.linkListener);
        this.vdbsRow = new HyperLinkLabelRow(8, this.toolkit, this.sectionBody, Messages.VDBsLabel, (IHyperlinkListener)this.linkListener);
        this.createSeparator(this.sectionBody, nColumns, 3);
        this.validationRow = new HyperLinkLabelRow(0, this.toolkit, this.sectionBody, Messages.ModelValidationLabel, (IHyperlinkListener)this.linkListener);
        this.testRow = new HyperLinkLabelRow(10, this.toolkit, this.sectionBody, Messages.TestLabel, (IHyperlinkListener)this.linkListener);
        this.createSeparator(this.sectionBody, nColumns, 3);
        this.updateStatus((Status)StatusValidationConstants.STATUS_MSGS.NO_PROJECT_SELECTED);
        this.sectionBody.pack(true);
        this.section.setClient((Control)this.sectionBody);
        this.section.setExpanded(true);
        this.setEnabledState();
    }

    private void createSeparator(Composite parent, int nColumns, int height) {
        Composite bottomSep = this.toolkit.createCompositeSeparator(parent);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = nColumns;
        layoutData.heightHint = height;
        bottomSep.setLayoutData((Object)layoutData);
    }

    private void addSectionToolbar() {
        Button[] buttons = FormUtil.createSectionToolBar((Section)this.section, (FormToolkit)this.toolkit, (Object[])new String[]{Messages.Enable, Messages.StatusSectionChangeProject}, (int[])new int[]{32, 0x800000});
        this.enableStatusButton = buttons[0];
        this.enableStatusButton.setSelection(AdvisorStatusManager.statusEnabled());
        this.enableStatusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvisorStatusManager.enable(ProjectStatusSection.this.enableStatusButton.getSelection());
                ProjectStatusSection.this.setEnabledState();
                AdvisorUiPlugin.getStatusManager().setCurrentProject(null);
                ProjectStatusSection.this.projectNameLabel.setText(Messages.StatusSectionTitle_NoProjectSelected);
                if (AdvisorStatusManager.statusEnabled()) {
                    AdvisorUiPlugin.getStatusManager().updateStatus(true);
                }
            }
        });
        this.enableStatusButton.setToolTipText(Messages.StatusSectionEnableStatusTooltip);
        this.changeProjectButton = buttons[1];
        this.changeProjectButton.setEnabled(true);
        this.changeProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] projects = WidgetUtil.showWorkspaceObjectSelectionDialog((String)Messages.StatusSectionChangeProjectTooltip, (String)Messages.StatusSectionSelectProjectMessage, (boolean)false, null, (ViewerFilter)new ModelingResourceFilter((ViewerFilter)new ModelProjectViewFilter()), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
                if (projects.length > 0 && AdvisorUiPlugin.getStatusManager().setCurrentProject((IProject)projects[0])) {
                    AdvisorUiPlugin.getStatusManager().updateStatus(true);
                }
            }
        });
        this.changeProjectButton.setToolTipText(Messages.StatusSectionChangeProjectTooltip);
    }

    public void updateStatus(Status theStatus) {
        CoreArgCheck.isInstanceOf(ModelProjectStatus.class, (Object)theStatus);
        ModelProjectStatus status = (ModelProjectStatus)theStatus;
        boolean autovalidateOn = ModelerCore.getWorkspace().isAutoBuilding();
        if (status == null || status.getCurrentModelProject() == null) {
            this.setNoProjectStatus(status);
        } else {
            boolean hasErrors = false;
            String projectName = status.getCurrentModelProject().getName();
            if (projectName.length() > 20) {
                projectName = String.valueOf(projectName.substring(0, 20)) + ELIPSIS;
            }
            Image validationImage = this.imageHelper.UNCHECKED_BOX_IMAGE;
            validationImage = status.getModelStatus().getSeverity() == 4 ? (autovalidateOn ? this.imageHelper.PROBLEM_BOX_IMAGE : this.imageHelper.WARNING_PROBLEM_BOX_IMAGE) : (status.getModelStatus().getSeverity() == 2 ? (autovalidateOn ? this.imageHelper.UNCHECKED_BOX_IMAGE : this.imageHelper.WARNING_EMPTY_BOX_IMAGE) : (autovalidateOn ? this.imageHelper.CHECKED_BOX_IMAGE : this.imageHelper.WARNING_CHECKED_BOX_IMAGE));
            if (autovalidateOn) {
                this.validationRow.setText(String.valueOf(Messages.ModelValidationLabel) + TEN_SPACES);
            } else {
                this.validationRow.setText(Messages.ModelValidationOffLabel);
            }
            this.validationRow.update(validationImage, status.getModelStatus().getMessage(), String.valueOf(status.getModelStatus().getMessage()) + CRETURN + Messages.Status_ClickForActions);
            if (status.getModelStatus().getSeverity() == 4) {
                hasErrors = true;
            }
            this.schemasRow.update(this.getButtonImage(5, status.getXmlSchemaFilesStatus().getSeverity()), status.getXmlSchemaFilesStatus().getMessage(), String.valueOf(status.getXmlSchemaFilesStatus().getMessage()) + CRETURN + Messages.Status_ClickForActions);
            if (status.getXmlSchemaFilesStatus().getSeverity() == 4) {
                hasErrors = true;
            }
            this.sourcesRow.update(this.getButtonImage(1, status.getSourceModelsStatus().getSeverity()), status.getSourceModelsStatus().getMessage(), String.valueOf(status.getSourceModelsStatus().getMessage()) + CRETURN + Messages.Status_ClickForActions);
            if (status.getSourceModelsStatus().getSeverity() == 4) {
                hasErrors = true;
            }
            this.connectorsRow.update(this.getButtonImage(2, status.getConnectionFactoriesStatus().getSeverity()), status.getConnectionFactoriesStatus().getMessage(), String.valueOf(status.getConnectionFactoriesStatus().getMessage()) + CRETURN + Messages.Status_ClickForActions);
            if (status.getConnectionFactoriesStatus().getSeverity() == 4) {
                hasErrors = true;
            }
            this.viewsRow.update(this.getButtonImage(3, status.getViewModelsStatus().getSeverity()), status.getViewModelsStatus().getMessage(), String.valueOf(status.getViewModelsStatus().getMessage()) + CRETURN + Messages.Status_ClickForActions);
            if (status.getViewModelsStatus().getSeverity() == 4) {
                hasErrors = true;
            }
            this.vdbsRow.update(this.getButtonImage(8, status.getVdbsStatus().getSeverity()), status.getVdbsStatus().getMessage(), String.valueOf(status.getVdbsStatus().getMessage()) + CRETURN + Messages.Status_ClickForActions);
            if (status.getVdbsStatus().getSeverity() == 4) {
                hasErrors = true;
            }
            this.testRow.update(this.getButtonImage(10, status.getTestStatus().getSeverity()), status.getTestStatus().getMessage(), String.valueOf(status.getTestStatus().getMessage()) + CRETURN + Messages.Status_ClickForActions);
            if (status.getTestStatus().getSeverity() == 4) {
                hasErrors = true;
            }
        }
        if (status.getCurrentModelProject() != null) {
            this.projectNameLabel.setText(status.getCurrentModelProject().getName());
            this.resetStatusFGColor(false);
        } else {
            this.projectNameLabel.setText(String.valueOf(Messages.StatusSectionTitle_NoProjectSelected) + "                                     ");
        }
        this.refreshIcons();
        this.section.getParent().redraw();
    }

    private void setNoProjectStatus(ModelProjectStatus status) {
        String message = Messages.Status_Project_Not_Selected;
        int severity = 0;
        this.validationRow.update(this.getButtonImage(0, severity), message, String.valueOf(message) + CRETURN + Messages.Status_ClickForActions);
        this.sourcesRow.update(this.getButtonImage(1, severity), message, String.valueOf(message) + CRETURN + Messages.Status_ClickForActions);
        this.connectorsRow.update(this.getButtonImage(2, severity), message, String.valueOf(message) + CRETURN + Messages.Status_ClickForActions);
        this.viewsRow.update(this.getButtonImage(3, severity), message, String.valueOf(message) + CRETURN + Messages.Status_ClickForActions);
        this.testRow.update(this.getButtonImage(10, severity), message, String.valueOf(message) + CRETURN + Messages.Status_ClickForActions);
        this.vdbsRow.update(this.getButtonImage(8, severity), message, String.valueOf(message) + CRETURN + Messages.Status_ClickForActions);
        this.schemasRow.update(this.getButtonImage(5, severity), message, String.valueOf(message) + CRETURN + Messages.Status_ClickForActions);
        this.validationRow.setLinkTooltip(String.valueOf(Messages.NoProjectMessage) + CRETURN + Messages.Status_ClickForActions);
        this.sourcesRow.setLinkTooltip(String.valueOf(Messages.NoProjectMessage) + CRETURN + Messages.Status_ClickForActions);
        this.connectorsRow.setLinkTooltip(String.valueOf(Messages.NoProjectMessage) + CRETURN + Messages.Status_ClickForActions);
        this.viewsRow.setLinkTooltip(String.valueOf(Messages.NoProjectMessage) + CRETURN + Messages.Status_ClickForActions);
        this.vdbsRow.setLinkTooltip(String.valueOf(Messages.NoProjectMessage) + CRETURN + Messages.Status_ClickForActions);
        this.testRow.setLinkTooltip(String.valueOf(Messages.NoProjectMessage) + CRETURN + Messages.Status_ClickForActions);
        this.schemasRow.setLinkTooltip(String.valueOf(Messages.NoProjectMessage) + CRETURN + Messages.Status_ClickForActions);
        this.validationRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
        this.validationRow.setText(String.valueOf(Messages.ModelValidationLabel) + TEN_SPACES);
        this.sourcesRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
        this.connectorsRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
        this.viewsRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
        this.vdbsRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
        this.testRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
        this.schemasRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
    }

    private void setEnabledState() {
        boolean doEnable = AdvisorStatusManager.statusEnabled();
        this.changeProjectButton.setEnabled(doEnable);
        this.projectLabel.setEnabled(doEnable);
        this.projectNameLabel.setEnabled(doEnable);
        this.resetStatusFGColor(!doEnable);
        if (!doEnable) {
            this.validationRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
            this.validationRow.setText(String.valueOf(Messages.ModelValidationLabel) + TEN_SPACES);
            this.sourcesRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
            this.connectorsRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
            this.viewsRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
            this.vdbsRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
            this.testRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
            this.schemasRow.setImage(this.imageHelper.EMPTY_BOX_IMAGE);
        }
        this.refreshIcons();
    }

    private Image getButtonImage(int category, int severity) {
        Image image = this.imageHelper.UNCHECKED_BOX_IMAGE;
        switch (category) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                image = severity == 4 ? this.imageHelper.PROBLEM_BOX_IMAGE : (severity == 2 ? this.imageHelper.WARNING_EMPTY_BOX_IMAGE : this.imageHelper.CHECKED_BOX_IMAGE);
            }
        }
        return image;
    }

    private void resetStatusFGColor(boolean setToDim) {
        if (setToDim) {
            this.connectorsRow.dim();
            this.sourcesRow.dim();
            this.schemasRow.dim();
            this.viewsRow.dim();
            this.validationRow.dim();
            this.vdbsRow.dim();
            this.testRow.dim();
        } else {
            this.validationRow.brighten();
            this.schemasRow.brighten();
            this.sourcesRow.brighten();
            this.connectorsRow.brighten();
            this.viewsRow.brighten();
            this.vdbsRow.brighten();
            this.testRow.brighten();
        }
    }

    private void refreshIcons() {
        this.validationRow.redraw();
        this.sourcesRow.redraw();
        this.schemasRow.redraw();
        this.connectorsRow.redraw();
        this.viewsRow.redraw();
        this.vdbsRow.redraw();
        this.testRow.redraw();
        this.section.redraw();
        this.section.getParent().redraw();
    }

    public Section getSection() {
        return this.section;
    }
}

