/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.DelegateIValue;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.details.TextIValue;
import org.eclipse.bpel.common.ui.details.widgets.StatusLabel2;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.NamespaceUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class NamespaceSection
extends BPELPropertySection {
    protected Text namespaceText;
    protected StatusLabel2 statusLabel;
    protected EditController fNamspaceEditHelper;

    protected void createNamespaceWidgets(Composite composite) {
        Label namespaceLabel = this.fWidgetFactory.createLabel(composite, Messages.NamespaceSection_Target_namespace_1);
        this.namespaceText = this.fWidgetFactory.createText(composite, "");
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)namespaceLabel, 131));
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        this.namespaceText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.namespaceText, -5);
        data.top = new FlatFormAttachment((Control)this.namespaceText, 0, 0x1000000);
        namespaceLabel.setLayoutData((Object)data);
    }

    protected void createChangeTrackers() {
        this.fNamspaceEditHelper = this.createEditController();
        this.fNamspaceEditHelper.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getProcess_TargetNamespace());
        this.fNamspaceEditHelper.setViewIValue((IValue)new DelegateIValue((IValue)new TextIValue(this.namespaceText)){

            public String get() {
                String text = this.fDelegate.get().toString();
                return "".equals(text) ? null : NamespaceUtils.convertNamespaceToUri(text);
            }

            public void set(Object object) {
                if (object == null) {
                    this.fDelegate.set((Object)"");
                    return;
                }
                this.fDelegate.set((Object)NamespaceUtils.convertUriToNamespace(object.toString()));
            }
        });
        this.fNamspaceEditHelper.startListeningTo(new Control[]{this.namespaceText});
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createNamespaceWidgets(composite);
        this.createChangeTrackers();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_namespace");
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.fNamspaceEditHelper.setInput(newInput);
    }

    @Override
    public Object getUserContext() {
        return null;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.namespaceText.setFocus();
    }
}

