/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceNotification;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationAdapter;
import org.teiid.designer.core.workspace.ModelWorkspaceNotificationListener;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;

public class RelationalPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.teiid.designer.metamodels.relational";
    public static final String PACKAGE_ID = RelationalPlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
    public static final PluginUtil Util = new PluginUtilImpl("org.teiid.designer.metamodels.relational", I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    private static final ResourceLocator RESOURCE_LOCATOR = new ResourceLocator(){

        public URL getBaseURL() {
            if (INSTANCE != null) {
                URL baseUrl;
                try {
                    baseUrl = FileLocator.resolve((URL)INSTANCE.getBundle().getEntry("/"));
                }
                catch (IOException iOException) {
                    baseUrl = null;
                }
                return baseUrl;
            }
            try {
                URI uri = URI.createURI((String)this.getClass().getResource("plugin.properties").toString());
                URL baseUrl = new URL(String.valueOf(uri.trimSegments(1).toString()) + "/");
                return baseUrl;
            }
            catch (IOException exception) {
                throw new WrappedException((Exception)exception);
            }
        }

        public Object getImage(String key) {
            try {
                URL baseUrl = this.getBaseURL();
                URL url = new URL(baseUrl + "icons/" + key + ".gif");
                InputStream inputStream = url.openStream();
                inputStream.close();
                return url;
            }
            catch (MalformedURLException exception) {
                throw new WrappedException((Exception)exception);
            }
            catch (IOException iOException) {
                throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
            }
        }

        public String getString(String key) {
            return Util.getString(key, new Object[0]);
        }

        public String getString(String key, Object[] substitutions) {
            return Util.getString(key, substitutions);
        }

        public String getString(String key, boolean translate) {
            return this.getString(key);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.getString(key, substitutions);
        }
    };
    static RelationalPlugin INSTANCE = null;
    private ModelWorkspaceNotificationAdapter workspaceListener = null;

    public static ResourceLocator getPluginResourceLocator() {
        return RESOURCE_LOCATOR;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        this.workspaceListener = new ModelWorkspaceNotificationAdapter(){

            public void notifyReloaded(ModelWorkspaceNotification notification) {
                RelationalPlugin.this.handleNewModelEvent(notification);
            }

            public void notifyAdd(ModelWorkspaceNotification notification) {
                RelationalPlugin.this.handleNewModelEvent(notification);
            }
        };
        ModelWorkspaceManager.getModelWorkspaceManager().addNotificationListener((ModelWorkspaceNotificationListener)this.workspaceListener);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.workspaceListener != null) {
            ModelWorkspaceManager.getModelWorkspaceManager().removeNotificationListener((ModelWorkspaceNotificationListener)this.workspaceListener);
        }
        super.stop(context);
    }

    void handleNewModelEvent(ModelWorkspaceNotification notification) {
        IResource model;
        if (notification.isPostChange() && (model = (IResource)notification.getNotifier()) != null) {
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            String prefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
            RelationalModelExtensionAssistant assistant = (RelationalModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
            try {
                assistant.applyMedIfNecessary(model);
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        }
    }

    public static String getExtensionProperty(EObject modelObject, String propertyID) {
        String value = null;
        if (modelObject != null) {
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            String prefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
            RelationalModelExtensionAssistant assistant = (RelationalModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
            try {
                value = assistant.getPropertyValue(modelObject, propertyID);
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        }
        return value;
    }
}

