/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.sql;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.aspects.sql.RelationalEntityAspect;

public class ProcedureAspect
extends RelationalEntityAspect
implements SqlProcedureAspect {
    public ProcedureAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean isVirtual(EObject eObject) {
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)eObject);
        Procedure procedure = (Procedure)eObject;
        try {
            ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation((EObject)procedure);
            return ma != null && ma.getModelType().getValue() == ModelType.VIRTUAL;
        }
        catch (Exception e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
            return false;
        }
    }

    public boolean isFunction(EObject eObject) {
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)eObject);
        Procedure proc = (Procedure)eObject;
        return proc.isFunction();
    }

    public List getParameters(EObject eObject) {
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)eObject);
        Procedure proc = (Procedure)eObject;
        return proc.getParameters();
    }

    public Object getResult(EObject eObject) {
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)eObject);
        Procedure proc = (Procedure)eObject;
        return proc.getResult();
    }

    public int getUpdateCount(EObject eObject) {
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)eObject);
        return ((Procedure)eObject).getUpdateCount().getValue();
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'E';
    }

    public boolean isMappable(EObject eObject, int mappingType) {
        if (this.isVirtual(eObject)) {
            return mappingType == 1;
        }
        return false;
    }

    public boolean canAcceptTransformationSource(EObject target, EObject source) {
        SqlAspect sourceAspect;
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)target);
        CoreArgCheck.isNotNull((Object)source);
        if (source == target) {
            return false;
        }
        return this.isVirtual(target) && ((sourceAspect = SqlAspectHelper.getSqlAspect((EObject)source)) instanceof SqlTableAspect || sourceAspect instanceof SqlProcedureAspect);
    }

    public boolean canBeTransformationSource(EObject source, EObject target) {
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)source);
        CoreArgCheck.isNotNull((Object)target);
        if (source == target) {
            return false;
        }
        SqlAspect targetAspect = SqlAspectHelper.getSqlAspect((EObject)target);
        if (targetAspect instanceof SqlTableAspect) {
            return ((SqlTableAspect)targetAspect).isVirtual(target);
        }
        if (targetAspect instanceof SqlProcedureAspect) {
            return ((SqlProcedureAspect)targetAspect).isVirtual(target);
        }
        return false;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }
}

