/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.sql;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AbstractMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.SearchabilityType;

public abstract class RelationalEntityAspect
extends AbstractMetamodelAspect
implements SqlAspect {
    public static final String ASPECT_ID = "sqlAspect";

    protected RelationalEntityAspect(MetamodelEntity entity) {
        super.setMetamodelEntity(entity);
        super.setID(ASPECT_ID);
    }

    protected Object getFeatureValue(EObject eObject, int featureID) {
        EClass eClass = eObject.eClass();
        EStructuralFeature feature = eClass.getEStructuralFeature(featureID);
        return eObject.eGet(feature);
    }

    public String getName(EObject eObject) {
        CoreArgCheck.isInstanceOf(RelationalEntity.class, (Object)eObject);
        RelationalEntity entity = (RelationalEntity)eObject;
        return entity.getName();
    }

    public String getNameInSource(EObject eObject) {
        CoreArgCheck.isInstanceOf(RelationalEntity.class, (Object)eObject);
        RelationalEntity entity = (RelationalEntity)eObject;
        return entity.getNameInSource();
    }

    public Object getObjectID(EObject eObject) {
        return super.getObjectID(eObject);
    }

    public IPath getPath(EObject eObject) {
        String pathString = this.getFullName(eObject).replace(DELIMITER_CHAR, '/');
        return new Path(pathString);
    }

    public String getFullName(EObject eObject) {
        ModelEditor editor = ModelerCore.getModelEditor();
        String modelName = editor.getModelName(eObject);
        String name = this.getName(eObject);
        EObject container = eObject.eContainer();
        while (container != null) {
            String partName = this.getName(container);
            name = String.valueOf(partName) + DELIMITER_CHAR + name;
            container = container.eContainer();
        }
        return String.valueOf(modelName) + DELIMITER_CHAR + name;
    }

    public boolean isQueryable(EObject eObject) {
        return true;
    }

    protected int convertDirectionKindToMetadataConstant(DirectionKind kind) {
        switch (kind.getValue()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    protected DirectionKind convertMetadataContantToDirectionKind(int direction) {
        switch (direction) {
            case 0: {
                return DirectionKind.IN_LITERAL;
            }
            case 1: {
                return DirectionKind.OUT_LITERAL;
            }
            case 2: {
                return DirectionKind.INOUT_LITERAL;
            }
            case 3: {
                return DirectionKind.RETURN_LITERAL;
            }
        }
        return DirectionKind.UNKNOWN_LITERAL;
    }

    protected int convertNullableTypeToMetadataConstant(NullableType type) {
        switch (type.getValue()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return -1;
    }

    protected NullableType convertMetadataConstantToNullableType(int nullType) {
        switch (nullType) {
            case 0: {
                return NullableType.NO_NULLS_LITERAL;
            }
            case 1: {
                return NullableType.NULLABLE_LITERAL;
            }
            case 2: {
                return NullableType.NULLABLE_UNKNOWN_LITERAL;
            }
        }
        return NullableType.NULLABLE_UNKNOWN_LITERAL;
    }

    protected int convertSearchabilityTypeToMetadataConstant(SearchabilityType type) {
        switch (type.getValue()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    protected SearchabilityType convertMetadataConstantToSearchabilityType(int searchabilityType) {
        switch (searchabilityType) {
            case 0: {
                return SearchabilityType.SEARCHABLE_LITERAL;
            }
            case 1: {
                return SearchabilityType.ALL_EXCEPT_LIKE_LITERAL;
            }
            case 2: {
                return SearchabilityType.LIKE_ONLY_LITERAL;
            }
            case 3: {
                return SearchabilityType.UNSEARCHABLE_LITERAL;
            }
        }
        return SearchabilityType.SEARCHABLE_LITERAL;
    }
}

