/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.uml;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.uml.UmlAssociation;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.aspects.uml.RelationalEntityAspect;

public class AccessPatternAspect
extends RelationalEntityAspect
implements UmlAssociation {
    public AccessPatternAspect(MetamodelEntity entity) {
        this.setMetamodelEntity(entity);
    }

    public int getEndCount(Object obj) {
        return 0;
    }

    public String getRoleName(Object assoc, int end) {
        AccessPattern pattern = this.assertAccessPattern(assoc);
        return pattern.getName();
    }

    public EObject getEnd(Object primaryKey, int end) {
        return null;
    }

    public EObject getEndTarget(Object primaryKey, int end) {
        return null;
    }

    public String getStereotype(Object eObject) {
        return RelationalPlugin.getPluginResourceLocator().getString("_UI_AccessPattern_type");
    }

    public int getAggregation(Object assoc, int end) {
        return 301;
    }

    public String[] getProperties(Object assoc, int end) {
        return CoreStringUtil.Constants.EMPTY_STRING_ARRAY;
    }

    public int getNavigability(Object assoc, int end) {
        if (end == 1) {
            return 503;
        }
        if (end == 0) {
            return 501;
        }
        return 502;
    }

    public String getMultiplicity(Object eObject, int end) {
        this.assertAccessPattern(eObject);
        if (end == 0) {
            return "0..1";
        }
        if (end == 1) {
            return "0..1";
        }
        return "";
    }

    public String getSignature(Object eObject, int showMask) {
        AccessPattern pattern = this.assertAccessPattern(eObject);
        StringBuffer result = new StringBuffer();
        switch (showMask) {
            case 1: {
                result.append(pattern.getName());
                break;
            }
            case 2: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">>");
                break;
            }
            case 3: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">> ");
                result.append(pattern.getName());
                break;
            }
            case 4: {
                result.append(super.getArrayAsString(this.getProperties(pattern, 0)));
                break;
            }
            case 5: {
                result.append(pattern.getName());
                result.append(super.getArrayAsString(this.getProperties(pattern, 0)));
                break;
            }
            case 6: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">> ");
                result.append(super.getArrayAsString(this.getProperties(pattern, 0)));
                break;
            }
            case 7: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">> ");
                result.append(pattern.getName());
                result.append(super.getArrayAsString(this.getProperties(pattern, 0)));
                break;
            }
            default: {
                throw new TeiidDesignerRuntimeException(RelationalPlugin.Util.getString("Aspect.invalidShowMask", (Object)showMask));
            }
        }
        return result.toString();
    }

    public String getEditableSignature(Object eObject) {
        return this.getSignature(eObject, 1);
    }

    public IStatus setRoleName(Object assoc, int end, String name) {
        throw new UnsupportedOperationException("TODO");
    }

    public IStatus setMultiplicity(Object assoc, int end, String mult) {
        throw new UnsupportedOperationException();
    }

    public IStatus setProperties(Object assoc, int end, String[] props) {
        throw new UnsupportedOperationException();
    }

    public IStatus setNavigability(Object assoc, int end, int navigability) {
        throw new UnsupportedOperationException();
    }

    public IStatus setSignature(Object eObject, String newSignature) {
        try {
            AccessPattern ap = this.assertAccessPattern(eObject);
            ap.setName(newSignature);
        }
        catch (Throwable e) {
            return new Status(4, "org.teiid.designer.metamodels.relational", 0, e.getMessage(), e);
        }
        return new Status(0, "org.teiid.designer.metamodels.relational", 0, RelationalPlugin.Util.getString("Aspect.ok", new Object[0]), null);
    }

    public String getName(Object eObject) {
        return "";
    }

    public String getToolTip(Object eObject) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(this.getStereotype(eObject));
        return sb.toString();
    }

    protected AccessPattern assertAccessPattern(Object eObject) {
        CoreArgCheck.isInstanceOf(AccessPattern.class, (Object)eObject);
        return (AccessPattern)eObject;
    }
}

