/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.uml;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.uml.UmlClassifier;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.LogicalRelationship;
import org.teiid.designer.metamodels.relational.LogicalRelationshipEnd;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Relationship;
import org.teiid.designer.metamodels.relational.aspects.uml.RelationalEntityAspect;

public class BaseTableAspect
extends RelationalEntityAspect
implements UmlClassifier {
    public BaseTableAspect(MetamodelEntity entity) {
        this.setMetamodelEntity(entity);
    }

    public String getStereotype(Object eObject) {
        return RelationalPlugin.getPluginResourceLocator().getString("_UI_BaseTable_type");
    }

    public IStatus setSignature(Object eObject, String newSignature) {
        try {
            BaseTable dt = this.assertBaseTable(eObject);
            dt.setName(newSignature);
        }
        catch (Throwable e) {
            return new Status(4, "org.teiid.designer.metamodels.relational", 0, e.getMessage(), e);
        }
        return new Status(0, "org.teiid.designer.metamodels.relational", 0, RelationalPlugin.Util.getString("Aspect.ok", new Object[0]), null);
    }

    public Collection getRelationships(Object eObject) {
        BaseTable table = this.assertBaseTable(eObject);
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        results.addAll((Collection<Relationship>)table.getForeignKeys());
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null) {
            EList fkRefs = pk.getForeignKeys();
            for (ForeignKey fk : fkRefs) {
                if (results.contains(fk)) continue;
                results.add(fk);
            }
        }
        EList lres = table.getLogicalRelationships();
        for (LogicalRelationshipEnd lre : lres) {
            LogicalRelationship lr = lre.getRelationship();
            if (results.contains(lr)) continue;
            results.add(lr);
        }
        return results;
    }

    public Collection getSupertypes(Object eObject) {
        return new ArrayList();
    }

    public String getSignature(Object eObject, int showMask) {
        BaseTable table = this.assertBaseTable(eObject);
        StringBuffer result = new StringBuffer();
        switch (showMask) {
            case 1: {
                result.append(table.getName());
                break;
            }
            case 2: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">>");
                break;
            }
            case 3: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">> ");
                result.append(table.getName());
                break;
            }
            default: {
                throw new TeiidDesignerRuntimeException(RelationalPlugin.Util.getString("Aspect.invalidShowMask", (Object)showMask));
            }
        }
        return result.toString();
    }

    public String getEditableSignature(Object eObject) {
        return this.getSignature(eObject, 1);
    }

    public boolean isAbstract(Object eObject) {
        return false;
    }

    protected BaseTable assertBaseTable(Object eObject) {
        CoreArgCheck.isInstanceOf(BaseTable.class, (Object)eObject);
        return (BaseTable)eObject;
    }
}

