/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.uml;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.aspects.uml.RelationalEntityAspect;

public class CatalogAspect
extends RelationalEntityAspect
implements UmlPackage {
    public CatalogAspect(MetamodelEntity entity) {
        this.setMetamodelEntity(entity);
    }

    public String getStereotype(Object eObject) {
        return RelationalPlugin.getPluginResourceLocator().getString("_UI_Catalog_type");
    }

    public IStatus setSignature(Object eObject, String newSignature) {
        try {
            Catalog catalog = this.assertCatalog(eObject);
            catalog.setName(newSignature);
        }
        catch (Throwable e) {
            return new Status(4, "org.teiid.designer.metamodels.relational", 0, e.getMessage(), e);
        }
        return new Status(0, "org.teiid.designer.metamodels.relational", 0, RelationalPlugin.Util.getString("Aspect.ok", new Object[0]), null);
    }

    public String getSignature(Object eObject, int showMask) {
        Catalog catalog = this.assertCatalog(eObject);
        StringBuffer result = new StringBuffer();
        switch (showMask) {
            case 1: {
                result.append(catalog.getName());
                break;
            }
            case 2: {
                result.append("<<");
                result.append(this.getStereotype(catalog));
                result.append(">>");
                break;
            }
            case 3: {
                result.append("<<");
                result.append(this.getStereotype(catalog));
                result.append(">> ");
                result.append(catalog.getName());
                break;
            }
            default: {
                throw new TeiidDesignerRuntimeException(RelationalPlugin.Util.getString("Aspect.invalidShowMask", (Object)showMask));
            }
        }
        return result.toString();
    }

    public String getEditableSignature(Object eObject) {
        return this.getSignature(eObject, 1);
    }

    protected Catalog assertCatalog(Object eObject) {
        CoreArgCheck.isInstanceOf(Catalog.class, (Object)eObject);
        return (Catalog)eObject;
    }
}

