/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.uml;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.aspects.uml.RelationalEntityAspect;

public class SchemaAspect
extends RelationalEntityAspect
implements UmlPackage {
    public SchemaAspect(MetamodelEntity entity) {
        this.setMetamodelEntity(entity);
    }

    public String getStereotype(Object eObject) {
        return RelationalPlugin.getPluginResourceLocator().getString("_UI_Schema_type");
    }

    public IStatus setSignature(Object eObject, String newSignature) {
        try {
            Schema schema = this.assertSchema(eObject);
            schema.setName(newSignature);
        }
        catch (Throwable e) {
            return new Status(4, "org.teiid.designer.metamodels.relational", 0, e.getMessage(), e);
        }
        return new Status(0, "org.teiid.designer.metamodels.relational", 0, RelationalPlugin.Util.getString("Aspect.ok", new Object[0]), null);
    }

    public String getSignature(Object eObject, int showMask) {
        Schema schema = this.assertSchema(eObject);
        StringBuffer result = new StringBuffer();
        switch (showMask) {
            case 1: {
                result.append(schema.getName());
                break;
            }
            case 2: {
                result.append("<<");
                result.append(this.getStereotype(schema));
                result.append(">>");
                break;
            }
            case 3: {
                result.append("<<");
                result.append(this.getStereotype(schema));
                result.append(">> ");
                result.append(schema.getName());
                break;
            }
            default: {
                throw new TeiidDesignerRuntimeException(RelationalPlugin.Util.getString("Aspect.invalidShowMask", (Object)showMask));
            }
        }
        return result.toString();
    }

    public String getEditableSignature(Object eObject) {
        return this.getSignature(eObject, 1);
    }

    protected Schema assertSchema(Object eObject) {
        CoreArgCheck.isInstanceOf(Schema.class, (Object)eObject);
        return (Schema)eObject;
    }
}

