/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation;

import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.RelationalPlugin;

public class RelationalStringNameValidator
extends StringNameValidator {
    public static String DESIGNER_CORE_PACKAGE = ModelerCore.class.getPackage().getName();
    public static char[] INVALID_CHARS = new char[]{' ', '.'};
    public static char[] INVALID_QUOTED_CHARS = new char[]{' '};
    boolean isTable = false;
    boolean restrictChars = false;

    public RelationalStringNameValidator() {
        this.initializePreference();
    }

    public RelationalStringNameValidator(boolean isTable) {
        super(new char[]{'_'});
        this.isTable = isTable;
        this.initializePreference();
    }

    public RelationalStringNameValidator(boolean isTable, boolean restrictChars) {
        this(isTable);
        this.restrictChars = restrictChars;
    }

    private void initializePreference() {
        String value = ModelerCore.getPreferences((String)DESIGNER_CORE_PACKAGE).get("relationalPreferences.nameCharacterRestriction", null);
        if (CoreStringUtil.isEmpty((String)value)) {
            value = ModelerCore.getDefaultPreferences((String)DESIGNER_CORE_PACKAGE).get("relationalPreferences.nameCharacterRestriction", null);
        }
        if (value != null && value.equals("error")) {
            this.restrictChars = true;
        }
    }

    public String getValidNonLetterOrDigitMessageSuffix() {
        if (this.isTable) {
            return RelationalPlugin.Util.getString("RelationalStringNameValidator.or_other_valid_table_characters", new Object[0]);
        }
        return super.getValidNonLetterOrDigitMessageSuffix();
    }

    protected String isValidChar(char c, int index) {
        if (this.restrictChars) {
            return super.isValidChar(c, index);
        }
        return this.isValidRelationalNameCharacter(c, index, false);
    }

    protected String isValidCharInDoubleQuotes(char c, int index) {
        return this.isValidRelationalNameCharacter(c, index, true);
    }

    private String isValidRelationalNameCharacter(char c, int index, boolean doubleQuoted) {
        char nextChar;
        boolean valid = true;
        if (index == 0) {
            valid = Character.isLetter(c);
        } else if (doubleQuoted) {
            char[] cArray = INVALID_QUOTED_CHARS;
            int n = INVALID_QUOTED_CHARS.length;
            int n2 = 0;
            while (n2 < n) {
                nextChar = cArray[n2];
                if (c == nextChar) {
                    valid = false;
                    break;
                }
                ++n2;
            }
        } else {
            char[] cArray = INVALID_CHARS;
            int n = INVALID_CHARS.length;
            int n3 = 0;
            while (n3 < n) {
                nextChar = cArray[n3];
                if (c == nextChar) {
                    valid = false;
                    break;
                }
                ++n3;
            }
        }
        if (!valid) {
            Object[] params = new Object[]{new Character(c), new Integer(index + 1), this.getValidNonLetterOrDigitMessageSuffix()};
            return RelationalPlugin.Util.getString("RelationalStringNameValidator.nameIsInvalidTheCharacterAt", params);
        }
        return null;
    }

    public void setRestrictChars(boolean restrictChars) {
        this.restrictChars = restrictChars;
    }

    public void setIsTable(boolean isTable) {
        this.isTable = isTable;
    }

    public void setUp(boolean isTable, boolean restrictChars) {
        this.isTable = isTable;
        this.restrictChars = restrictChars;
    }
}

