/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ColumnSet;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;

public class AccessPatternColumnsRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(AccessPattern.class, (Object)eObject);
        AccessPattern accessPattern = (AccessPattern)eObject;
        EList apColumns = accessPattern.getColumns();
        Table apTable = accessPattern.getTable();
        CoreArgCheck.isNotNull((Object)apTable);
        for (Column column : apColumns) {
            ColumnSet colTable = (ColumnSet)column.eContainer();
            CoreArgCheck.isNotNull((Object)colTable);
            if (apTable.equals(colTable)) continue;
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            String msg = RelationalPlugin.Util.getString("AccessPatternColumnsRule.AccessPattern_{0}_may_not_reference_column_{1}_from_a_different_table_1", new Object[]{accessPattern.getName(), column.getName()});
            result.addProblem((ValidationProblem)new ValidationProblemImpl(0, 4, msg));
            context.addResult((ValidationResult)result);
            return;
        }
    }
}

