/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalPlugin;

public class ColumnNativeTypeRule
implements ObjectValidationRule {
    public void validate(EObject theObject, ValidationContext theContext) {
        CoreArgCheck.isInstanceOf(Column.class, (Object)theObject);
        String validationMsg = this.validate((Column)theObject);
        if (validationMsg != null) {
            ValidationResultImpl result = new ValidationResultImpl((Object)theObject);
            result.addProblem((ValidationProblem)new ValidationProblemImpl(0, 4, validationMsg));
            theContext.addResult((ValidationResult)result);
        }
    }

    protected String validate(Column theColumn) {
        String result = null;
        String nativeType = theColumn.getNativeType();
        if (nativeType != null && nativeType.trim().length() == 0) {
            result = RelationalPlugin.Util.getString("ColumnNativeTypeRule.emptyValueMsg", new Object[0]);
        }
        return result;
    }
}

