/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.UniqueKey;

public class ForeignKeyColumnsRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(ForeignKey.class, (Object)eObject);
        ForeignKey foreignKey = (ForeignKey)eObject;
        UniqueKey uniqueKey = foreignKey.getUniqueKey();
        if (uniqueKey == null) {
            return;
        }
        EList fkColumns = foreignKey.getColumns();
        EList ukColumns = uniqueKey.getColumns();
        int numFkColumns = fkColumns.size();
        int numUkColumns = ukColumns.size();
        if (numFkColumns == 0 || numUkColumns == 0) {
            return;
        }
        if (numFkColumns != numUkColumns) {
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            String msg = String.valueOf(RelationalPlugin.Util.getString("ForeignKeyColumnsRule.The_number_of_columns_on_the_foreignkey__1", new Object[0])) + foreignKey.getName() + RelationalPlugin.Util.getString("ForeignKeyColumnsRule._do_not_match_the_number_of_columns_on_the_referenced_uniquekey__2", new Object[0]) + uniqueKey.getName();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        Iterator fkColIter = fkColumns.iterator();
        Iterator ukColIter = ukColumns.iterator();
        while (fkColIter.hasNext() && ukColIter.hasNext()) {
            Column fkColumn = (Column)fkColIter.next();
            Column ukColumn = (Column)ukColIter.next();
            EObject fkType = fkColumn.getType();
            EObject ukType = ukColumn.getType();
            if (fkType == null || ukType == null) {
                return;
            }
            if (fkType.equals(ukType)) continue;
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            String msg = String.valueOf(RelationalPlugin.Util.getString("ForeignKeyColumnsRule.The_datatype_of_the_column__3", new Object[0])) + fkColumn.getName() + RelationalPlugin.Util.getString("ForeignKeyColumnsRule._on_the_foreignKey__4", new Object[0]) + foreignKey.getName() + RelationalPlugin.Util.getString("ForeignKeyColumnsRule._doesn__t_match_the_that_of_the__5", new Object[0]) + ukColumn.getName() + RelationalPlugin.Util.getString("ForeignKeyColumnsRule._on_the_referenced_uniquekey__6", new Object[0]) + uniqueKey.getName();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg);
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
    }
}

