/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalPlugin;

public class MissingNameInSourceRule
implements ObjectValidationRule {
    private static final String nameInSourceFeatureName = RelationalPlugin.Util.getString("_UI_RelationalEntity_nameInSource_feature", new Object[0]);

    public void validate(EObject eObject, ValidationContext context) {
        if (!this.shouldRun(eObject, context)) {
            return;
        }
        int status = this.getPreferenceStatus(context);
        if (status == 0) {
            return;
        }
        String nameInSourceA = this.getNameInSource(eObject);
        if (CoreStringUtil.isEmpty((String)nameInSourceA)) {
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            Object[] params = new Object[]{this.getName(eObject), nameInSourceFeatureName};
            String msg = RelationalPlugin.Util.getString("MissingNameInSourceRule.warning_message", params);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, status, msg);
            problem.setHasPreference(context.hasPreferences());
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
        }
    }

    protected int getPreferenceStatus(ValidationContext context) {
        return context.getPreferenceStatus("relationalPreferences.missingNameInSource", 0);
    }

    private String getName(Object sibling) {
        if (sibling instanceof RelationalEntity) {
            RelationalEntity entity = (RelationalEntity)sibling;
            return entity.getName();
        }
        return ModelerCore.getModelEditor().getModelRelativePathIncludingModel((EObject)sibling).toString();
    }

    private String getNameInSource(Object sibling) {
        if (sibling instanceof RelationalEntity) {
            RelationalEntity entity = (RelationalEntity)sibling;
            return entity.getNameInSource();
        }
        return null;
    }

    private boolean shouldRun(EObject eObject, ValidationContext context) {
        if (this.getPreferenceStatus(context) == 0) {
            return false;
        }
        try {
            ModelAnnotation modelAnnotation = ModelerCore.getModelEditor().getModelAnnotation(eObject);
            int modelType = modelAnnotation.getModelType().getValue();
            if (modelType != ModelType.PHYSICAL) {
                return false;
            }
        }
        catch (Exception e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
        return true;
    }

    protected class ValidationResults {
        private final ValidationResult[] results;

        public ValidationResults(int size) {
            this.results = new ValidationResult[size];
        }

        public ValidationResult get(int index, EObject object) {
            ValidationResult result = this.results[index];
            if (result == null) {
                this.results[index] = result = new ValidationResultImpl((Object)object);
            }
            return result;
        }
    }
}

