/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.LogicalRelationship;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;

public class SiblingNameInSourceRule
implements ObjectValidationRule {
    private static final String nameInSourceFeatureName = RelationalPlugin.Util.getString("_UI_RelationalEntity_nameInSource_feature", new Object[0]);
    private static final String RULE_NAME = SiblingNameInSourceRule.class.getName();

    public void validate(EObject eObject, ValidationContext context) {
        if (!this.shouldRun(eObject, context)) {
            return;
        }
        List siblings = this.getSiblingsForUniquenessCheck(eObject);
        if (siblings.isEmpty()) {
            return;
        }
        int statusForCaseSensitive = this.getPreferenceStatus(context);
        int statusForCaseInsensitive = statusForCaseSensitive == 4 ? 2 : statusForCaseSensitive;
        ValidationResults validationResults = new ValidationResults(siblings.size());
        int i = 0;
        while (i < siblings.size()) {
            EObject siblingI = (EObject)siblings.get(i);
            String nameInSourceA = this.getNameInSource(siblingI);
            ValidationResult result = validationResults.get(i, siblingI);
            if (!CoreStringUtil.isEmpty((String)nameInSourceA)) {
                int j = i + 1;
                while (j < siblings.size()) {
                    EObject siblingJ = (EObject)siblings.get(j);
                    String nameInSourceB = this.getNameInSource(siblings.get(j));
                    if (!CoreStringUtil.isEmpty((String)nameInSourceB)) {
                        ValidationProblemImpl problemJ;
                        ValidationResult resultJ;
                        ValidationProblemImpl problem;
                        String msg;
                        Object[] params;
                        if (nameInSourceA.equals(nameInSourceB)) {
                            params = new Object[]{this.getName(siblingI), this.getName(siblingJ), nameInSourceFeatureName};
                            msg = RelationalPlugin.Util.getString("SiblingNameInSourceRule.failure_message_case_sensitive", params);
                            problem = new ValidationProblemImpl(0, statusForCaseSensitive, msg);
                            problem.setHasPreference(context.hasPreferences());
                            result.addProblem((ValidationProblem)problem);
                            resultJ = validationResults.get(j, siblingJ);
                            problemJ = new ValidationProblemImpl(0, statusForCaseSensitive, msg);
                            problemJ.setHasPreference(context.hasPreferences());
                            resultJ.addProblem((ValidationProblem)problemJ);
                        } else if (nameInSourceA.equalsIgnoreCase(nameInSourceB)) {
                            params = new Object[]{this.getName(siblingI), this.getName(siblingJ), nameInSourceFeatureName};
                            msg = RelationalPlugin.Util.getString("SiblingNameInSourceRule.failure_message_case_insensitive", params);
                            problem = new ValidationProblemImpl(0, statusForCaseInsensitive, msg);
                            problem.setHasPreference(context.hasPreferences());
                            result.addProblem((ValidationProblem)problem);
                            resultJ = validationResults.get(j, siblingJ);
                            problemJ = new ValidationProblemImpl(0, statusForCaseInsensitive, msg);
                            problemJ.setHasPreference(context.hasPreferences());
                            resultJ.addProblem((ValidationProblem)problemJ);
                        }
                    }
                    ++j;
                }
            }
            context.addResult(result);
            ++i;
        }
    }

    protected int getPreferenceStatus(ValidationContext context) {
        return context.getPreferenceStatus("relationalPreferences.siblingNameInSource", 0);
    }

    protected List getSiblingsForUniquenessCheck(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent == null) {
            parent = eObject.eResource();
        }
        if (eObject instanceof Table) {
            return RelationalUtil.findTables(parent, 1);
        }
        if (eObject instanceof Procedure) {
            return RelationalUtil.findProcedures(parent, 1);
        }
        if (eObject instanceof ProcedureParameter) {
            return RelationalUtil.findProcedureParameters(parent, 1);
        }
        if (eObject instanceof Column) {
            return RelationalUtil.findColumns(parent, 1);
        }
        if (eObject instanceof Index) {
            return RelationalUtil.findIndexes(parent, 1);
        }
        if (eObject instanceof ForeignKey || eObject instanceof UniqueKey) {
            return RelationalUtil.findKeys(parent, 1);
        }
        if (eObject instanceof AccessPattern) {
            if (parent instanceof Table) {
                return ((Table)parent).getAccessPatterns();
            }
        } else if (eObject instanceof LogicalRelationship) {
            return RelationalUtil.findLogicalRelationships(parent, 1);
        }
        return Collections.EMPTY_LIST;
    }

    private String getNameInSource(Object sibling) {
        if (sibling instanceof RelationalEntity) {
            RelationalEntity entity = (RelationalEntity)sibling;
            return entity.getNameInSource();
        }
        return null;
    }

    private String getName(Object sibling) {
        if (sibling instanceof RelationalEntity) {
            RelationalEntity entity = (RelationalEntity)sibling;
            return entity.getName();
        }
        return ModelerCore.getModelEditor().getModelRelativePathIncludingModel((EObject)sibling).toString();
    }

    private boolean shouldRun(EObject eObject, ValidationContext context) {
        if (this.getPreferenceStatus(context) == 0) {
            return false;
        }
        try {
            ModelAnnotation modelAnnotation = ModelerCore.getModelEditor().getModelAnnotation(eObject);
            int modelType = modelAnnotation.getModelType().getValue();
            if (modelType != ModelType.PHYSICAL) {
                return false;
            }
        }
        catch (Exception e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
        String objType = eObject.eClass().getName();
        if (context.hasRunRule(eObject, String.valueOf(RULE_NAME) + objType)) {
            return false;
        }
        context.recordRuleRun(eObject, String.valueOf(RULE_NAME) + objType);
        return true;
    }

    protected class ValidationResults {
        private final ValidationResult[] results;

        public ValidationResults(int size) {
            this.results = new ValidationResult[size];
        }

        public ValidationResult get(int index, EObject object) {
            ValidationResult result = this.results[index];
            if (result == null) {
                this.results[index] = result = new ValidationResultImpl((Object)object);
            }
            return result;
        }
    }
}

