/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueKey;

public class TableUniqueKeysRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table table = (Table)eObject;
        Iterator columnIter = table.getColumns().iterator();
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        while (columnIter.hasNext()) {
            Column column = (Column)columnIter.next();
            EList uniqueKeys = column.getUniqueKeys();
            if (uniqueKeys.size() <= 1) continue;
            this.compareUniqueKeys((List)uniqueKeys, (ValidationResult)result);
            if (!result.hasProblems()) continue;
            context.addResult((ValidationResult)result);
            return;
        }
    }

    private void compareUniqueKeys(List uniqueKeys, ValidationResult result) {
        int i = 0;
        while (i < uniqueKeys.size()) {
            UniqueKey key1 = (UniqueKey)uniqueKeys.get(i);
            int j = i + 1;
            while (j < uniqueKeys.size()) {
                EList columns2;
                UniqueKey key2 = (UniqueKey)uniqueKeys.get(j);
                EList columns1 = key1.getColumns();
                if (this.compareColumns((List)columns1, (List)(columns2 = key2.getColumns()))) {
                    String msg = String.valueOf(RelationalPlugin.Util.getString("TableUniqueKeysRule.UniqueKeys__1", new Object[0])) + key1.getName() + RelationalPlugin.Util.getString("TableUniqueKeysRule.,__2", new Object[0]) + key2.getName() + RelationalPlugin.Util.getString("TableUniqueKeysRule._reference_same_set_of_columns_on_the_table__3", new Object[0]) + key1.getTable().getName();
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                    result.addProblem((ValidationProblem)problem);
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean compareColumns(List columns1, List columns2) {
        if (columns1.size() == columns2.size() && columns1.size() > 0) {
            int i = 0;
            while (i < columns1.size()) {
                Column column1 = (Column)columns1.get(i);
                boolean foundMatch = false;
                int j = 0;
                while (j < columns2.size()) {
                    Column column2 = (Column)columns2.get(j);
                    if (column1.equals(column2)) {
                        foundMatch = true;
                        break;
                    }
                    ++j;
                }
                if (!foundMatch) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

