/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.UniqueKey;

public class UniqueKeyColumnsRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(UniqueKey.class, (Object)eObject);
        UniqueKey uniqueKey = (UniqueKey)eObject;
        EList ukColumns = uniqueKey.getColumns();
        BaseTable ukTable = uniqueKey.getTable();
        CoreArgCheck.isNotNull((Object)ukTable);
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        for (Column column : ukColumns) {
            NullableType nullableType;
            if (uniqueKey instanceof PrimaryKey && (nullableType = column.getNullable()).getValue() == 1) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, String.valueOf(RelationalPlugin.Util.getString("UniqueKeyColumnsRule.Primary_key__1", new Object[0])) + uniqueKey.getName() + RelationalPlugin.Util.getString("UniqueKeyColumnsRule._references_a_nullable_column._2", new Object[0]));
                result.addProblem((ValidationProblem)problem);
                break;
            }
            BaseTable colTable = (BaseTable)column.eContainer();
            CoreArgCheck.isNotNull((Object)colTable);
            if (ukTable.equals(colTable)) continue;
            String msg = RelationalPlugin.Util.getString("UniqueKeyColumnsRule.Unique_key_{0}_may_not_reference_column_{1}_from_a_different_table_1", new Object[]{uniqueKey.getName(), column.getName()});
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
            break;
        }
        context.addResult((ValidationResult)result);
    }
}

