/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.metamodels.relational.util.PushdownFunctionUtil;

public class ViewProcedureValidationRule
implements ObjectValidationRule {
    private final String ruleName = this.getClass().getName();

    public void validate(EObject eObject, ValidationContext context) {
        if (context.hasRunRule(eObject, this.ruleName)) {
            return;
        }
        ModelResource mr = null;
        ModelType modelType = null;
        try {
            mr = ModelUtil.getModel((Object)eObject);
            modelType = mr.getModelAnnotation().getModelType();
        }
        catch (ModelWorkspaceException e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
            return;
        }
        if (!modelType.equals(ModelType.VIRTUAL_LITERAL)) {
            return;
        }
        String theMethod = RestModelExtensionAssistant.getRestProperty(eObject, RestModelExtensionConstants.PropertyIds.REST_METHOD);
        String theUri = RestModelExtensionAssistant.getRestProperty(eObject, RestModelExtensionConstants.PropertyIds.URI);
        if (StringUtilities.isEmpty((String)theMethod) && StringUtilities.isEmpty((String)theUri)) {
            return;
        }
        if (!StringUtilities.isEmpty((String)theMethod) && !StringUtilities.isEmpty((String)theUri)) {
            return;
        }
        String name = ModelerCore.getModelEditor().getName(eObject);
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        String msg = this.getWarningMessage(StringUtilities.isEmpty((String)theMethod), StringUtilities.isEmpty((String)theUri), name);
        ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg);
        result.addProblem((ValidationProblem)problem);
        context.addResult((ValidationResult)result);
        context.recordRuleRun(eObject, this.ruleName);
    }

    protected String computeSignature(EObject eObject) {
        return PushdownFunctionUtil.getSignature((Procedure)eObject);
    }

    protected String getWarningMessage(boolean noMethod, boolean noUri, String procedureName) {
        String msg = RelationalPlugin.Util.getString("ViewProcedureValidationRule.Missing_rest_method_property", (Object)procedureName);
        if (noUri) {
            msg = RelationalPlugin.Util.getString("ViewProcedureValidationRule.Missing_rest_uri_property", (Object)procedureName);
        }
        return msg;
    }
}

