/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.extension;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.extension.EmfModelObjectExtensionAssistant;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.relational.extension.CoreModelExtensionConstants;

public class CoreModelExtensionAssistant
extends EmfModelObjectExtensionAssistant {
    private static String getPropertyId(String propName) {
        return ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)CoreModelExtensionConstants.NAMESPACE_PROVIDER, (String)propName);
    }

    protected ModelExtensionPropertyDefinition getPropertyDefinition(Object modelObject, String propId) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        ModelExtensionPropertyDefinition propDefn = super.getPropertyDefinition(modelObject, propId);
        if (propDefn != null && modelObject instanceof ModelAnnotation) {
            if (PropertyName.same(PropertyName.LOCKED, propId) || PropertyName.same(PropertyName.VDB_NAME, propId) || PropertyName.same(PropertyName.VDB_VERSION, propId) || PropertyName.same(PropertyName.DIAGRAM_LOCKED, propId)) {
                return propDefn;
            }
            return null;
        }
        return null;
    }

    public void setPropertyValue(Object modelObject, String propId, String newValue) throws Exception {
        super.setPropertyValue(modelObject, propId, newValue);
    }

    public boolean isModelLocked(ModelResource modelResource) throws Exception {
        if (modelResource.getModelAnnotation() != null) {
            String locked = super.getPropertyValue((Object)modelResource.getModelAnnotation(), PropertyName.LOCKED.toString());
            return Boolean.parseBoolean(locked);
        }
        return false;
    }

    public String getVdbName(ModelResource modelResource) throws Exception {
        if (modelResource.getModelAnnotation() != null) {
            String name = super.getPropertyValue((Object)modelResource.getModelAnnotation(), PropertyName.VDB_NAME.toString());
            return name;
        }
        return null;
    }

    public String getVdbVersion(ModelResource modelResource) throws Exception {
        if (modelResource.getModelAnnotation() != null) {
            String version = super.getPropertyValue((Object)modelResource.getModelAnnotation(), PropertyName.VDB_VERSION.toString());
            return version;
        }
        return null;
    }

    public boolean isVdbSourceModel(ModelResource modelResource) throws Exception {
        if (modelResource.getModelAnnotation() != null) {
            String name = super.getPropertyValue((Object)modelResource.getModelAnnotation(), PropertyName.VDB_NAME.toString());
            return name != null;
        }
        return false;
    }

    static /* synthetic */ String access$0(String string) {
        return CoreModelExtensionAssistant.getPropertyId(string);
    }

    private static enum PropertyName {
        LOCKED(CoreModelExtensionAssistant.access$0("locked")),
        VDB_NAME(CoreModelExtensionAssistant.access$0("vdb-name")),
        VDB_VERSION(CoreModelExtensionAssistant.access$0("vdb-version")),
        DIAGRAM_LOCKED(CoreModelExtensionAssistant.access$0("diagram-locked"));

        private final String propName;

        public static boolean same(PropertyName propName, String value) {
            return propName.toString().equals(value);
        }

        private PropertyName(String propName) {
            this.propName = propName;
        }

        public String toString() {
            return this.propName;
        }
    }
}

