/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.extension;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.EmfModelObjectExtensionAssistant;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;

public class RelationalModelExtensionAssistant
extends EmfModelObjectExtensionAssistant {
    private static String getPropertyId(String propName) {
        return ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)RelationalModelExtensionConstants.NAMESPACE_PROVIDER, (String)propName);
    }

    public static RelationalModelExtensionAssistant getRelationalAssistant() {
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        String prefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
        return (RelationalModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
    }

    public void applyMedIfNecessary(IResource model) throws Exception {
        ModelResource modelResource;
        if (!(model == null || (modelResource = ModelerCore.getModelWorkspace().findModelResource(model)) == null || modelResource.isReadOnly() || ModelType.PHYSICAL_LITERAL != modelResource.getModelType() && ModelType.VIRTUAL_LITERAL != modelResource.getModelType() || !"http://www.metamatrix.com/metamodels/Relational".equals(modelResource.getPrimaryMetamodelUri()) || this.supportsMyNamespace(model))) {
            this.saveModelExtensionDefinition(model);
        }
    }

    protected ModelExtensionPropertyDefinition getPropertyDefinition(Object modelObject, String propId) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        ModelExtensionPropertyDefinition propDefn = super.getPropertyDefinition(modelObject, propId);
        if (propDefn != null) {
            if (ModelUtil.isVirtual((Object)modelObject) && modelObject instanceof View) {
                return null;
            }
            boolean isPhysical = ModelUtil.isPhysical((Object)modelObject);
            boolean isFunction = false;
            if (modelObject instanceof Procedure) {
                isFunction = ((Procedure)modelObject).isFunction();
            }
            if (PropertyName.same(PropertyName.NATIVE_QUERY, propId)) {
                if ((modelObject instanceof Table || modelObject instanceof Procedure) && isPhysical) {
                    return propDefn;
                }
                return null;
            }
            if (PropertyName.same(PropertyName.GLOBAL_TEMP_TABLE, propId)) {
                if (modelObject instanceof Table && !isPhysical) {
                    return propDefn;
                }
                return null;
            }
            if (PropertyName.same(PropertyName.NATIVE_TYPE, propId)) {
                if (modelObject instanceof ProcedureParameter && isPhysical && ((ProcedureParameter)modelObject).getDirection() == DirectionKind.OUT_LITERAL) {
                    return propDefn;
                }
                return null;
            }
            if (PropertyName.same(PropertyName.ALLOW_JOIN, propId)) {
                if (modelObject instanceof ForeignKey && isPhysical) {
                    return propDefn;
                }
                return null;
            }
            if (PropertyName.same(PropertyName.NON_PREPARED, propId)) {
                if (modelObject instanceof Procedure && isPhysical) {
                    return propDefn;
                }
                return null;
            }
            if (PropertyName.same(PropertyName.JAVA_CLASS, propId) || PropertyName.same(PropertyName.JAVA_METHOD, propId) || PropertyName.same(PropertyName.FUNCTION_CATEGORY, propId) || PropertyName.same(PropertyName.UDF_JAR_PATH, propId) || PropertyName.same(PropertyName.VARARGS, propId) || PropertyName.same(PropertyName.NULL_ON_NULL, propId) || PropertyName.same(PropertyName.DETERMINISTIC, propId) || PropertyName.same(PropertyName.AGGREGATE, propId)) {
                if (modelObject instanceof Procedure && isFunction) {
                    return propDefn;
                }
                this.removeProperty(modelObject, PropertyName.DETERMINISTIC.toString());
                this.removeProperty(modelObject, PropertyName.JAVA_CLASS.toString());
                this.removeProperty(modelObject, PropertyName.JAVA_METHOD.toString());
                this.removeProperty(modelObject, PropertyName.FUNCTION_CATEGORY.toString());
                this.removeProperty(modelObject, PropertyName.UDF_JAR_PATH.toString());
                this.removeProperty(modelObject, PropertyName.VARARGS.toString());
                this.removeProperty(modelObject, PropertyName.NULL_ON_NULL.toString());
                this.removeProperty(modelObject, PropertyName.AGGREGATE.toString());
                this.removeProperty(modelObject, PropertyName.ANALYTIC.toString());
                this.removeProperty(modelObject, PropertyName.ALLOWS_ORDER_BY.toString());
                this.removeProperty(modelObject, PropertyName.USES_DISTINCT_ROWS.toString());
                this.removeProperty(modelObject, PropertyName.DECOMPOSABLE.toString());
                this.removeProperty(modelObject, PropertyName.ALLOWS_DISTINCT.toString());
                return null;
            }
            if (PropertyName.same(PropertyName.ANALYTIC, propId) || PropertyName.same(PropertyName.ALLOWS_ORDER_BY, propId) || PropertyName.same(PropertyName.USES_DISTINCT_ROWS, propId) || PropertyName.same(PropertyName.ALLOWS_DISTINCT, propId) || PropertyName.same(PropertyName.DECOMPOSABLE, propId)) {
                if (modelObject instanceof Procedure) {
                    String isAggregate = this.getPropertyValue(modelObject, PropertyName.AGGREGATE.toString());
                    if (Boolean.parseBoolean(isAggregate)) {
                        return propDefn;
                    }
                    this.removeProperty(modelObject, PropertyName.ANALYTIC.toString());
                    this.removeProperty(modelObject, PropertyName.ALLOWS_ORDER_BY.toString());
                    this.removeProperty(modelObject, PropertyName.USES_DISTINCT_ROWS.toString());
                    this.removeProperty(modelObject, PropertyName.DECOMPOSABLE.toString());
                    this.removeProperty(modelObject, PropertyName.ALLOWS_DISTINCT.toString());
                }
                return null;
            }
            if (modelObject instanceof Table && isPhysical) {
                if (PropertyName.same(PropertyName.MATERIALIZED_STAGE_TABLE, propId) || PropertyName.same(PropertyName.MATVIEW_AFTER_LOAD_SCRIPT, propId) || PropertyName.same(PropertyName.MATVIEW_BEFORE_LOAD_SCRIPT, propId) || PropertyName.same(PropertyName.MATVIEW_LOAD_SCRIPT, propId) || PropertyName.same(PropertyName.MATVIEW_ONERROR_ACTION, propId) || PropertyName.same(PropertyName.MATVIEW_SHARE_SCOPE, propId) || PropertyName.same(PropertyName.MATVIEW_STATUS_TABLE, propId) || PropertyName.same(PropertyName.MATVIEW_TTL, propId) || PropertyName.same(PropertyName.ON_VDB_DROP_SCRIPT, propId) || PropertyName.same(PropertyName.ON_VDB_START_SCRIPT, propId)) {
                    this.removeProperty(modelObject, PropertyName.MATERIALIZED_STAGE_TABLE.toString());
                    this.removeProperty(modelObject, PropertyName.MATVIEW_AFTER_LOAD_SCRIPT.toString());
                    this.removeProperty(modelObject, PropertyName.MATVIEW_BEFORE_LOAD_SCRIPT.toString());
                    this.removeProperty(modelObject, PropertyName.MATVIEW_LOAD_SCRIPT.toString());
                    this.removeProperty(modelObject, PropertyName.MATVIEW_ONERROR_ACTION.toString());
                    this.removeProperty(modelObject, PropertyName.MATVIEW_SHARE_SCOPE.toString());
                    this.removeProperty(modelObject, PropertyName.MATVIEW_STATUS_TABLE.toString());
                    this.removeProperty(modelObject, PropertyName.MATVIEW_TTL.toString());
                    this.removeProperty(modelObject, PropertyName.ON_VDB_DROP_SCRIPT.toString());
                    this.removeProperty(modelObject, PropertyName.ON_VDB_START_SCRIPT.toString());
                }
                return null;
            }
            return propDefn;
        }
        return null;
    }

    public void setPropertyValue(Object modelObject, String propId, String newValue) throws Exception {
        boolean isVirtual = ModelUtil.isVirtual((Object)modelObject);
        if (isVirtual && !PropertyName.same(PropertyName.NON_PREPARED, propId)) {
            super.setPropertyValue(modelObject, propId, newValue);
        } else if (!isVirtual && PropertyName.same(PropertyName.NATIVE_QUERY, propId)) {
            super.setPropertyValue(modelObject, propId, newValue);
        } else if (!isVirtual && PropertyName.same(PropertyName.NATIVE_TYPE, propId)) {
            super.setPropertyValue(modelObject, propId, newValue);
        }
        if (PropertyName.same(PropertyName.AGGREGATE, propId) && !Boolean.parseBoolean(newValue)) {
            this.removeProperty(modelObject, PropertyName.ANALYTIC.toString());
            this.removeProperty(modelObject, PropertyName.ALLOWS_ORDER_BY.toString());
            this.removeProperty(modelObject, PropertyName.USES_DISTINCT_ROWS.toString());
            this.removeProperty(modelObject, PropertyName.ALLOWS_DISTINCT.toString());
            this.removeProperty(modelObject, PropertyName.DECOMPOSABLE.toString());
        }
    }

    public boolean supportsMedOperation(String proposedOperationName, Object context) {
        CoreArgCheck.isNotEmpty((String)proposedOperationName, (String)"proposedOperationName is empty");
        return "SHOW_IN_REGISTRY".equals(proposedOperationName);
    }

    public boolean supportsProperty(Object modelObject, String propId) throws Exception {
        return this.getPropertyDefinition(modelObject, propId) != null;
    }

    static /* synthetic */ String access$0(String string) {
        return RelationalModelExtensionAssistant.getPropertyId(string);
    }

    private static enum PropertyName {
        AGGREGATE(RelationalModelExtensionAssistant.access$0("aggregate")),
        ALLOWS_ORDER_BY(RelationalModelExtensionAssistant.access$0("allows-orderby")),
        ALLOWS_DISTINCT(RelationalModelExtensionAssistant.access$0("allows-distinct")),
        ANALYTIC(RelationalModelExtensionAssistant.access$0("analytic")),
        DECOMPOSABLE(RelationalModelExtensionAssistant.access$0("decomposable")),
        DETERMINISTIC(RelationalModelExtensionAssistant.access$0("deterministic")),
        NATIVE_QUERY(RelationalModelExtensionAssistant.access$0("native-query")),
        NON_PREPARED(RelationalModelExtensionAssistant.access$0("non-prepared")),
        USES_DISTINCT_ROWS(RelationalModelExtensionAssistant.access$0("uses-distinct-rows")),
        VARARGS(RelationalModelExtensionAssistant.access$0("varargs")),
        NULL_ON_NULL(RelationalModelExtensionAssistant.access$0("null-on-null")),
        JAVA_CLASS(RelationalModelExtensionAssistant.access$0("java-class")),
        JAVA_METHOD(RelationalModelExtensionAssistant.access$0("java-method")),
        FUNCTION_CATEGORY(RelationalModelExtensionAssistant.access$0("function-category")),
        UDF_JAR_PATH(RelationalModelExtensionAssistant.access$0("udfJarPath")),
        ALLOW_JOIN(RelationalModelExtensionAssistant.access$0("allow-join")),
        NATIVE_TYPE(RelationalModelExtensionAssistant.access$0("native_type")),
        GLOBAL_TEMP_TABLE(RelationalModelExtensionAssistant.access$0("global-temp-table")),
        ALLOW_MATVIEW_MANAGEMENT(RelationalModelExtensionAssistant.access$0("ALLOW_MATVIEW_MANAGEMENT")),
        MATVIEW_STATUS_TABLE(RelationalModelExtensionAssistant.access$0("MATVIEW_STATUS_TABLE")),
        MATVIEW_BEFORE_LOAD_SCRIPT(RelationalModelExtensionAssistant.access$0("MATVIEW_BEFORE_LOAD_SCRIPT")),
        MATVIEW_LOAD_SCRIPT(RelationalModelExtensionAssistant.access$0("MATVIEW_LOAD_SCRIPT")),
        MATVIEW_AFTER_LOAD_SCRIPT(RelationalModelExtensionAssistant.access$0("MATVIEW_AFTER_LOAD_SCRIPT")),
        MATVIEW_SHARE_SCOPE(RelationalModelExtensionAssistant.access$0("MATVIEW_SHARE_SCOPE")),
        MATERIALIZED_STAGE_TABLE(RelationalModelExtensionAssistant.access$0("MATERIALIZED_STAGE_TABLE")),
        ON_VDB_START_SCRIPT(RelationalModelExtensionAssistant.access$0("ON_VDB_START_SCRIPT")),
        ON_VDB_DROP_SCRIPT(RelationalModelExtensionAssistant.access$0("ON_VDB_DROP_SCRIPT")),
        MATVIEW_ONERROR_ACTION(RelationalModelExtensionAssistant.access$0("MATVIEW_ONERROR_ACTION")),
        MATVIEW_TTL(RelationalModelExtensionAssistant.access$0("MATVIEW_TTL"));

        private final String propName;

        public static boolean same(PropertyName propName, String value) {
            return propName.toString().equals(value);
        }

        private PropertyName(String propName) {
            this.propName = propName;
        }

        public String toString() {
            return this.propName;
        }
    }
}

