/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.association.AbstractAssociationDescriptor;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.provider.ForeignKeyAssociationProvider;
import org.teiid.designer.metamodels.relational.provider.RelationalEditPlugin;

public class ForeignKeyAssociationDescriptor
extends AbstractAssociationDescriptor {
    private static final String TYPE = "ForeignKeyAssociation";
    private static final String LABEL = RelationalPlugin.Util.getString("ForeignKeyAssociationDescriptor.Foreign_Key_Association_1", new Object[0]);
    private static final String NEW = RelationalPlugin.Util.getString("ForeignKeyAssociationDescriptor.New_1", new Object[0]);
    private boolean overwritePkRef = true;
    private String text = LABEL;

    public ForeignKeyAssociationDescriptor(List eObjects) {
        super(eObjects);
    }

    public String getType() {
        return TYPE;
    }

    public boolean isComplete() {
        List eObjects = this.getEObjects();
        if (eObjects == null || eObjects.isEmpty()) {
            return false;
        }
        if (!ForeignKeyAssociationProvider.containsValidObjects(eObjects, ForeignKeyAssociationProvider.VALID_CLASSES_TYPES)) {
            return false;
        }
        List tables = ForeignKeyAssociationProvider.getTables(eObjects);
        if (tables.size() != 2) {
            return false;
        }
        Table tableA = (Table)tables.get(0);
        Table tableB = (Table)tables.get(1);
        PrimaryKey pkA = ForeignKeyAssociationProvider.getPrimaryKey(eObjects, tableA);
        PrimaryKey pkB = ForeignKeyAssociationProvider.getPrimaryKey(eObjects, tableB);
        if (pkA != null && pkB != null) {
            return false;
        }
        List fKeysA = ForeignKeyAssociationProvider.getForeignKeys(eObjects, tableA);
        List fKeysB = ForeignKeyAssociationProvider.getForeignKeys(eObjects, tableB);
        if (!fKeysA.isEmpty() && !fKeysB.isEmpty()) {
            return false;
        }
        return fKeysA.size() <= 1 && fKeysB.size() <= 1;
    }

    public Object getImage() {
        return RelationalEditPlugin.INSTANCE.getImage("full/obj16/ForeignKey");
    }

    public String getText() {
        return this.text;
    }

    public boolean canCreate() {
        List eObjects = this.getEObjects();
        return ForeignKeyAssociationProvider.containsValidObjects(eObjects, ForeignKeyAssociationProvider.VALID_CLASSES_TYPES);
    }

    public EObject create() {
        if (!this.isComplete()) {
            return null;
        }
        List eObjects = this.getEObjects();
        List selectedObjs = this.getOrderedObjects(eObjects);
        List tables = ForeignKeyAssociationProvider.getTables(selectedObjs);
        BaseTable pkTable = (BaseTable)tables.get(0);
        BaseTable fkTable = (BaseTable)tables.get(1);
        return this.createAssociation(pkTable, fkTable, selectedObjs, this.overwritePkRef);
    }

    protected List getOrderedObjects(List eObjects) {
        List tables = ForeignKeyAssociationProvider.getTables(eObjects);
        BaseTable tableA = (BaseTable)tables.get(0);
        BaseTable tableB = (BaseTable)tables.get(1);
        PrimaryKey pkA = ForeignKeyAssociationProvider.getPrimaryKey(eObjects, tableA);
        PrimaryKey pkB = ForeignKeyAssociationProvider.getPrimaryKey(eObjects, tableB);
        List fKeysA = ForeignKeyAssociationProvider.getForeignKeys(eObjects, tableA);
        List fKeysB = ForeignKeyAssociationProvider.getForeignKeys(eObjects, tableB);
        List columnsA = ForeignKeyAssociationProvider.getColumns(eObjects, tableA);
        List columnsB = ForeignKeyAssociationProvider.getColumns(eObjects, tableB);
        boolean sortFromAtoB = true;
        boolean orderIsSet = false;
        if (pkB != null) {
            sortFromAtoB = false;
            orderIsSet = true;
        }
        if (!fKeysA.isEmpty() && !orderIsSet) {
            sortFromAtoB = false;
            orderIsSet = true;
        }
        if (tableA.getPrimaryKey() == null && tableB.getPrimaryKey() != null && !orderIsSet) {
            sortFromAtoB = false;
            orderIsSet = true;
        }
        ArrayList<RelationalEntity> result = new ArrayList<RelationalEntity>(eObjects.size() + 2);
        if (sortFromAtoB) {
            result.add(tableA);
            result.add(pkA);
            result.addAll(columnsA);
            result.addAll(fKeysA);
            result.add(tableB);
            result.add(pkB);
            result.addAll(columnsB);
            result.addAll(fKeysB);
        } else {
            result.add(tableB);
            result.add(pkB);
            result.addAll(columnsB);
            result.addAll(fKeysB);
            result.add(tableA);
            result.add(pkA);
            result.addAll(columnsA);
            result.addAll(fKeysA);
        }
        return result;
    }

    protected EObject createAssociation(BaseTable pkTable, BaseTable fkTable, List selectedObjs, boolean resetPkRefOnFk) {
        CoreArgCheck.isNotNull((Object)pkTable);
        CoreArgCheck.isNotNull((Object)fkTable);
        List pkColumns = ForeignKeyAssociationProvider.getColumns(selectedObjs, pkTable);
        PrimaryKey pk = pkTable.getPrimaryKey();
        if (pk == null) {
            pk = RelationalFactory.eINSTANCE.createPrimaryKey();
            pk.setTable(pkTable);
            pk.setName(String.valueOf(NEW) + pk.eClass().getName());
        }
        if (!pkColumns.isEmpty() && pk.getColumns().isEmpty()) {
            pk.getColumns().addAll((Collection)pkColumns);
        }
        List fkColumns = ForeignKeyAssociationProvider.getColumns(selectedObjs, fkTable);
        List fkeys = ForeignKeyAssociationProvider.getForeignKeys(selectedObjs, fkTable);
        ForeignKey fk = null;
        if (fkeys.isEmpty()) {
            fk = RelationalFactory.eINSTANCE.createForeignKey();
            fk.setTable(fkTable);
            fk.setUniqueKey(pk);
        } else {
            fk = (ForeignKey)fkeys.get(0);
            if (resetPkRefOnFk) {
                fk.setUniqueKey(pk);
            }
        }
        if (!fkColumns.isEmpty() && fk.getColumns().isEmpty()) {
            fk.getColumns().addAll((Collection)fkColumns);
        }
        return fk;
    }

    protected void setText(String string) {
        this.text = string;
    }

    protected void setOverwritePkRef(boolean b) {
        this.overwritePkRef = b;
    }
}

