/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.util.ParameterData;

public class PushdownFunctionData {
    String name;
    String description;
    boolean deterministic;
    String nameInSource;
    Collection<ParameterData> inputParameters;
    ParameterData returnParameter;
    public static String DEFAULT_TYPE = "string";
    public static int DEFAULT_LENGTH = 255;
    public static String DETERMINISTIC_PROPERTY_KEY = "ext-custom:deterministic";
    private StringNameValidator validator = new StringNameValidator(1, 200, false);

    public PushdownFunctionData() {
        this.inputParameters = new ArrayList<ParameterData>();
    }

    public void setToDefault(String name, String description, int numParams, int maxParams) {
        this.setName(name);
        this.setDescription(description);
        ParameterData param = null;
        ArrayList<ParameterData> params = new ArrayList<ParameterData>(5);
        int i = 0;
        while (i < numParams) {
            param = new ParameterData("", DEFAULT_TYPE, DEFAULT_LENGTH);
            param.include();
            params.add(param);
            ++i;
        }
        i = numParams;
        while (i < maxParams) {
            param = new ParameterData("", DEFAULT_TYPE, DEFAULT_LENGTH);
            params.add(param);
            ++i;
        }
        this.setInputParameters(params);
        this.setReturnParameterName("");
        this.setReturnParameterLength(DEFAULT_LENGTH);
        this.setReturnParameterType(DEFAULT_TYPE);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNameInSource() {
        return this.nameInSource;
    }

    public void setNameInSource(String nameInSource) {
        this.nameInSource = nameInSource;
    }

    public boolean getDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public String getReturnParameterName() {
        if (this.returnParameter != null) {
            return this.returnParameter.getName();
        }
        return null;
    }

    public ParameterData getReturnParameterData() {
        return this.returnParameter;
    }

    public void setReturnParameterName(String returnParameterName) {
        if (this.returnParameter == null) {
            this.returnParameter = new ParameterData(returnParameterName, DEFAULT_TYPE, DEFAULT_LENGTH);
        } else {
            this.returnParameter.setName(returnParameterName);
        }
    }

    public String getReturnParameterType() {
        if (this.returnParameter != null) {
            return this.returnParameter.getType();
        }
        return null;
    }

    public int getReturnParameterLength() {
        if (this.returnParameter != null) {
            return this.returnParameter.getLength();
        }
        return 255;
    }

    public void setReturnParameterLength(int length) {
        if (this.returnParameter != null) {
            this.returnParameter.setLength(length);
        }
    }

    public void setReturnParameterType(String returnParameterType) {
        if (this.returnParameter != null) {
            this.returnParameter.setType(returnParameterType);
        }
    }

    public Collection<ParameterData> getInputParameters() {
        return this.inputParameters;
    }

    public void addInputParameter(String name, String type, int length) {
        CoreArgCheck.isNotNull((Object)name, (String)"name");
        CoreArgCheck.isNotNull((Object)name, (String)"type");
        if (!this.inputParameterExists(name)) {
            this.inputParameters.add(new ParameterData(name, type, length));
        }
    }

    public void setInputParameters(Collection<ParameterData> params) {
        this.inputParameters.clear();
        this.inputParameters.addAll(params);
    }

    public void addInputParameter(ParameterData param) {
        CoreArgCheck.isNotNull((Object)param, (String)"data");
        if (!this.inputParameterExists(param.getName())) {
            this.inputParameters.add(param);
        }
    }

    public boolean inputParameterExists(String name) {
        for (ParameterData data : this.inputParameters) {
            if (!data.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public ParameterData getParameterData(int index) {
        int nParams = this.inputParameters.size();
        if (index < nParams) {
            return (ParameterData)((ArrayList)this.inputParameters).get(index);
        }
        return null;
    }

    public void setInputParameterData(int index, String name, String type, int length) {
        int nParams = this.inputParameters.size();
        if (index < nParams) {
            ParameterData data = (ParameterData)((ArrayList)this.inputParameters).get(index);
            data.setName(name);
            data.setType(type);
            data.setLength(length);
        }
    }

    public void removeInputLastParameter() {
        int nParams = this.inputParameters.size();
        if (nParams > 0) {
            ((ArrayList)this.inputParameters).remove(nParams - 1);
        }
    }

    public IStatus validate() {
        Status status = new Status(0, "org.teiid.designer.metamodels.relational", "OK");
        String errorMessage = this.validator.checkValidName(this.name);
        if (errorMessage != null) {
            return new Status(4, "org.teiid.designer.metamodels.relational", errorMessage);
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        for (ParameterData param : this.getInputParameters()) {
            if (!param.isIncluded()) continue;
            errorMessage = this.validator.checkValidName(param.getName());
            if (errorMessage != null) {
                return new Status(4, "org.teiid.designer.metamodels.relational", RelationalPlugin.Util.getString("PushdownFunctionData.invalidInputParameterName", (Object)errorMessage));
            }
            int length = param.getLength();
            if (length < 0 || length > 65000) {
                return new Status(4, "org.teiid.designer.metamodels.relational", RelationalPlugin.Util.getString("PushdownFunctionData.invalidParameterLength", (Object)Integer.toString(length)));
            }
            if (paramNames.contains(param.getName().toUpperCase())) {
                return new Status(4, "org.teiid.designer.metamodels.relational", RelationalPlugin.Util.getString("PushdownFunctionData.duplicateInputParameterName", (Object)param.getName()));
            }
            paramNames.add(param.getName().toUpperCase());
        }
        errorMessage = this.validator.checkValidName(this.getReturnParameterName());
        if (errorMessage != null) {
            return new Status(4, "org.teiid.designer.metamodels.relational", RelationalPlugin.Util.getString("PushdownFunctionData.invalidReturnParameterName", (Object)errorMessage));
        }
        return status;
    }

    public EObject getDatatype(String type) {
        EObject datatype = null;
        try {
            datatype = ModelerCore.getBuiltInTypesManager().findDatatype(type);
        }
        catch (ModelerCoreException ex) {
            ex.printStackTrace();
        }
        return datatype;
    }
}

