/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.common.util.DirtyEditorTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CommonPlugin
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.common";
    protected static CommonPlugin instance;
    private static String environment;

    public CommonPlugin() {
        instance = this;
    }

    public static CommonPlugin getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DirtyEditorTracker.getInstance();
            }
        });
    }

    public static String getMessage(String key) {
        return Platform.getResourceString((Bundle)instance.getBundle(), (String)key);
    }

    public static String getEnvironment() {
        if (environment == null) {
            String eclipseBuildId;
            String eclipseVersion;
            String studioVersion;
            String studioName;
            String javaVersion;
            String osName;
            block19: {
                Bundle eclipse;
                osName = System.getProperty("os.name");
                javaVersion = System.getProperty("java.version");
                studioName = "unknown";
                studioVersion = "unknown";
                eclipseVersion = "unknown";
                eclipseBuildId = "unknown";
                Bundle studio = Platform.getBundle((String)PLUGIN_ID);
                if (studio != null) {
                    Dictionary studioDic = studio.getHeaders();
                    studioName = (String)studioDic.get("Bundle-Name");
                    studioVersion = (String)studioDic.get("Bundle-Version");
                }
                if ((eclipse = Platform.getBundle((String)"org.eclipse.platform")) != null) {
                    Dictionary eclipseDic = eclipse.getHeaders();
                    eclipseVersion = (String)eclipseDic.get("Bundle-Version");
                    FileInputStream fis = null;
                    try {
                        try {
                            File aboutMappings;
                            String path = FileLocator.resolve((URL)eclipse.getEntry("/")).getPath();
                            if (path != null && (aboutMappings = new File(path, "about.mappings")).exists()) {
                                Properties properties = new Properties();
                                fis = new FileInputStream(aboutMappings);
                                properties.load(fis);
                                String buildId = properties.getProperty("0");
                                if (buildId != null && buildId.length() > 0) {
                                    eclipseBuildId = buildId;
                                }
                            }
                        }
                        catch (IOException e) {
                            CommonPlugin.getPluginLog().logError("Error in getting environment info: " + e.getMessage());
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            StringBuffer result = new StringBuffer(studioName).append(" ").append(studioVersion).append(", Eclipse ").append(eclipseVersion).append(" ").append(eclipseBuildId).append(", Java ").append(javaVersion).append(", ").append(osName);
            environment = result.toString();
        }
        return environment;
    }

    public static CommonPlugin getDefault() {
        return instance;
    }

    public static IPluginLog getPluginLog() {
        return CommonPlugin.getDefault();
    }
}

