/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common;

import java.util.ArrayList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.jboss.tools.common.CommonPlugin;

public class EclipseUtil {
    public static IJavaProject getJavaProject(IProject project) {
        block5: {
            block4: {
                try {
                    if (project != null && project.isOpen()) break block4;
                    return null;
                }
                catch (CoreException e) {
                    CommonPlugin.getPluginLog().logError((Throwable)e);
                    return null;
                }
            }
            if (project.hasNature("org.eclipse.jdt.core.javanature")) break block5;
            return null;
        }
        return JavaCore.create((IProject)project);
    }

    public static String getJavaProjectOutputLocation(IProject project) {
        IJavaProject javaProject = EclipseUtil.getJavaProject(project);
        if (javaProject == null) {
            return null;
        }
        try {
            IPath p = javaProject.getOutputLocation();
            IResource r = project.getWorkspace().getRoot().findMember(p);
            return r == null || r.getLocation() == null ? null : r.getLocation().toString();
        }
        catch (CoreException e) {
            CommonPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    public static IResource[] getJavaSourceRoots(IProject project) {
        IJavaProject javaProject = EclipseUtil.getJavaProject(project);
        if (javaProject == null) {
            return null;
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        try {
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IResource findMember;
                if (es[i].getEntryKind() == 3 && (findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(es[i].getPath())) != null && findMember.exists()) {
                    resources.add(findMember);
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            CommonPlugin.getPluginLog().logError("Error while locating java source roots for " + project, (Throwable)ce);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static ICompilationUnit getCompilationUnit(IFile f) {
        IPackageFragment pkg;
        IJavaProject jp = EclipseUtil.getJavaProject(f.getProject());
        if (jp != null && (pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath((IResource)f, (IJavaProject)jp)) != null) {
            ICompilationUnit result = pkg.getCompilationUnit(f.getName());
            return result.exists() ? result : null;
        }
        return null;
    }

    public static void addNatureToProject(IProject project, String natureId) throws CoreException {
        IProject proj = project.getProject();
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        if (EclipseUtil.findIndex(prevNatures, natureId) != -1) {
            return;
        }
        description.setNatureIds(EclipseUtil.append(prevNatures, natureId));
        proj.setDescription(description, null);
    }

    public static void addBuilderToProject(IProject project, String builderId) throws CoreException {
        ICommand[] existing;
        IProjectDescription desc = project.getDescription();
        ICommand[] iCommandArray = existing = desc.getBuildSpec();
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (builderId.equals(command.getBuilderName())) {
                return;
            }
            ++n2;
        }
        ICommand[] cmds = new ICommand[existing.length + 1];
        ICommand newcmd = project.getDescription().newCommand();
        newcmd.setBuilderName(builderId);
        cmds[0] = newcmd;
        System.arraycopy(existing, 0, cmds, 1, existing.length);
        desc.setBuildSpec(cmds);
        project.setDescription(desc, null);
    }

    public static void removeNatureFromProject(IProject project, String natureId) throws CoreException {
        IProject proj = project.getProject();
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        int natureIndex = EclipseUtil.findIndex(prevNatures, natureId);
        if (natureIndex == -1) {
            return;
        }
        description.setNatureIds(EclipseUtil.remove(prevNatures, natureIndex));
        proj.setDescription(description, null);
    }

    protected static String[] remove(String[] os, int index) {
        String[] ns = new String[os.length - 1];
        System.arraycopy(os, 0, ns, 0, index);
        System.arraycopy(os, index + 1, ns, index, os.length - (index + 1));
        return ns;
    }

    protected static int findIndex(String[] os, String s) {
        int i = 0;
        while (i < os.length) {
            if (os[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static String[] append(String[] os, String s) {
        String[] ns = new String[os.length + 1];
        System.arraycopy(os, 0, ns, 0, os.length);
        ns[os.length] = s;
        return ns;
    }
}

