/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.refactoring.BaseFileChange;
import org.jboss.tools.common.refactoring.BaseJavaFileChange;

public class FileChangeFactory {
    public static TextFileChange getFileChange(IFile file) {
        ICompilationUnit compilationUnit = EclipseUtil.getCompilationUnit(file);
        if (compilationUnit != null) {
            return new BaseJavaFileChange("", compilationUnit);
        }
        return new BaseFileChange(file);
    }

    public static boolean isOpenInEditor(IFile file) throws PartInitException {
        IEditorInput input = EditorUtility.getEditorInput((Object)file);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    IEditorPart editor = editorReference.getEditor(true);
                    if (editor != null && editor.getEditorInput().equals(input)) {
                        return true;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }
}

