/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.CommonPlugin;

public class DirtyEditorTracker
implements IWindowListener,
IPageListener,
IPartListener,
IPropertyListener {
    static DirtyEditorTracker INSTANCE;
    private Set<IFile> dirtyFiles = new HashSet<IFile>();
    private Map<IFile, Integer> openEditors = new HashMap<IFile, Integer>();

    private DirtyEditorTracker() {
        this.init();
    }

    public static DirtyEditorTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DirtyEditorTracker();
        }
        return INSTANCE;
    }

    private void init() {
        IWorkbench workbench;
        if (PlatformUI.isWorkbenchRunning() && (workbench = CommonPlugin.getDefault().getWorkbench()) != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                this.windowOpened(window);
                ++n2;
            }
            CommonPlugin.getDefault().getWorkbench().addWindowListener((IWindowListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IFile> getDirtyFiles() {
        HashSet<IFile> result = new HashSet<IFile>();
        DirtyEditorTracker dirtyEditorTracker = this;
        synchronized (dirtyEditorTracker) {
            result.addAll(this.dirtyFiles);
        }
        return result;
    }

    public synchronized boolean isDirty(IFile file) {
        return this.dirtyFiles.contains(file);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        IWorkbenchPage[] pages;
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.pageClosed(page);
            ++n2;
        }
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (window.getShell() != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                this.pageOpened(page);
                ++n2;
            }
            window.addPageListener((IPageListener)this);
        }
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        IEditorReference[] rs;
        IEditorReference[] iEditorReferenceArray = rs = page.getEditorReferences();
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference r = iEditorReferenceArray[n2];
            IEditorPart part = r.getEditor(false);
            if (part != null) {
                this.editorClosed(part);
            }
            ++n2;
        }
        page.removePartListener((IPartListener)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        IEditorReference[] rs;
        IEditorReference[] iEditorReferenceArray = rs = page.getEditorReferences();
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference r = iEditorReferenceArray[n2];
            IEditorPart part = r.getEditor(false);
            if (part != null) {
                this.editorOpened(part);
            }
            ++n2;
        }
        page.addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorClosed((IEditorPart)part);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorOpened((IEditorPart)part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editorOpened(IEditorPart part) {
        IFile file = this.getFile(part);
        if (file != null) {
            part.addPropertyListener((IPropertyListener)this);
            DirtyEditorTracker dirtyEditorTracker = this;
            synchronized (dirtyEditorTracker) {
                Integer i = this.openEditors.get(file);
                int k = i == null ? 1 : i + 1;
                this.openEditors.put(file, k);
            }
            this.update(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editorClosed(IEditorPart part) {
        part.removePropertyListener((IPropertyListener)this);
        IFile file = this.getFile(part);
        if (file != null) {
            DirtyEditorTracker dirtyEditorTracker = this;
            synchronized (dirtyEditorTracker) {
                Integer i = this.openEditors.get(file);
                if (i != null) {
                    if (i < 2) {
                        this.openEditors.remove(file);
                        this.update(file, false);
                    } else {
                        this.openEditors.put(file, i - 1);
                    }
                }
            }
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257 && source instanceof IEditorPart) {
            this.update((IEditorPart)source);
        }
    }

    private IFile getFile(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        return input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    private void update(IEditorPart part) {
        IFile f = this.getFile(part);
        if (f != null) {
            this.update(f, part.isDirty());
        }
    }

    private synchronized void update(IFile file, boolean isDirty) {
        if (isDirty) {
            if (!this.dirtyFiles.contains(file)) {
                this.dirtyFiles.add(file);
            }
        } else if (this.dirtyFiles.contains(file)) {
            this.dirtyFiles.remove(file);
        }
    }
}

